/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.cloud;

import com.bc.jnn.Jnn;
import com.bc.jnn.JnnException;
import com.bc.jnn.JnnNet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class CloudAlgorithm
implements Cloneable {
    private static final String PARAM_1_KEY = "param_1";
    private static final String PARAM_2_KEY = "param_2";
    private static final String VALID_KEY = "validExpression";
    private JnnNet neuralNet;
    private String validExpression;
    private double param1;
    private double param2;
    private double[] minInputValuesNN = new double[15];
    private double[] maxInputValuesNN = new double[15];

    public CloudAlgorithm(File auxDataDir, String configName) throws IOException {
        File propertiesFile = new File(auxDataDir, configName);
        FileInputStream propertiesStream = new FileInputStream(propertiesFile);
        Properties properties = new Properties();
        properties.load(propertiesStream);
        this.validExpression = properties.getProperty(VALID_KEY, "");
        this.param1 = Double.parseDouble(properties.getProperty(PARAM_1_KEY));
        this.param2 = Double.parseDouble(properties.getProperty(PARAM_2_KEY));
        for (int i = 0; i < 15; ++i) {
            this.minInputValuesNN[i] = Double.parseDouble(properties.getProperty("min_" + (i + 1)));
            this.maxInputValuesNN[i] = Double.parseDouble(properties.getProperty("max_" + (i + 1)));
        }
        String neuralNetName = properties.getProperty("neural_net");
        File neuralNetFile = new File(auxDataDir, neuralNetName);
        try {
            this.loadNeuralNet(neuralNetFile);
        }
        catch (Exception e) {
            throw new IOException("Failed to load neural net " + neuralNetName + ":\n" + e.getMessage());
        }
    }

    private void loadNeuralNet(File neuralNetFile) throws IOException, JnnException {
        Jnn.setOptimizing((boolean)true);
        this.neuralNet = Jnn.readNna((File)neuralNetFile);
    }

    public double computeCloudProbability(double[] cloudIn) {
        for (int j = 0; j < 15; ++j) {
            double q = cloudIn[j];
            if (q < this.minInputValuesNN[j]) {
                cloudIn[j] = this.minInputValuesNN[j];
                continue;
            }
            if (!(q > this.maxInputValuesNN[j])) continue;
            cloudIn[j] = this.maxInputValuesNN[j];
        }
        double nnResult = this.computeCloud(cloudIn);
        return this.nn2Probability(nnResult);
    }

    protected double computeCloud(double[] cloudIn) {
        double[] output = new double[1];
        this.neuralNet.process(cloudIn, output);
        return output[0];
    }

    protected double nn2Probability(double nnResult) {
        double a = this.param2 * (nnResult + this.param1) * -1.0;
        if (a < -80.0) {
            a = -80.0;
        } else if (a > 80.0) {
            a = 80.0;
        }
        return 1.0 / (1.0 + Math.exp(a));
    }

    protected CloudAlgorithm clone() throws CloneNotSupportedException {
        try {
            CloudAlgorithm clone = (CloudAlgorithm)super.clone();
            clone.neuralNet = this.neuralNet.clone();
            clone.validExpression = this.validExpression;
            clone.param1 = this.param1;
            clone.param2 = this.param2;
            clone.minInputValuesNN = (double[])this.minInputValuesNN.clone();
            System.arraycopy(this.minInputValuesNN, 0, clone.minInputValuesNN, 0, this.minInputValuesNN.length);
            clone.maxInputValuesNN = (double[])this.maxInputValuesNN.clone();
            System.arraycopy(this.maxInputValuesNN, 0, clone.maxInputValuesNN, 0, this.maxInputValuesNN.length);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

