/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.cloud;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.HashMap;
import org.esa.s3tbx.meris.MerisBasisOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.common.BandMathsOp;

@OperatorMetadata(alias="Meris.BlueBand", internal=true)
public class BlueBandOp
extends MerisBasisOp {
    public static final int FLAG_CLEAR = 1;
    public static final int FLAG_SNOW = 2;
    public static final int FLAG_DENSE_CLOUD = 4;
    public static final int FLAG_THIN_CLOUD = 8;
    public static final int FLAG_SNOW_INDEX = 16;
    public static final int FLAG_SNOW_PLAUSIBLE = 32;
    public static final int FLAG_BRIGHT_LAND = 64;
    public static final int CLEAR_BIT = 0;
    public static final int SNOW_BIT = 1;
    public static final int DENSE_CLOUD_BIT = 2;
    public static final int THIN_CLOUD_BIT = 3;
    public static final int SNOW_INDEX_BIT = 4;
    public static final int SNOW_PLAUSIBLE_BIT = 5;
    public static final int BRIGHT_LAND_BIT = 6;
    public static final String BLUE_FLAG_BAND = "blue_cloud";
    private static final float D_BBT = 0.25f;
    private static final float D_ASS = 0.4f;
    private static final float R1_BBT = -1.0f;
    private static final float R2_BBT = 0.01f;
    private static final float R3_BBT = 0.1f;
    private static final float R4_BBT = 0.95f;
    private static final float R5_BBT = 0.05f;
    private static final float R6_BBT = 0.6f;
    private static final float R7_BBT = 0.45f;
    private static final float R1_ASS = 0.95f;
    private static final float R2_ASS = 0.05f;
    private static final float R3_ASS = 0.6f;
    private static final float R4_ASS = 0.05f;
    private static final float R5_ASS = 0.5f;
    private static final float LAT_ALWAYS_SNOW = 60.0f;
    private static final float LAT_TROPIC = 30.0f;
    private static final float ALT_MEDIAL = 1000.0f;
    private static final float ALT_TROPIC = 2000.0f;
    private static final int MIN_LAND_ALT = -50;
    private static final float SLOPE2_LOW = 0.65f;
    private static final float SLOPE2_UPPER = 1.075f;
    private static final float TOAR_9_SAT = 0.99f;
    private Band landBand;
    public int month;
    @SourceProduct(alias="l1b")
    private Product l1bProduct;
    @SourceProduct(alias="toar")
    private Product brrProduct;
    @TargetProduct
    private Product targetProduct;

    public void initialize() throws OperatorException {
        this.month = this.l1bProduct.getStartTime().getAsCalendar().get(2);
        this.targetProduct = this.createCompatibleProduct(this.l1bProduct, "MER_BLUEBAND_CLOUD", "MER_L2");
        FlagCoding flagCoding = BlueBandOp.createFlagCoding();
        this.targetProduct.getFlagCodingGroup().add((ProductNode)flagCoding);
        Band cloudFlagBand = this.targetProduct.addBand(BLUE_FLAG_BAND, 20);
        cloudFlagBand.setDescription("blue band cloud flags");
        cloudFlagBand.setSampleCoding((SampleCoding)flagCoding);
        this.landBand = this.createBooleanBandForExpression("$toar.l2_flags_p1.F_LANDCONS or (($toar.l2_flags_p1.F_LAND or $l1b.dem_alt > -50 )and $toar.l2_flags_p1.F_CLOUD)");
    }

    private Band createBooleanBandForExpression(String expression) throws OperatorException {
        HashMap<String, BandMathsOp.BandDescriptor[]> parameters = new HashMap<String, BandMathsOp.BandDescriptor[]>();
        BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[1];
        BandMathsOp.BandDescriptor bandDescriptor = new BandMathsOp.BandDescriptor();
        bandDescriptor.name = "bBand";
        bandDescriptor.expression = expression;
        bandDescriptor.type = "int8";
        bandDescriptors[0] = bandDescriptor;
        parameters.put("targetBands", bandDescriptors);
        HashMap<String, Product> products = new HashMap<String, Product>();
        products.put(this.getSourceProductId(this.l1bProduct), this.l1bProduct);
        products.put(this.getSourceProductId(this.brrProduct), this.brrProduct);
        Product validLandProduct = GPF.createProduct((String)"BandMaths", parameters, products);
        return validLandProduct.getBand("bBand");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle rect = targetTile.getRectangle();
        pm.beginTask("Processing frame...", rect.height);
        try {
            Tile altitude;
            Tile latitude;
            float[] toar1 = (float[])this.getSourceTile((RasterDataNode)this.brrProduct.getBand("toar_1"), rect).getRawSamples().getElems();
            float[] toar7 = (float[])this.getSourceTile((RasterDataNode)this.brrProduct.getBand("toar_7"), rect).getRawSamples().getElems();
            float[] toar9 = (float[])this.getSourceTile((RasterDataNode)this.brrProduct.getBand("toar_9"), rect).getRawSamples().getElems();
            float[] toar10 = (float[])this.getSourceTile((RasterDataNode)this.brrProduct.getBand("toar_10"), rect).getRawSamples().getElems();
            float[] toar11 = (float[])this.getSourceTile((RasterDataNode)this.brrProduct.getBand("toar_11"), rect).getRawSamples().getElems();
            float[] toar13 = (float[])this.getSourceTile((RasterDataNode)this.brrProduct.getBand("toar_13"), rect).getRawSamples().getElems();
            float[] toar14 = (float[])this.getSourceTile((RasterDataNode)this.brrProduct.getBand("toar_14"), rect).getRawSamples().getElems();
            if (this.l1bProduct.getProductType().equals("MER_FSG_1P")) {
                latitude = this.getSourceTile((RasterDataNode)this.l1bProduct.getBand("corr_latitude"), rect);
                altitude = this.getSourceTile((RasterDataNode)this.l1bProduct.getBand("altitude"), rect);
            } else {
                latitude = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("latitude"), rect);
                altitude = this.getSourceTile((RasterDataNode)this.l1bProduct.getTiePointGrid("dem_alt"), rect);
            }
            Tile sourceTile = this.getSourceTile((RasterDataNode)this.landBand, rect);
            ProductData rawSamples = sourceTile.getRawSamples();
            boolean[] safeLand = new boolean[rawSamples.getNumElems()];
            for (int i = 0; i < rawSamples.getNumElems(); ++i) {
                safeLand[i] = rawSamples.getElemBooleanAt(i);
            }
            ProductData rawSampleData = targetTile.getRawSamples();
            byte[] cloudFlagScanLine = (byte[])rawSampleData.getElems();
            int i = 0;
            for (int y = rect.y; y < rect.y + rect.height; ++y) {
                int x = rect.x;
                while (x < rect.x + rect.width) {
                    float ndsi;
                    float ndvi;
                    float po2 = toar11[i] / toar10[i];
                    float alt = altitude.getSampleFloat(x, y);
                    boolean assuredLand = safeLand[i];
                    boolean isSnowPlausible = this.isSnowPlausible(latitude.getSampleFloat(x, y), alt, assuredLand);
                    boolean isBrightLand = this.isBrightLand(toar9[i], toar14[i]);
                    cloudFlagScanLine[i] = toar1[i] >= 0.25f ? (((ndvi = (toar13[i] - toar7[i]) / (toar13[i] + toar7[i])) <= -1.0f * (ndsi = (toar10[i] - toar13[i]) / (toar10[i] + toar13[i])) + 0.01f || ndsi >= 0.1f) && po2 <= 0.45f ? 2 : (toar13[i] <= 0.95f * toar7[i] + 0.05f && toar13[i] <= 0.6f && po2 <= 0.45f ? 2 : 4)) : (alt < 1700.0f && po2 >= 0.4f || alt >= 1700.0f && (double)po2 > 0.04 + (0.31746 + 3.814E-5 * (double)alt) ? (toar13[i] <= 0.95f * toar7[i] + 0.05f && toar13[i] <= 0.6f ? (toar13[i] >= 0.05f && toar7[i] >= 0.5f ? 2 : 1) : 8) : 1);
                    double snowIndex = (toar14[i] - toar13[i]) / (toar14[i] + toar13[i]);
                    if (snowIndex < -0.01) {
                        int n = i;
                        cloudFlagScanLine[n] = (byte)(cloudFlagScanLine[n] + 16);
                    }
                    if (isSnowPlausible) {
                        int n = i;
                        cloudFlagScanLine[n] = (byte)(cloudFlagScanLine[n] + 32);
                    }
                    if (isBrightLand) {
                        int n = i;
                        cloudFlagScanLine[n] = (byte)(cloudFlagScanLine[n] + 64);
                    }
                    ++x;
                    ++i;
                }
                pm.worked(1);
            }
            targetTile.setRawSamples(rawSampleData);
        }
        finally {
            pm.done();
        }
    }

    private boolean isBrightLand(float toar_9, float toar_14) {
        float bsRatio = toar_9 / toar_14;
        return bsRatio >= 0.65f && bsRatio <= 1.075f || toar_9 > 0.99f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSnowPlausible(float lat, float alt, boolean land) {
        if (!land) {
            return false;
        }
        if (lat > 60.0f || lat < -60.0f) {
            return true;
        }
        if (lat <= 60.0f && lat >= 30.0f) {
            if (this.month < 4 || this.month > 10) return true;
            if (!(alt > 1000.0f)) return false;
            return true;
        }
        if (lat >= -60.0f && lat <= -30.0f) {
            if (this.month < 10 && this.month > 4) return true;
            if (!(alt > 1000.0f)) return false;
            return true;
        }
        if (!(lat < 30.0f) || !(lat > -30.0f) || !(alt > 2000.0f)) return false;
        return true;
    }

    public static FlagCoding createFlagCoding() {
        FlagCoding flagCoding = new FlagCoding(BLUE_FLAG_BAND);
        flagCoding.setDescription("Blue Band - Cloud Flag Coding");
        MetadataAttribute cloudAttr = new MetadataAttribute("clear", 20);
        cloudAttr.getData().setElemInt(1);
        flagCoding.addAttribute(cloudAttr);
        cloudAttr = new MetadataAttribute("snow", 20);
        cloudAttr.getData().setElemInt(2);
        flagCoding.addAttribute(cloudAttr);
        cloudAttr = new MetadataAttribute("dense_cloud", 20);
        cloudAttr.getData().setElemInt(4);
        flagCoding.addAttribute(cloudAttr);
        cloudAttr = new MetadataAttribute("thin_cloud", 20);
        cloudAttr.getData().setElemInt(8);
        flagCoding.addAttribute(cloudAttr);
        cloudAttr = new MetadataAttribute("snow_index", 20);
        cloudAttr.getData().setElemInt(16);
        flagCoding.addAttribute(cloudAttr);
        cloudAttr = new MetadataAttribute("snow_plausible", 20);
        cloudAttr.getData().setElemInt(32);
        flagCoding.addAttribute(cloudAttr);
        cloudAttr = new MetadataAttribute("bright_land", 20);
        cloudAttr.getData().setElemInt(64);
        flagCoding.addAttribute(cloudAttr);
        return flagCoding;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(BlueBandOp.class);
        }
    }
}

