/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.brr.operator;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.Map;
import org.esa.s3tbx.meris.brr.dpm.AtmosphericCorrectionLand;
import org.esa.s3tbx.meris.brr.dpm.CloudClassification;
import org.esa.s3tbx.meris.brr.dpm.DpmPixel;
import org.esa.s3tbx.meris.brr.dpm.GaseousAbsorptionCorrection;
import org.esa.s3tbx.meris.brr.dpm.L1bDataExtraction;
import org.esa.s3tbx.meris.brr.dpm.PixelIdentification;
import org.esa.s3tbx.meris.brr.dpm.RayleighCorrection;
import org.esa.s3tbx.meris.brr.operator.BrrBasisOp;
import org.esa.s3tbx.meris.brr.operator.CorrectionSurfaceEnum;
import org.esa.s3tbx.meris.l2auxdata.L2AuxData;
import org.esa.s3tbx.meris.l2auxdata.L2AuxDataProvider;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.BitSetter;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.dataio.envisat.EnvisatConstants;

@OperatorMetadata(alias="Meris.Brr", internal=true, version="2.4", authors="R. Santer, M. Zuehlke, T. Block, O. Danne", copyright="(c) European Space Agency", description="Performs the Rayleigh correction on a MERIS L1b product.", category="Optical/Pre-Processing")
public class BrrOp
extends BrrBasisOp {
    private static final float NODATA_VALUE = -1.0f;
    private RasterDataNode[] tpGrids;
    private RasterDataNode[] l1bRadiance;
    private RasterDataNode detectorIndex;
    private RasterDataNode l1bFlags;
    private final ThreadLocal<DpmPixel[]> frame = new ThreadLocal<DpmPixel[]>(){

        @Override
        protected DpmPixel[] initialValue() {
            return new DpmPixel[0];
        }
    };
    private final ThreadLocal<DpmPixel[][]> block = new ThreadLocal<DpmPixel[][]>(){

        @Override
        protected DpmPixel[][] initialValue() {
            return new DpmPixel[0][0];
        }
    };
    protected Band[] brrReflecBands = new Band[15];
    protected Band[] toaReflecBands = new Band[15];
    @SourceProduct(alias="merisL1bProduct", label="MERIS L1b product", description="The MERIS L1b source product")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="Write L1 flags to the target product.", label="Write L1 flags to the target product.", defaultValue="true")
    public boolean copyL1Flags = true;
    @Parameter(description="Write TOA reflectances to the target product.", label="Write TOA reflectances to the target product.", defaultValue="false")
    public boolean outputToar = false;
    @Parameter(defaultValue="ALL_SURFACES", valueSet={"ALL_SURFACES", "LAND", "WATER"}, label="Perform Rayleigh correction over", description="Specify the surface where the Rayleigh correction shall be performed")
    private CorrectionSurfaceEnum correctionSurface;
    private L2AuxData auxData;

    public void initialize() throws OperatorException {
        this.checkInputProduct(this.sourceProduct);
        this.prepareSourceProducts();
        this.targetProduct = this.createCompatibleProduct(this.sourceProduct, "BRR", "BRR");
        this.targetProduct.setPreferredTileSize(129, 128);
        if (this.copyL1Flags) {
            ProductUtils.copyFlagBands((Product)this.sourceProduct, (Product)this.targetProduct, (boolean)true);
        }
        this.createOutputBands(this.brrReflecBands, "brr");
        if (this.outputToar) {
            this.createOutputBands(this.toaReflecBands, "toar");
        }
        this.initAlgorithms(this.sourceProduct);
    }

    private void initAlgorithms(Product inputProduct) throws OperatorException {
        try {
            this.auxData = L2AuxDataProvider.getInstance().getAuxdata(inputProduct);
        }
        catch (Exception e) {
            throw new OperatorException("Cannot initialize L2 Auxdata:" + e.getMessage(), (Throwable)e);
        }
    }

    protected void prepareSourceProducts() {
        int i;
        int numTPGrids = EnvisatConstants.MERIS_TIE_POINT_GRID_NAMES.length;
        this.tpGrids = new RasterDataNode[numTPGrids];
        for (i = 0; i < numTPGrids; ++i) {
            this.tpGrids[i] = this.sourceProduct.getTiePointGrid(EnvisatConstants.MERIS_TIE_POINT_GRID_NAMES[i]);
        }
        this.l1bRadiance = new RasterDataNode[EnvisatConstants.MERIS_L1B_SPECTRAL_BAND_NAMES.length];
        for (i = 0; i < this.l1bRadiance.length; ++i) {
            this.l1bRadiance[i] = this.sourceProduct.getBand(EnvisatConstants.MERIS_L1B_SPECTRAL_BAND_NAMES[i]);
        }
        this.detectorIndex = this.sourceProduct.getBand("detector_index");
        this.l1bFlags = this.sourceProduct.getBand("l1_flags");
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle rectangle, ProgressMonitor pm) throws OperatorException {
        int iP;
        int bandIndex;
        L1bDataExtraction extdatl1 = new L1bDataExtraction(this.auxData);
        GaseousAbsorptionCorrection gaz_cor = new GaseousAbsorptionCorrection(this.auxData);
        PixelIdentification pixelid = new PixelIdentification(this.auxData, gaz_cor);
        RayleighCorrection ray_cor = new RayleighCorrection(this.auxData);
        CloudClassification classcloud = new CloudClassification(this.auxData, ray_cor);
        AtmosphericCorrectionLand landac = new AtmosphericCorrectionLand(ray_cor);
        pixelid.setCorrectionSurface(this.correctionSurface);
        landac.setCorrectionSurface(this.correctionSurface);
        FrameAndBlock frameAndBlock = this.getFrameAndBlock(rectangle);
        DpmPixel[] frameLocal = frameAndBlock.frame;
        DpmPixel[][] blockLocal = frameAndBlock.block;
        int frameSize = rectangle.height * rectangle.width;
        Tile[] l1bTiePoints = new Tile[this.tpGrids.length];
        for (int i = 0; i < this.tpGrids.length; ++i) {
            l1bTiePoints[i] = this.getSourceTile(this.tpGrids[i], rectangle);
        }
        Tile[] l1bRadiances = new Tile[this.l1bRadiance.length];
        for (int i = 0; i < this.l1bRadiance.length; ++i) {
            l1bRadiances[i] = this.getSourceTile(this.l1bRadiance[i], rectangle);
        }
        Tile l1bDetectorIndex = this.getSourceTile(this.detectorIndex, rectangle);
        Tile l1bFlagRaster = this.getSourceTile(this.l1bFlags, rectangle);
        for (int pixelIndex = 0; pixelIndex < frameSize; ++pixelIndex) {
            DpmPixel pixel = frameLocal[pixelIndex];
            extdatl1.l1_extract_pixbloc(pixel, rectangle.x + pixel.i, rectangle.y + pixel.j, l1bTiePoints, l1bRadiances, l1bDetectorIndex, l1bFlagRaster);
            if (BitSetter.isFlagSet((long)pixel.l2flags, (int)15)) continue;
            pixelid.rad2reflect(pixel);
            classcloud.classify_cloud(pixel);
        }
        for (int iPL1 = 0; iPL1 < rectangle.height; iPL1 += 4) {
            for (int iPC1 = 0; iPC1 < rectangle.width; iPC1 += 4) {
                int iPC2 = Math.min(rectangle.width, iPC1 + 4) - 1;
                int iPL2 = Math.min(rectangle.height, iPL1 + 4) - 1;
                pixelid.pixel_classification(blockLocal, iPC1, iPC2, iPL1, iPL2);
                landac.landAtmCor(blockLocal, iPC1, iPC2, iPL1, iPL2);
            }
        }
        for (bandIndex = 0; bandIndex < this.brrReflecBands.length; ++bandIndex) {
            if (!BrrOp.isValidRhoSpectralIndex(bandIndex)) continue;
            ProductData data = targetTiles.get(this.brrReflecBands[bandIndex]).getRawSamples();
            float[] dData = (float[])data.getElems();
            for (iP = 0; iP < rectangle.width * rectangle.height; ++iP) {
                dData[iP] = (float)frameLocal[iP].rho_top[bandIndex];
                if (!BitSetter.isFlagSet((int)((int)frameLocal[iP].l2flags), (int)15)) continue;
                dData[iP] = -1.0f;
            }
            targetTiles.get(this.brrReflecBands[bandIndex]).setSamples(dData);
        }
        if (this.outputToar) {
            for (bandIndex = 0; bandIndex < this.toaReflecBands.length; ++bandIndex) {
                ProductData data = targetTiles.get(this.toaReflecBands[bandIndex]).getRawSamples();
                float[] ddata = (float[])data.getElems();
                for (iP = 0; iP < rectangle.width * rectangle.height; ++iP) {
                    ddata[iP] = (float)frameLocal[iP].rho_toa[bandIndex];
                }
                targetTiles.get(this.toaReflecBands[bandIndex]).setRawSamples(data);
            }
        }
    }

    protected void createOutputBands(Band[] bands, String name) {
        int sceneWidth = this.targetProduct.getSceneRasterWidth();
        int sceneHeight = this.targetProduct.getSceneRasterHeight();
        for (int bandId = 0; bandId < bands.length; ++bandId) {
            if (!BrrOp.isValidRhoSpectralIndex(bandId) && !name.equals("toar")) continue;
            Band aNewBand = new Band(name + "_" + (bandId + 1), 30, sceneWidth, sceneHeight);
            aNewBand.setNoDataValueUsed(true);
            aNewBand.setNoDataValue(-1.0);
            aNewBand.setSpectralBandIndex(this.sourceProduct.getBandAt(bandId).getSpectralBandIndex());
            aNewBand.setSpectralWavelength(this.sourceProduct.getBandAt(bandId).getSpectralWavelength());
            aNewBand.setSpectralBandwidth(this.sourceProduct.getBandAt(bandId).getSpectralBandwidth());
            this.targetProduct.addBand(aNewBand);
            bands[bandId] = aNewBand;
        }
    }

    protected void checkInputProduct(Product inputProduct) throws IllegalArgumentException {
        String name;
        int i;
        for (i = 0; i < EnvisatConstants.MERIS_TIE_POINT_GRID_NAMES.length; ++i) {
            name = EnvisatConstants.MERIS_TIE_POINT_GRID_NAMES[i];
            if (inputProduct.getTiePointGrid(name) != null) continue;
            throw new IllegalArgumentException("Invalid input product. Missing tie point grid '" + name + "'.");
        }
        for (i = 0; i < EnvisatConstants.MERIS_L1B_SPECTRAL_BAND_NAMES.length; ++i) {
            name = EnvisatConstants.MERIS_L1B_SPECTRAL_BAND_NAMES[i];
            if (inputProduct.getBand(name) != null) continue;
            throw new IllegalArgumentException("Invalid input product. Missing band '" + name + "'.");
        }
        name = "detector_index";
        if (inputProduct.getBand(name) == null) {
            throw new IllegalArgumentException("Invalid input product. Missing dataset '" + name + "'.");
        }
        name = "l1_flags";
        if (inputProduct.getBand(name) == null) {
            throw new IllegalArgumentException("Invalid input product. Missing dataset '" + name + "'.");
        }
    }

    static boolean isValidRhoSpectralIndex(int i) {
        return i >= 0 && i < 14 && i != 10;
    }

    private FrameAndBlock getFrameAndBlock(Rectangle rectangle) {
        FrameAndBlock frameAndBlock = new FrameAndBlock();
        int frameSize = rectangle.width * rectangle.height;
        DpmPixel[] frameLocal = this.frame.get();
        DpmPixel[][] blockLocal = this.block.get();
        if (frameLocal.length != frameSize) {
            frameLocal = new DpmPixel[frameSize];
            blockLocal = new DpmPixel[rectangle.height][rectangle.width];
            for (int pixelIndex = 0; pixelIndex < frameSize; ++pixelIndex) {
                DpmPixel pixel;
                DpmPixel dpmPixel = pixel = new DpmPixel(pixelIndex % rectangle.width, pixelIndex / rectangle.width);
                blockLocal[pixel.j][pixel.i] = dpmPixel;
                frameLocal[pixelIndex] = dpmPixel;
                this.frame.set(frameLocal);
                this.block.set(blockLocal);
            }
        } else {
            for (int pixelIndex = 0; pixelIndex < frameSize; ++pixelIndex) {
                frameLocal[pixelIndex].reset(pixelIndex % rectangle.width, pixelIndex / rectangle.width);
            }
        }
        frameAndBlock.frame = frameLocal;
        frameAndBlock.block = blockLocal;
        return frameAndBlock;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(BrrOp.class);
        }
    }

    private class FrameAndBlock {
        DpmPixel[] frame;
        DpmPixel[][] block;

        private FrameAndBlock() {
        }
    }
}

