/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.brr.dpm;

import org.esa.s3tbx.meris.l2auxdata.Constants;
import org.esa.s3tbx.meris.l2auxdata.L2AuxData;
import org.esa.s3tbx.util.math.FractIndex;
import org.esa.s3tbx.util.math.Interp;

public class RayleighCorrection
implements Constants {
    private LocalHelperVariables lh;
    private L2AuxData auxdata;

    public RayleighCorrection(L2AuxData auxData) {
        this.auxdata = auxData;
        this.lh = new LocalHelperVariables();
    }

    void ref_rayleigh(double delta_azimuth, double sun_zenith, double view_zenith, double mus, double muv, double airMass, double[] phaseRayl, double[] tauRayl, double[] refRayl) {
        FractIndex tsi = this.lh.ref_rayleigh_i[0];
        FractIndex tvi = this.lh.ref_rayleigh_i[1];
        double mud = Math.cos(Math.PI / 180 * delta_azimuth);
        double mu2d = 2.0 * mud * mud - 1.0;
        Interp.interpCoord((double)sun_zenith, (double[])this.auxdata.Rayscatt_coeff_s.getTab(2), (FractIndex)tsi);
        Interp.interpCoord((double)view_zenith, (double[])this.auxdata.Rayscatt_coeff_s.getTab(3), (FractIndex)tvi);
        float[][][][] Rayscatt_coeff_s = (float[][][][])this.auxdata.Rayscatt_coeff_s.getJavaArray();
        for (int is = 0; is < 3; ++is) {
            for (int ik = 0; ik < 4; ++ik) {
                ((LocalHelperVariables)this.lh).abcd[is][ik] = Interp.interpolate((Object)Rayscatt_coeff_s[ik][is], (FractIndex[])this.lh.ref_rayleigh_i);
            }
        }
        block5: for (int bandId = 0; bandId < 15; ++bandId) {
            switch (bandId) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: {
                    double constTerm = (1.0 - Math.exp(-tauRayl[bandId] * airMass)) / (4.0 * (mus + muv));
                    int is = 0;
                    while (is < 3) {
                        ((LocalHelperVariables)this.lh).rhoRayl[is] = phaseRayl[is] * constTerm;
                        double multiScatteringCoeff = 0.0;
                        for (int ik = 3; ik >= 0; --ik) {
                            multiScatteringCoeff = tauRayl[bandId] * multiScatteringCoeff + this.lh.abcd[is][ik];
                        }
                        double[] dArray = this.lh.rhoRayl;
                        int n = is++;
                        dArray[n] = dArray[n] * multiScatteringCoeff;
                    }
                    refRayl[bandId] = this.lh.rhoRayl[0] + 2.0 * mud * this.lh.rhoRayl[1] + 2.0 * mu2d * this.lh.rhoRayl[2];
                    continue block5;
                }
                default: {
                    refRayl[bandId] = 0.0;
                }
            }
        }
    }

    void phase_rayleigh(double mus, double muv, double sins, double sinv, double[] phaseRayl) {
        phaseRayl[0] = 0.75 * this.auxdata.AB[0] * (1.0 + mus * mus * muv * muv + 0.5 * sins * sins * sinv * sinv) + this.auxdata.AB[1];
        phaseRayl[1] = -0.75 * this.auxdata.AB[0] * mus * muv * sins * sinv;
        phaseRayl[2] = 0.1875 * this.auxdata.AB[0] * sins * sins * sinv * sinv;
    }

    void tau_rayleigh(double press, double[] tauRayl) {
        double ratio = press / this.auxdata.Pstd;
        block3: for (int bandId = 0; bandId < 15; ++bandId) {
            switch (bandId) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: {
                    tauRayl[bandId] = this.auxdata.tau_R[bandId] * ratio;
                    continue block3;
                }
                default: {
                    tauRayl[bandId] = 0.0;
                }
            }
        }
    }

    void trans_rayleigh(double mu, double[] tauRayl, double[] transRayl) {
        block3: for (int bandId = 0; bandId < 15; ++bandId) {
            switch (bandId) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: {
                    double tr = (0.6666666666666666 + mu + (0.6666666666666666 - mu) * Math.exp(-tauRayl[bandId] / mu)) / (1.3333333333333333 + tauRayl[bandId]);
                    transRayl[bandId] = this.auxdata.Raytrans[0] + this.auxdata.Raytrans[1] * tr + this.auxdata.Raytrans[2] * tr * tr;
                    continue block3;
                }
                default: {
                    transRayl[bandId] = 1.0;
                }
            }
        }
    }

    void sphalb_rayleigh(double[] tauRayl, double[] sphalbRayl) {
        block3: for (int bandId = 0; bandId < 15; ++bandId) {
            switch (bandId) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: {
                    Interp.interpCoord((double)tauRayl[bandId], (double[])this.auxdata.Rayalb.getTab(0), (FractIndex)this.lh.ray_index[0]);
                    sphalbRayl[bandId] = Interp.interpolate((Object)this.auxdata.Rayalb.getJavaArray(), (FractIndex[])this.lh.ray_index);
                    continue block3;
                }
                default: {
                    sphalbRayl[bandId] = 0.0;
                }
            }
        }
    }

    void corr_rayleigh(double[] refRayl, double[] sphalbRayl, double[] transRs, double[] transRv, double[] rho, double[] rho_ag) {
        block3: for (int bandId = 0; bandId < 15; ++bandId) {
            switch (bandId) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: {
                    double dum = (rho[bandId] - refRayl[bandId]) / (transRs[bandId] * transRv[bandId]);
                    rho_ag[bandId] = dum / (1.0 + sphalbRayl[bandId] * dum);
                    continue block3;
                }
                default: {
                    rho_ag[bandId] = rho[bandId];
                }
            }
        }
    }

    private static class LocalHelperVariables {
        private final double[] rhoRayl = new double[3];
        private final double[][] abcd = new double[3][4];
        private final FractIndex[] ref_rayleigh_i = FractIndex.createArray((int)2);
        private final FractIndex[] ray_index = FractIndex.createArray((int)1);

        private LocalHelperVariables() {
        }
    }
}

