/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.brr.dpm;

import org.esa.s3tbx.meris.brr.dpm.DpmPixel;
import org.esa.s3tbx.meris.brr.dpm.GaseousAbsorptionCorrection;
import org.esa.s3tbx.meris.brr.operator.CorrectionSurfaceEnum;
import org.esa.s3tbx.meris.l2auxdata.Constants;
import org.esa.s3tbx.meris.l2auxdata.L2AuxData;
import org.esa.s3tbx.util.math.FractIndex;
import org.esa.s3tbx.util.math.Interp;
import org.esa.snap.core.util.BitSetter;

public class PixelIdentification
implements Constants {
    private CorrectionSurfaceEnum correctionSurface;
    private GaseousAbsorptionCorrection gaseousCorr;
    private LocalHelperVariables lh;
    private L2AuxData auxData;

    public PixelIdentification(L2AuxData auxData, GaseousAbsorptionCorrection gasCorr) {
        this.auxData = auxData;
        this.lh = new LocalHelperVariables();
        this.gaseousCorr = gasCorr;
    }

    public void setCorrectionSurface(CorrectionSurfaceEnum correctionSurface) {
        this.correctionSurface = correctionSurface;
    }

    public int pixel_classification(DpmPixel[][] pixelBlock, int ic0, int ic1, int il0, int il1) {
        int status = 0;
        boolean correctPixel = false;
        boolean correctWaterPixel = false;
        FractIndex[] r7thresh_Index = FractIndex.createArray((int)3);
        boolean iOrinp0 = false;
        boolean[][] is_L1bland = new boolean[4][4];
        boolean[][] do_corr = new boolean[4][4];
        double[] dSumrho = new double[15];
        double[] T_o3 = new double[15];
        double etaAverageForWater = 0.0;
        double x2AverageForWater = 0.0;
        for (int il = il0; il <= il1; ++il) {
            for (int ic = ic0; ic <= ic1; ++ic) {
                DpmPixel pixel = pixelBlock[il][ic];
                long flags = pixel.l2flags;
                if (!BitSetter.isFlagSet((long)flags, (int)15)) {
                    if (this.correctionSurface == CorrectionSurfaceEnum.LAND && pixel.altitude < -50.0 && !BitSetter.isFlagSet((int)pixel.l1flags, (int)4)) {
                        do_corr[il - il0][ic - ic0] = false;
                        continue;
                    }
                    correctPixel = true;
                    do_corr[il - il0][ic - ic0] = true;
                    is_L1bland[il - il0][ic - ic0] = BitSetter.isFlagSet((long)flags, (int)17);
                    if (is_L1bland[il - il0][ic - ic0]) continue;
                    correctWaterPixel = true;
                    for (int bandId = 9; bandId <= 14; ++bandId) {
                        int n = bandId;
                        dSumrho[n] = dSumrho[n] + pixel.rho_toa[bandId];
                    }
                    continue;
                }
                do_corr[il - il0][ic - ic0] = false;
            }
        }
        if (correctWaterPixel) {
            if (dSumrho[9] > 0.0 && dSumrho[10] > 0.0) {
                etaAverageForWater = dSumrho[10] / dSumrho[9];
            } else {
                iOrinp0 = true;
                etaAverageForWater = 1.0;
            }
            if (dSumrho[13] > 0.0 && dSumrho[14] > 0.0) {
                x2AverageForWater = dSumrho[14] / dSumrho[13];
            } else {
                iOrinp0 = true;
                x2AverageForWater = 1.0;
            }
        }
        if (correctPixel) {
            DpmPixel pixel0 = pixelBlock[il0][ic1];
            double windm = 0.0;
            windm += pixel0.windu * pixel0.windu;
            windm += pixel0.windv * pixel0.windv;
            windm = Math.sqrt(windm);
            double phiw = this.azimuth(pixel0.windu, pixel0.windv);
            double chiw = 57.29577951308232 * Math.acos(Math.cos(pixel0.sun_azimuth - phiw));
            double rhoGlint = this.glintRef(pixel0.sun_zenith, pixel0.view_zenith, pixel0.delta_azimuth, windm, chiw);
            this.trans_o3(pixel0.airMass, pixel0.ozone_ecmwf, T_o3);
            Interp.interpCoord((double)pixel0.sun_zenith, (double[])this.auxData.r7thresh.getTab(0), (FractIndex)r7thresh_Index[0]);
            Interp.interpCoord((double)pixel0.view_zenith, (double[])this.auxData.r7thresh.getTab(1), (FractIndex)r7thresh_Index[1]);
            Interp.interpCoord((double)pixel0.delta_azimuth, (double[])this.auxData.r7thresh.getTab(2), (FractIndex)r7thresh_Index[2]);
            double r7thresh_val = Interp.interpolate((Object)this.auxData.r7thresh.getJavaArray(), (FractIndex[])r7thresh_Index);
            double r13thresh_val = Interp.interpolate((Object)this.auxData.r13thresh.getJavaArray(), (FractIndex[])r7thresh_Index);
            for (int il = il0; il <= il1; ++il) {
                for (int ic = ic0; ic <= ic1; ++ic) {
                    double x2;
                    double eta;
                    DpmPixel pixel = pixelBlock[il][ic];
                    if (!do_corr[il - il0][ic - ic0]) continue;
                    if (pixel.sun_zenith > this.auxData.TETAS_LIM) {
                        pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)43, (boolean)true);
                    }
                    if (is_L1bland[il - il0][ic - ic0]) {
                        if (pixel.rho_toa[9] > 0.0 && pixel.rho_toa[10] > 0.0) {
                            eta = pixel.rho_toa[10] / pixel.rho_toa[9];
                        } else {
                            eta = 1.0;
                            pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)33, (boolean)true);
                        }
                        if (pixel.rho_toa[13] > 0.0 && pixel.rho_toa[14] > 0.0) {
                            x2 = pixel.rho_toa[14] / pixel.rho_toa[13];
                        } else {
                            x2 = 1.0;
                            pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)33, (boolean)true);
                        }
                    } else {
                        eta = etaAverageForWater;
                        x2 = x2AverageForWater;
                        pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)33, (boolean)iOrinp0);
                    }
                    status = this.gaseousCorr.gas_correction(T_o3, eta, x2, pixel.rho_toa, pixel.detector, pixel.rho_ag, BitSetter.isFlagSet((long)pixel.l2flags, (int)38));
                    pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)34, (status != 0 ? 1 : 0) != 0);
                    boolean is_land_consolidated = false;
                    if (!BitSetter.isFlagSet((long)pixel.l2flags, (int)7)) {
                        double rThresh;
                        boolean isGlint;
                        int b_thresh = this.auxData.lap_b_thresh[0];
                        double a_thresh = this.auxData.alpha_thresh[0];
                        boolean is_water = this.inland_waters(r7thresh_val, pixel, b_thresh, a_thresh);
                        float thresh_medg = 0.2f;
                        boolean bl = isGlint = rhoGlint >= (double)0.2f * pixel.rho_ag[12];
                        if (isGlint) {
                            pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)20, (boolean)isGlint);
                            b_thresh = this.auxData.lap_b_thresh[0];
                            a_thresh = this.auxData.alpha_thresh[0];
                            rThresh = r7thresh_val;
                        } else {
                            b_thresh = this.auxData.lap_b_thresh[1];
                            a_thresh = this.auxData.alpha_thresh[1];
                            rThresh = r13thresh_val;
                        }
                        boolean is_land = this.island(rThresh, pixel, b_thresh, a_thresh);
                        boolean bl2 = is_land_consolidated = !is_water;
                        if (isGlint && !BitSetter.isFlagSet((int)pixel.l1flags, (int)4)) {
                            is_land_consolidated = is_land;
                        }
                    }
                    pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)18, (boolean)is_land_consolidated);
                    if (is_land_consolidated) {
                        this.applySmileCorrection(pixel.rho_ag, this.auxData.land_smile_params, pixel.detector);
                        continue;
                    }
                    this.applySmileCorrection(pixel.rho_ag, this.auxData.water_smile_params, pixel.detector);
                }
            }
        }
        return status;
    }

    public void rad2reflect(DpmPixel pixel) {
        double constantTerm = Math.PI / pixel.mus * this.auxData.seasonal_factor;
        for (int bandId = 0; bandId < 15; ++bandId) {
            pixel.rho_toa[bandId] = pixel.TOAR[bandId] * constantTerm / this.auxData.detector_solar_irradiance[bandId][pixel.detector];
        }
    }

    private void applySmileCorrection(double[] rho, L2AuxData.SmileParams params, int detector) {
        for (int bandId = 0; bandId < 15; ++bandId) {
            if (params.enabled[bandId]) {
                int bandMin = params.derivative_band_id[bandId][0];
                int bandMax = params.derivative_band_id[bandId][1];
                double derive = (rho[bandMax] - rho[bandMin]) / (this.auxData.central_wavelength[bandMax][detector] - this.auxData.central_wavelength[bandMin][detector]);
                this.lh.smileCorrectedRho[bandId] = rho[bandId] + derive * (this.auxData.theoretical_wavelength[bandId] - this.auxData.central_wavelength[bandId][detector]);
                continue;
            }
            this.lh.smileCorrectedRho[bandId] = rho[bandId];
        }
        System.arraycopy(this.lh.smileCorrectedRho, 0, rho, 0, 15);
    }

    private boolean inland_waters(double r7thresh_val, DpmPixel pixel, int b_thresh, double a_thresh) {
        boolean status = pixel.rho_ag[b_thresh] <= a_thresh * r7thresh_val && this.auxData.lap_beta_l * pixel.rho_ag[12] < pixel.rho_ag[6];
        pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)19, (boolean)status);
        return status;
    }

    private boolean island(double r7thresh_val, DpmPixel pixel, int b_thresh, double a_thresh) {
        boolean status = pixel.rho_ag[b_thresh] > a_thresh * r7thresh_val && this.auxData.lap_beta_w * pixel.rho_ag[12] > pixel.rho_ag[6];
        pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)16, (boolean)status);
        return status;
    }

    private double glintRef(double thetas, double thetav, double delta, double windm, double chiw) {
        FractIndex[] rogIndex = FractIndex.createArray((int)5);
        Interp.interpCoord((double)chiw, (double[])this.auxData.rog.getTab(0), (FractIndex)rogIndex[0]);
        Interp.interpCoord((double)thetav, (double[])this.auxData.rog.getTab(1), (FractIndex)rogIndex[1]);
        Interp.interpCoord((double)delta, (double[])this.auxData.rog.getTab(2), (FractIndex)rogIndex[2]);
        Interp.interpCoord((double)windm, (double[])this.auxData.rog.getTab(3), (FractIndex)rogIndex[3]);
        Interp.interpCoord((double)thetas, (double[])this.auxData.rog.getTab(4), (FractIndex)rogIndex[4]);
        return Interp.interpolate((Object)this.auxData.rog.getJavaArray(), (FractIndex[])rogIndex);
    }

    private double azimuth(double x, double y) {
        if (y > 0.0) {
            return 57.29577951308232 * Math.atan(x / y);
        }
        if (y < 0.0) {
            return 180.0 + 57.29577951308232 * Math.atan(x / y);
        }
        return x >= 0.0 ? 90.0 : 270.0;
    }

    private void trans_o3(double airMass, double ozone, double[] T_o3) {
        for (int bandId = 0; bandId < 15; ++bandId) {
            T_o3[bandId] = Math.exp(-ozone / 1000.0 * airMass * this.auxData.tauO3_norm[bandId]);
        }
    }

    private static class LocalHelperVariables {
        double[] smileCorrectedRho = new double[15];

        private LocalHelperVariables() {
        }
    }
}

