/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.brr.dpm;

import org.esa.s3tbx.meris.brr.dpm.DpmPixel;
import org.esa.s3tbx.meris.l2auxdata.Constants;
import org.esa.s3tbx.meris.l2auxdata.L2AuxData;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.util.BitSetter;

public class L1bDataExtraction
implements Constants {
    private final L2AuxData auxData;

    public L1bDataExtraction(L2AuxData auxData) {
        this.auxData = auxData;
    }

    public void l1_extract_pixbloc(DpmPixel pixel, int x, int y, Tile[] tpdata, Tile[] toars, Tile detectorIndex, Tile l1bFlags) {
        int band;
        pixel.ozone_ecmwf = -1.0;
        pixel.ANNOT_F = 0;
        for (band = 0; band < 15; ++band) {
            pixel.rho_ag[band] = -1.0;
            pixel.rho_toa[band] = -1.0;
            pixel.rho_top[band] = -1.0;
        }
        pixel.x = x;
        pixel.y = y;
        pixel.SATURATED_F = 0;
        for (band = 0; band < 15; ++band) {
            pixel.TOAR[band] = toars[band].getSampleDouble(x, y);
            if (!(pixel.TOAR[band] > this.auxData.Saturation_L[band])) continue;
            pixel.SATURATED_F = BitSetter.setFlag((int)pixel.SATURATED_F, (int)band);
        }
        pixel.detector = detectorIndex.getSampleInt(x, y);
        pixel.l1flags = l1bFlags.getSampleInt(x, y);
        pixel.l2flags = 0L;
        if (BitSetter.isFlagSet((int)pixel.l1flags, (int)0)) {
            pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)10);
        }
        if (BitSetter.isFlagSet((int)pixel.l1flags, (int)1)) {
            pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)12);
        }
        if (BitSetter.isFlagSet((int)pixel.l1flags, (int)4)) {
            pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)17);
        }
        if (BitSetter.isFlagSet((int)pixel.l1flags, (int)5)) {
            pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)0);
        }
        if (BitSetter.isFlagSet((int)pixel.l1flags, (int)6)) {
            pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)9);
        }
        if (BitSetter.isFlagSet((int)pixel.l1flags, (int)7)) {
            pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)15);
        }
        if (BitSetter.isFlagSet((int)pixel.l1flags, (int)3)) {
            pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)27);
        }
        if (pixel.detector < 0 || pixel.detector >= this.auxData.detector_count) {
            pixel.detector = -1;
            if (!BitSetter.isFlagSet((int)pixel.l1flags, (int)7)) {
                pixel.l1flags = BitSetter.setFlag((int)pixel.l1flags, (int)15);
                pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)15);
            }
        }
        pixel.sun_zenith = tpdata[6].getSampleDouble(x, y);
        pixel.view_zenith = tpdata[8].getSampleDouble(x, y);
        double view_azimuth = tpdata[9].getSampleDouble(x, y);
        pixel.sun_azimuth = tpdata[7].getSampleDouble(x, y);
        pixel.altitude = tpdata[2].getSampleDouble(x, y);
        pixel.press_ecmwf = tpdata[12].getSampleDouble(x, y);
        pixel.windu = tpdata[10].getSampleDouble(x, y);
        pixel.windv = tpdata[11].getSampleDouble(x, y);
        pixel.ozone_ecmwf = tpdata[13].getSampleDouble(x, y);
        pixel.delta_azimuth = 57.29577951308232 * Math.acos(Math.cos(Math.PI / 180 * (view_azimuth - pixel.sun_azimuth)));
        if (BitSetter.isFlagSet((long)pixel.l2flags, (int)17)) {
            double f = Math.exp(-Math.max(0.0, pixel.altitude) / this.auxData.press_scale_height);
            pixel.press_ecmwf *= f;
        }
        pixel.muv = Math.cos(Math.PI / 180 * pixel.view_zenith);
        pixel.mus = Math.cos(Math.PI / 180 * pixel.sun_zenith);
        pixel.airMass = 1.0 / pixel.mus + 1.0 / pixel.muv;
    }
}

