/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.brr.dpm;

import org.esa.s3tbx.meris.l2auxdata.Constants;
import org.esa.s3tbx.meris.l2auxdata.L2AuxData;
import org.esa.s3tbx.util.math.FractIndex;
import org.esa.s3tbx.util.math.Interp;

public class GaseousAbsorptionCorrection
implements Constants {
    private final L2AuxData auxData;
    private LocalHelperVariables lh = new LocalHelperVariables();

    public GaseousAbsorptionCorrection(L2AuxData auxData) {
        this.auxData = auxData;
    }

    public int gas_correction(double[] T_o3, double eta, double x2, double[] rho, int detector, double[] rho_ag, boolean PCD_POL_F) {
        int status = 0;
        for (int bandId = 0; bandId < 15; ++bandId) {
            double T_h2o = 1.0;
            double T_o2 = 1.0;
            switch (bandId) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: {
                    T_h2o = this.trans_h2o(bandId, x2, detector);
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    if (!PCD_POL_F) {
                        T_o2 = this.trans_o2(bandId, eta, detector);
                    }
                    T_h2o = this.trans_h2o(bandId, x2, detector);
                    break;
                }
            }
            double tg = T_o3[bandId] * T_h2o * T_o2;
            if (tg > 1.0E-6 && tg <= 1.0) {
                rho_ag[bandId] = rho[bandId] / tg;
                continue;
            }
            rho_ag[bandId] = rho[bandId];
            status = 1;
        }
        return status;
    }

    private double trans_o2(int ib, double R_o2, int detector) {
        double to2;
        if (ib == 11) {
            Interp.interpCoord((double)this.auxData.central_wavelength[10][detector], (double[])this.auxData.spectral_shift_wavelength, (FractIndex)this.lh.spectralShift760);
            if (this.lh.spectralShift760.index == 20) {
                this.lh.spectralShift760.index = 19;
                this.lh.spectralShift760.fraction = 1.0;
            }
            double to2_blw = 0.0;
            double to2_abv = 0.0;
            for (int k = 3; k >= 0; --k) {
                to2_blw = R_o2 * to2_blw + this.auxData.O2coef[this.lh.spectralShift760.index][k];
                to2_abv = R_o2 * to2_abv + this.auxData.O2coef[this.lh.spectralShift760.index + 1][k];
            }
            to2 = (1.0 - this.lh.spectralShift760.fraction) * to2_blw + this.lh.spectralShift760.fraction * to2_abv;
        } else {
            to2 = 1.0;
        }
        return to2;
    }

    private double trans_h2o(int ib, double R_h2o, int detector) {
        double th2o;
        if (ib == 8) {
            Interp.interpCoord((double)this.auxData.central_wavelength[8][detector], (double[])this.auxData.spectral_shift_H2Owavelength, (FractIndex)this.lh.spectralShift705);
            if (this.lh.spectralShift705.index == 20) {
                this.lh.spectralShift705.index = 19;
                this.lh.spectralShift705.fraction = 1.0;
            }
            double th2o_blw = 0.0;
            double th2o_abv = 0.0;
            for (int k = 3; k >= 0; --k) {
                th2o_blw = R_h2o * th2o_blw + this.auxData.H2OcoefSpecShift[this.lh.spectralShift705.index][k];
                th2o_abv = R_h2o * th2o_abv + this.auxData.H2OcoefSpecShift[this.lh.spectralShift705.index + 1][k];
            }
            th2o = (1.0 - this.lh.spectralShift705.fraction) * th2o_blw + this.lh.spectralShift705.fraction * th2o_abv;
        } else {
            th2o = 0.0;
            for (int k = 3; k >= 0; --k) {
                th2o = R_h2o * th2o + this.auxData.H2Ocoef[ib][k];
            }
        }
        return th2o;
    }

    private static class LocalHelperVariables {
        final FractIndex spectralShift760 = new FractIndex();
        final FractIndex spectralShift705 = new FractIndex();

        private LocalHelperVariables() {
        }
    }
}

