/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.brr.dpm;

import org.esa.s3tbx.meris.brr.dpm.DpmPixel;
import org.esa.s3tbx.meris.brr.dpm.RayleighCorrection;
import org.esa.s3tbx.meris.dpm.PixelId;
import org.esa.s3tbx.meris.l2auxdata.Constants;
import org.esa.s3tbx.meris.l2auxdata.L2AuxData;
import org.esa.snap.core.util.BitSetter;

public class CloudClassification
implements Constants {
    private L2AuxData auxData;
    private LocalHelperVariables lh;
    private RayleighCorrection rayleighCorrection;
    private final PixelId pixelId;

    public CloudClassification(L2AuxData auxData, RayleighCorrection rayCorr) {
        this.auxData = auxData;
        this.pixelId = new PixelId(auxData);
        this.lh = new LocalHelperVariables();
        this.rayleighCorrection = rayCorr;
    }

    public void classify_cloud(DpmPixel pixel) {
        PixelId.Pressure press = this.pixelId.computePressure(pixel.rho_toa[9], pixel.rho_toa[10], pixel.airMass, pixel.detector);
        boolean pcd_poly = press.error;
        double delta_press_thresh = this.pixelId.getPressureThreshold(pixel.sun_zenith, pixel.view_zenith, BitSetter.isFlagSet((long)pixel.l2flags, (int)17));
        boolean[] pressureThreshFlags = this.pixelId.getPressureThreshFlags(pixel.press_ecmwf, press.value, -1.0, delta_press_thresh);
        boolean low_P_nn = pressureThreshFlags[0];
        boolean low_P_poly = pressureThreshFlags[1];
        boolean delta_p = pressureThreshFlags[2];
        pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)35, (boolean)low_P_nn);
        pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)36, (boolean)true);
        pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)37, (boolean)low_P_poly);
        pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)38, (boolean)pcd_poly);
        pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)39, (boolean)delta_p);
        this.spec_slopes(pixel, this.lh.resultFlags);
        boolean bright_f = this.lh.resultFlags[0];
        boolean slope_1_f = this.lh.resultFlags[1];
        boolean slope_2_f = this.lh.resultFlags[2];
        pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)0, (boolean)bright_f);
        pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)40, (boolean)slope_1_f);
        pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)41, (boolean)slope_2_f);
        boolean land_f = BitSetter.isFlagSet((long)pixel.l2flags, (int)17);
        boolean is_cloud = this.is_cloudy(land_f, bright_f, low_P_nn, low_P_poly, delta_p, slope_1_f, slope_2_f, true, pcd_poly);
        pixel.l2flags = BitSetter.setFlag((long)pixel.l2flags, (int)7, (boolean)is_cloud);
    }

    private void spec_slopes(DpmPixel pixel, boolean[] result_flags) {
        long flags = pixel.l2flags;
        double sins = Math.sin(Math.PI / 180 * pixel.sun_zenith);
        double sinv = Math.sin(Math.PI / 180 * pixel.view_zenith);
        this.rayleighCorrection.phase_rayleigh(pixel.mus, pixel.muv, sins, sinv, this.lh.phaseR);
        double press = pixel.press_ecmwf;
        this.rayleighCorrection.tau_rayleigh(press, this.lh.tauR);
        this.rayleighCorrection.ref_rayleigh(pixel.delta_azimuth, pixel.sun_zenith, pixel.view_zenith, pixel.mus, pixel.muv, pixel.airMass, this.lh.phaseR, this.lh.tauR, this.lh.rhoRay);
        for (int band = 0; band <= 14; ++band) {
            this.lh.rhoAg[band] = pixel.rho_toa[band] - this.lh.rhoRay[band];
        }
        double rhorc_442_thr = this.pixelId.getRhoRC442thr(pixel.sun_zenith, pixel.view_zenith, pixel.delta_azimuth, BitSetter.isFlagSet((long)flags, (int)17));
        boolean bright_f = this.pixelId.isBrightFlag(this.lh.rhoAg, rhorc_442_thr, pixel.TOAR[this.auxData.band_bright_n]);
        boolean slope1_f = this.pixelId.isSpectraSlope1Flag(this.lh.rhoAg, pixel.TOAR[this.auxData.band_slope_n_1]);
        boolean slope2_f = this.pixelId.isSpectraSlope2Flag(this.lh.rhoAg, pixel.TOAR[this.auxData.band_slope_n_2]);
        result_flags[0] = bright_f;
        result_flags[1] = slope1_f;
        result_flags[2] = slope2_f;
    }

    private boolean is_cloudy(boolean land_f, boolean bright_f, boolean low_P_nn, boolean low_P_poly, boolean delta_p, boolean slope_1_f, boolean slope_2_f, boolean pcd_nn, boolean pcd_poly) {
        int index = 0;
        index = BitSetter.setFlag((int)index, (int)0, (boolean)bright_f);
        index = BitSetter.setFlag((int)index, (int)1, (boolean)low_P_nn);
        index = BitSetter.setFlag((int)index, (int)2, (boolean)low_P_poly);
        index = BitSetter.setFlag((int)index, (int)3, (boolean)delta_p);
        index = BitSetter.setFlag((int)index, (int)4, (boolean)pcd_nn);
        index = BitSetter.setFlag((int)index, (int)5, (boolean)pcd_poly);
        index = BitSetter.setFlag((int)index, (int)6, (boolean)slope_1_f);
        index = BitSetter.setFlag((int)index, (int)7, (boolean)slope_2_f);
        boolean is_cloud = land_f ? this.auxData.land_decision_table[index] : this.auxData.water_decision_table[index &= 0xFF];
        return is_cloud;
    }

    private static class LocalHelperVariables {
        final double[] phaseR = new double[3];
        final double[] tauR = new double[15];
        final double[] rhoAg = new double[15];
        final double[] rhoRay = new double[15];
        final boolean[] resultFlags = new boolean[3];

        private LocalHelperVariables() {
        }
    }
}

