/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.brr.dpm;

import org.esa.s3tbx.meris.brr.dpm.DpmPixel;
import org.esa.s3tbx.meris.brr.dpm.RayleighCorrection;
import org.esa.s3tbx.meris.brr.operator.CorrectionSurfaceEnum;
import org.esa.s3tbx.meris.l2auxdata.Constants;
import org.esa.snap.core.util.BitSetter;

public class AtmosphericCorrectionLand
implements Constants {
    private RayleighCorrection rayleighCorrection;
    private LocalHelperVariables lh = new LocalHelperVariables();
    private CorrectionSurfaceEnum correctionSurface;

    public AtmosphericCorrectionLand(RayleighCorrection rayCorr) {
        this.rayleighCorrection = rayCorr;
    }

    public void setCorrectionSurface(CorrectionSurfaceEnum correctionSurface) {
        this.correctionSurface = correctionSurface;
    }

    public void landAtmCor(DpmPixel[][] pixels, int ic0, int ic1, int il0, int il1) {
        int ic;
        int il;
        boolean correctPixel = false;
        for (il = il0; il <= il1; ++il) {
            for (ic = ic0; ic <= ic1; ++ic) {
                boolean waterCorrOk;
                DpmPixel pixel = pixels[il][ic];
                long flags = pixel.l2flags;
                boolean landCorrOk = BitSetter.isFlagSet((long)flags, (int)18) || BitSetter.isFlagSet((long)flags, (int)17) && BitSetter.isFlagSet((long)flags, (int)7);
                boolean bl = waterCorrOk = !landCorrOk;
                if (landCorrOk && this.correctionSurface != CorrectionSurfaceEnum.WATER || waterCorrOk && this.correctionSurface != CorrectionSurfaceEnum.LAND || this.correctionSurface == CorrectionSurfaceEnum.ALL_SURFACES) {
                    correctPixel = true;
                    this.lh.do_corr[il - il0][ic - ic0] = true;
                    continue;
                }
                this.lh.do_corr[il - il0][ic - ic0] = false;
            }
        }
        if (correctPixel) {
            DpmPixel pixel0 = pixels[il0][ic1];
            double sun_zenith = pixel0.sun_zenith;
            double view_zenith = pixel0.view_zenith;
            double delta_azimuth = pixel0.delta_azimuth;
            double mus = pixel0.mus;
            double muv = pixel0.muv;
            double sins = Math.sin(Math.PI / 180 * sun_zenith);
            double sinv = Math.sin(Math.PI / 180 * view_zenith);
            double press = pixel0.press_ecmwf;
            this.rayleighCorrection.phase_rayleigh(mus, muv, sins, sinv, this.lh.phaseR);
            this.rayleighCorrection.tau_rayleigh(press, this.lh.tauR);
            this.rayleighCorrection.ref_rayleigh(delta_azimuth, sun_zenith, view_zenith, mus, muv, pixel0.airMass, this.lh.phaseR, this.lh.tauR, pixel0.rhoR);
            this.rayleighCorrection.trans_rayleigh(mus, this.lh.tauR, pixel0.transRs);
            this.rayleighCorrection.trans_rayleigh(muv, this.lh.tauR, pixel0.transRv);
            this.rayleighCorrection.sphalb_rayleigh(this.lh.tauR, pixel0.sphalbR);
            for (il = il0; il <= il1; ++il) {
                for (ic = ic0; ic <= ic1; ++ic) {
                    if (!this.lh.do_corr[il - il0][ic - ic0]) continue;
                    this.rayleighCorrection.corr_rayleigh(pixel0.rhoR, pixel0.sphalbR, pixel0.transRs, pixel0.transRv, pixels[il][ic].rho_ag, pixels[il][ic].rho_top);
                }
            }
            for (il = il0; il <= il1; ++il) {
                for (ic = ic0; ic <= ic1; ++ic) {
                    if (!this.lh.do_corr[il - il0][ic - ic0]) continue;
                    block9: for (int ib = 0; ib < 15; ++ib) {
                        if (!(pixels[il][ic].rho_top[ib] <= 0.0)) continue;
                        switch (ib) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 11: 
                            case 12: 
                            case 13: {
                                pixels[il][ic].ANNOT_F = this.Set_annot_flag(16 + (ib <= 10 ? ib : ib - 1), pixels[il][ic].ANNOT_F);
                                continue block9;
                            }
                        }
                    }
                }
            }
        }
    }

    private int Set_annot_flag(int A_FLAG, int annot) {
        return annot |= 1 << A_FLAG;
    }

    private static class LocalHelperVariables {
        double[] phaseR = new double[3];
        double[] tauR = new double[15];
        boolean[][] do_corr = new boolean[4][4];

        private LocalHelperVariables() {
        }
    }
}

