/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.aerosol;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.esa.s3tbx.meris.aerosol.TemporalFile;
import org.esa.s3tbx.meris.aerosol.TemporalFileFactory;

public class TemporalFileArray {
    private final TemporalFile[] _temporalFiles;

    private TemporalFileArray(TemporalFile[] temporalFiles) {
        this._temporalFiles = temporalFiles;
    }

    public static TemporalFileArray scan(File dir, boolean recursive, TemporalFileFactory fileFactory) {
        ArrayList temporalFileList = new ArrayList(16);
        TemporalFileArray.scanImpl(dir, recursive, fileFactory, temporalFileList);
        return new TemporalFileArray(temporalFileList.toArray(new TemporalFile[temporalFileList.size()]));
    }

    public static TemporalFileArray create(String[] paths, TemporalFileFactory fileFactory) {
        ArrayList temporalFileList = new ArrayList(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            TemporalFileArray.addImpl(new File(paths[i]), fileFactory, temporalFileList);
        }
        return new TemporalFileArray(temporalFileList.toArray(new TemporalFile[temporalFileList.size()]));
    }

    public TemporalFile[] getTemporalFiles() {
        return this._temporalFiles;
    }

    public TemporalFile[] getTemporalFilesSorted(final Date date, int sizeMax) {
        TemporalFile[] sortedFiles = (TemporalFile[])this._temporalFiles.clone();
        Arrays.sort(sortedFiles, new Comparator(){

            public int compare(Object o1, Object o2) {
                return TemporalFile.compare(date, (TemporalFile)o1, (TemporalFile)o2);
            }
        });
        if (sizeMax <= 0 || sizeMax == sortedFiles.length) {
            return sortedFiles;
        }
        TemporalFile[] croppedFiles = new TemporalFile[Math.min(sizeMax, sortedFiles.length)];
        System.arraycopy(sortedFiles, 0, croppedFiles, 0, croppedFiles.length);
        return croppedFiles;
    }

    private static void scanImpl(File dir, boolean recursive, TemporalFileFactory fileFactory, List temporalFileList) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (!file.isFile()) continue;
            TemporalFileArray.addImpl(file, fileFactory, temporalFileList);
        }
        for (File file : files) {
            if (!file.isDirectory() || !recursive || file.getName().equals("..")) continue;
            TemporalFileArray.scanImpl(file, true, fileFactory, temporalFileList);
        }
    }

    private static void addImpl(File file, TemporalFileFactory fileFactory, List temporalFileList) {
        TemporalFile temporalFile = fileFactory.createTemporalFile(file);
        if (temporalFile != null) {
            temporalFileList.add(temporalFile);
        }
    }
}

