/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.aerosol;

import java.io.File;
import java.util.Date;

public class TemporalFile {
    protected final File file;
    protected final Date startDate;
    protected final Date endDate;

    public TemporalFile(File file, Date startDate, Date endDate) {
        this.file = file;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public File getFile() {
        return this.file;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getMeanDate() {
        return new Date((this.startDate.getTime() + this.endDate.getTime()) / 2L);
    }

    public static int compare(Date date, TemporalFile f1, TemporalFile f2) {
        long d2;
        long d1 = Math.abs(TemporalFile.getMeanTimeDifference(date, f1));
        long delta = d1 - (d2 = Math.abs(TemporalFile.getMeanTimeDifference(date, f2)));
        return delta == 0L ? 0 : (delta > 0L ? 1 : -1);
    }

    public static long getMeanTimeDifference(Date date, TemporalFile file) {
        long t = date.getTime();
        long t1 = file.getStartDate().getTime();
        long t2 = file.getEndDate().getTime();
        return t - (t1 + t2) / 2L;
    }

    public String toString() {
        return this.file.toString();
    }
}

