/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.aerosol;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFLibrary;
import org.esa.s3tbx.meris.MerisBasisOp;
import org.esa.s3tbx.meris.aerosol.GapFiller;
import org.esa.s3tbx.meris.aerosol.MOD08FileFactory;
import org.esa.s3tbx.meris.aerosol.TemporalFile;
import org.esa.s3tbx.meris.aerosol.TemporalFileArray;
import org.esa.s3tbx.util.math.FractIndex;
import org.esa.s3tbx.util.math.Interp;
import org.esa.s3tbx.util.math.LUT;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.StringUtils;

@OperatorMetadata(alias="Meris.Mod08Aerosol", internal=true)
public class ModisAerosolOp
extends MerisBasisOp {
    public static final String BAND_NAME_AOT_470 = "aot_470";
    public static final String BAND_NAME_AOT_660 = "aot_660";
    public static final String BAND_NAME_ANG = "ang";
    public static final String BAND_NAME_FLAGS = "aerosol_flags";
    private static final String MOD08_BAND_NAME = "Corrected_Optical_Depth_Land_QA_Mean_Mean";
    private static final int AEROSOL_GAP_VALUE = -9999;
    private static final float SCALE_FACTOR = 0.001f;
    private static final int MOD08_WIDTH = 360;
    private static final int MOD08_HEIGHT = 180;
    private static final double AOT_470_WAVELENGTH = 4.7E-7;
    private static final double AOT_660_WAVELENGTH = 6.6E-7;
    private TemporalFileArray mod08FileArray;
    private LUT _aot470LUT;
    private LUT _aot660LUT;
    private boolean[][][] gapFilled;
    private Band _aot470Band;
    private Band _aot660Band;
    private Band _angstrBand;
    private Band _flagsBand;
    private GapFiller gapFiller;
    @SourceProduct(alias="input")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter
    private String auxdataDir;

    public void initialize() throws OperatorException {
        if (StringUtils.isNullOrEmpty((String)this.auxdataDir)) {
            throw new OperatorException("'auxdataDir' not set.");
        }
        File mod08Dir = new File(this.auxdataDir);
        if (!mod08Dir.exists()) {
            throw new OperatorException("'auxdataDir' does not exist.");
        }
        this.mod08FileArray = TemporalFileArray.scan(mod08Dir, true, new MOD08FileFactory());
        if (this.mod08FileArray.getTemporalFiles().length < 2) {
            throw new OperatorException("not enough MOD08 data available");
        }
        this.gapFiller = new GapFiller();
        this.gapFiller.setWidthHeight(360, 180);
        try {
            this.readMod08();
        }
        catch (IOException e) {
            throw new OperatorException("Could not load MOD08 data files", (Throwable)e);
        }
        this.createTargetProduct();
    }

    private void createTargetProduct() {
        this.targetProduct = this.createCompatibleProduct(this.sourceProduct, "AEROSOL", "AEROSOL");
        this._aot470Band = this.targetProduct.addBand(BAND_NAME_AOT_470, 30);
        this._aot660Band = this.targetProduct.addBand(BAND_NAME_AOT_660, 30);
        this._angstrBand = this.targetProduct.addBand(BAND_NAME_ANG, 30);
        FlagCoding cloudFlagCoding = this.createFlagCoding(this.targetProduct);
        this.targetProduct.getFlagCodingGroup().add((ProductNode)cloudFlagCoding);
        this._flagsBand = this.targetProduct.addBand(BAND_NAME_FLAGS, 20);
        this._flagsBand.setDescription("Aerosol specific flags");
        this._flagsBand.setSampleCoding((SampleCoding)cloudFlagCoding);
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle rectangle, ProgressMonitor pm) throws OperatorException {
        GeoCoding geoCoding = this.sourceProduct.getSceneGeoCoding();
        GeoPos geoPos = new GeoPos();
        PixelPos pixelPos = new PixelPos();
        FractIndex[] indexes = FractIndex.createArray((int)3);
        Tile aot470Tile = targetTiles.get(this._aot470Band);
        Tile aot660Tile = targetTiles.get(this._aot660Band);
        Tile angTile = targetTiles.get(this._angstrBand);
        Tile flagTile = targetTiles.get(this._flagsBand);
        double time = ModisAerosolOp.getSceneRasterMeanTime(this.sourceProduct).getMJD();
        double logWavelengthDiff = Math.log(6.6E-7) - Math.log(4.7E-7);
        for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
            for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                pixelPos.setLocation((double)x, (double)y);
                geoCoding.getGeoPos(pixelPos, geoPos);
                float lon = (float)geoPos.getLon();
                float lat = (float)geoPos.getLat();
                Interp.interpCoord((double)time, (double[])this._aot470LUT.getTab(0), (FractIndex)indexes[0]);
                Interp.interpCoord((double)lat, (double[])this._aot470LUT.getTab(1), (FractIndex)indexes[1]);
                Interp.interpCoord((double)lon, (double[])this._aot470LUT.getTab(2), (FractIndex)indexes[2]);
                double aot470 = Interp.interpolate((Object)this._aot470LUT.getJavaArray(), (FractIndex[])indexes);
                aot470Tile.setSample(x, y, (float)aot470);
                double aot660 = Interp.interpolate((Object)this._aot660LUT.getJavaArray(), (FractIndex[])indexes);
                aot660Tile.setSample(x, y, (float)aot660);
                angTile.setSample(x, y, (float)((Math.log(aot470) - Math.log(aot660)) / logWavelengthDiff));
                int xInt = indexes[2].index;
                int yInt = indexes[1].index;
                int tFlag = 0;
                for (int prod = 0; prod < 2; ++prod) {
                    if (!this.gapFilled[prod][yInt][xInt]) continue;
                    tFlag = (byte)(tFlag + (1 << prod));
                }
                flagTile.setSample(x, y, tFlag);
            }
        }
    }

    private FlagCoding createFlagCoding(Product outputProduct) {
        FlagCoding flagCoding = new FlagCoding(BAND_NAME_FLAGS);
        flagCoding.setDescription("Cloud Flag Coding");
        int index = 0;
        int w = outputProduct.getSceneRasterWidth();
        int h = outputProduct.getSceneRasterHeight();
        MetadataAttribute cloudAttr = new MetadataAttribute("aerosol_lower_filled", 20);
        cloudAttr.getData().setElemInt(1);
        cloudAttr.setDescription("the lower aerosol source has been filled at this position");
        flagCoding.addAttribute(cloudAttr);
        Mask mask = Mask.BandMathsType.create((String)cloudAttr.getName(), (String)cloudAttr.getDescription(), (int)w, (int)h, (String)(flagCoding.getName() + "." + cloudAttr.getName()), (Color)this.createBitmaskColor(1, 3), (double)0.5);
        outputProduct.getMaskGroup().add(index++, (ProductNode)mask);
        cloudAttr = new MetadataAttribute("aerosol_upper_filled", 20);
        cloudAttr.getData().setElemInt(2);
        cloudAttr.setDescription("the upper aerosol source has been filled at this position");
        flagCoding.addAttribute(cloudAttr);
        mask = Mask.BandMathsType.create((String)cloudAttr.getName(), (String)cloudAttr.getDescription(), (int)w, (int)h, (String)(flagCoding.getName() + "." + cloudAttr.getName()), (Color)this.createBitmaskColor(2, 3), (double)0.5);
        outputProduct.getMaskGroup().add(index++, (ProductNode)mask);
        cloudAttr = new MetadataAttribute("aerosol_both_filled", 20);
        cloudAttr.getData().setElemInt(4);
        cloudAttr.setDescription("the lower and the upper aerosol source have been filled at this position");
        flagCoding.addAttribute(cloudAttr);
        mask = Mask.BandMathsType.create((String)cloudAttr.getName(), (String)cloudAttr.getDescription(), (int)w, (int)h, (String)(flagCoding.getName() + "." + cloudAttr.getName()), (Color)this.createBitmaskColor(3, 3), (double)0.5);
        outputProduct.getMaskGroup().add(index, (ProductNode)mask);
        return flagCoding;
    }

    private Color createBitmaskColor(int index, int maxIndex) {
        double rf1 = 0.3;
        double gf1 = 0.5;
        double bf1 = 1.0;
        double a = Math.PI * 2 * (double)index / (double)maxIndex;
        return new Color((float)(0.5 + 0.5 * Math.sin(a + 0.9424777960769379)), (float)(0.5 + 0.5 * Math.sin(a + 1.5707963267948966)), (float)(0.5 + 0.5 * Math.sin(a + Math.PI)));
    }

    private void readMod08() throws IOException {
        ProductData.UTC meanTime = ModisAerosolOp.getSceneRasterMeanTime(this.sourceProduct);
        if (meanTime == null) {
            throw new IOException("failed to retrieve sensing time information from input product");
        }
        Date sensingDate = meanTime.getAsDate();
        TemporalFile[] mod08Files = this.mod08FileArray.getTemporalFilesSorted(sensingDate, 2);
        this.gapFilled = new boolean[4][180][360];
        float[][][] aot470Data = this.createFromAuxData(mod08Files, 0);
        float[][][] aot660Data = this.createFromAuxData(mod08Files, 2);
        double[] timeTab = new double[]{ProductData.UTC.create((Date)mod08Files[1].getMeanDate(), (long)0L).getMJD(), ProductData.UTC.create((Date)mod08Files[0].getMeanDate(), (long)0L).getMJD()};
        double[] latTab = new double[180];
        for (int i = 0; i < latTab.length; ++i) {
            latTab[i] = 90.0 - (double)i - 0.5;
        }
        double[] lonTab = new double[360];
        for (int i = 0; i < lonTab.length; ++i) {
            lonTab[i] = (double)i - 180.0 + 0.5;
        }
        this._aot470LUT = new LUT((Object)aot470Data);
        this._aot470LUT.setTab(0, timeTab);
        this._aot470LUT.setTab(1, latTab);
        this._aot470LUT.setTab(2, lonTab);
        this._aot660LUT = new LUT((Object)aot660Data);
        this._aot660LUT.setTab(0, timeTab);
        this._aot660LUT.setTab(1, latTab);
        this._aot660LUT.setTab(2, lonTab);
    }

    private static ProductData.UTC getSceneRasterMeanTime(Product product) {
        ProductData.UTC startTime = product.getStartTime();
        ProductData.UTC stopTime = product.getEndTime();
        Object meanTime = startTime != null && stopTime != null ? new ProductData.UTC(0.5 * (startTime.getMJD() + stopTime.getMJD())) : (startTime != null ? startTime : (stopTime != null ? stopTime : null));
        return meanTime;
    }

    private float[][][] createFromAuxData(TemporalFile[] modFiles, int index) throws IOException {
        short[][][] mod08Data = new short[modFiles.length][180][360];
        float[][][] mod08DataFloat = new float[modFiles.length][180][360];
        for (int i = 0; i < modFiles.length; ++i) {
            ModisAerosolOp.readHDFdata(modFiles[i].getFile(), MOD08_BAND_NAME, index, mod08Data[i]);
            for (int y = 0; y < 180; ++y) {
                for (int x = 0; x < 360; ++x) {
                    short unscaled = mod08Data[i][y][x];
                    mod08DataFloat[i][y][x] = unscaled != -9999 ? (float)unscaled * 0.001f : 0.0f;
                }
            }
            this.gapFiller.findGaps(mod08DataFloat[i], 0.0f);
            this.gapFiller.fillGaps(mod08DataFloat[i], this.gapFilled[index + i]);
        }
        return mod08DataFloat;
    }

    private static void readHDFdata(File file, String datasetName, int index, short[][] array) throws IOException {
        int sdId;
        try {
            sdId = HDFLibrary.SDstart((String)file.getPath(), (int)1);
        }
        catch (HDFException e) {
            throw new IOException("File '" + file + "': HDF I/O exception: " + e.getMessage());
        }
        try {
            int sdIndex = HDFLibrary.SDnametoindex((int)sdId, (String)datasetName);
            if (sdIndex == -1 && (sdIndex = HDFLibrary.SDnametoindex((int)sdId, (String)datasetName.toUpperCase())) == -1) {
                throw new IOException("Couldn't find dataset: " + datasetName);
            }
            int sdsId = HDFLibrary.SDselect((int)sdId, (int)sdIndex);
            int[] sdDimensions = new int[]{1, 180, 360};
            int[] start = new int[]{index, 0, 0};
            int[] stride = new int[]{1, 1, 1};
            HDFLibrary.SDreaddata((int)sdsId, (int[])start, (int[])stride, (int[])sdDimensions, (Object)array);
            HDFLibrary.SDendaccess((int)sdsId);
        }
        catch (HDFException e) {
            throw new IOException("File '" + file + "': HDF I/O exception: " + e.getMessage());
        }
        finally {
            try {
                HDFLibrary.SDend((int)sdId);
            }
            catch (HDFException hDFException) {}
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ModisAerosolOp.class);
        }
    }
}

