/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.aerosol;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import org.esa.s3tbx.meris.aerosol.TemporalFile;
import org.esa.s3tbx.meris.aerosol.TemporalFileFactory;
import org.esa.snap.core.datamodel.ProductData;

public class MOD08FileFactory
implements TemporalFileFactory {
    private static final int AVG_PERIOD_IN_DAYS = 8;
    private static final long AVG_PERIOD_IN_MILLIS = 691200000L;
    private static final String FILENAME_PART = "MOD08_E3";
    private static final String FILENAME_DATE_START = ".A";
    private static final String FILENAME_SUFFIX = ".hdf";

    @Override
    public TemporalFile createTemporalFile(File file) {
        int dayOfYear;
        int year;
        String filename = file.getName();
        if (!filename.endsWith(FILENAME_SUFFIX)) {
            return null;
        }
        if (filename.indexOf(FILENAME_PART) == -1 || filename.indexOf(FILENAME_DATE_START) == -1) {
            return null;
        }
        int dateStart = filename.indexOf(FILENAME_DATE_START);
        int yearOffset = dateStart + FILENAME_DATE_START.length();
        int dayOffset = yearOffset + 4;
        try {
            year = Integer.parseInt(filename.substring(yearOffset, yearOffset + 4));
            dayOfYear = Integer.parseInt(filename.substring(dayOffset, dayOffset + 3));
        }
        catch (NumberFormatException e) {
            return null;
        }
        long startTime = MOD08FileFactory.computeTime(year, dayOfYear);
        long endTime = startTime + 691200000L - 1L;
        return new TemporalFile(file, new Date(startTime), new Date(endTime));
    }

    private static long computeTime(int year, int dayOfYear) {
        Calendar calendar = MOD08FileFactory.createUTCCalendar();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(6, dayOfYear);
        calendar.set(11, 0);
        return calendar.getTimeInMillis();
    }

    private static Calendar createUTCCalendar() {
        return ProductData.UTC.createCalendar();
    }
}

