/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.aerosol;

public class GapFiller {
    private final int overlap;
    private int width;
    private int height;
    private boolean[][] isGap;

    public GapFiller() {
        this(0);
    }

    public GapFiller(int overlap) {
        if (overlap < 0) {
            throw new IllegalArgumentException("overlap < 0");
        }
        this.overlap = overlap;
    }

    public void setWidthHeight(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void findGaps(float[][] data, float gapValue) {
        this.isGap = new boolean[this.height][this.width];
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.isGap[y][x] = data[y][x] == gapValue;
            }
        }
    }

    public void fillGaps(float[][] data, boolean[][] filled) {
        int s = (int)this.getNextBase2Num(Math.max(this.width, this.height));
        this.fillGapsRecursive(data, filled, (this.width - s) / 2, (this.height - s) / 2, s, s);
    }

    private long getNextBase2Num(int x) {
        long y = 0L;
        if (x != 0) {
            long n = Math.abs(x);
            for (y = 1L; y <= n; y *= 2L) {
            }
            y *= x > 0 ? 1L : -1L;
        }
        return y;
    }

    private void fillGapsRecursive(float[][] data, boolean[][] filled, int x0, int y0, int sw, int sh) {
        if (sw == 0 || sh == 0) {
            return;
        }
        int x2 = x0 + sw - 1;
        int y2 = y0 + sh - 1;
        if (this.fillGapsImpl(data, filled, x0 - this.overlap, y0 - this.overlap, x2 + this.overlap, y2 + this.overlap)) {
            int swNew = sw / 2;
            int shNew = sh / 2;
            this.fillGapsRecursive(data, filled, x0, y0, swNew, shNew);
            this.fillGapsRecursive(data, filled, x0 + swNew, y0, swNew, shNew);
            this.fillGapsRecursive(data, filled, x0, y0 + shNew, swNew, shNew);
            this.fillGapsRecursive(data, filled, x0 + swNew, y0 + shNew, swNew, shNew);
        }
    }

    private boolean fillGapsImpl(float[][] data, boolean[][] filled, int x1, int y1, int x2, int y2) {
        if (x2 < 0 || y2 < 0 || x1 >= this.width || y1 >= this.height) {
            return false;
        }
        if (x1 < 0) {
            x1 = 0;
        }
        if (y1 < 0) {
            y1 = 0;
        }
        if (x2 >= this.width) {
            x2 = this.width - 1;
        }
        if (y2 >= this.height) {
            y2 = this.height - 1;
        }
        if (x1 == x2 && y1 == y2) {
            return false;
        }
        this.fillGaps(data, filled, x1, y1, x2, y2);
        return true;
    }

    private void fillGaps(float[][] data, boolean[][] filled, int x1, int y1, int x2, int y2) {
        int numGaps = 0;
        int numValues = 0;
        float sumValues = 0.0f;
        for (int y = y1; y <= y2; ++y) {
            for (int x = x1; x <= x2; ++x) {
                if (this.isGap[y][x]) {
                    ++numGaps;
                    continue;
                }
                sumValues += data[y][x];
                ++numValues;
            }
        }
        if (numGaps > 0 && numValues > 0) {
            float avg = sumValues / (float)numValues;
            for (int y = y1; y <= y2; ++y) {
                for (int x = x1; x <= x2; ++x) {
                    if (!this.isGap[y][x]) continue;
                    data[y][x] = avg;
                    filled[y][x] = true;
                }
            }
        }
    }
}

