/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.aerosol;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import org.esa.s3tbx.meris.aerosol.TemporalFile;
import org.esa.s3tbx.meris.aerosol.TemporalFileFactory;
import org.esa.snap.core.datamodel.ProductData;

public class ClimFileFactory
implements TemporalFileFactory {
    private static final int TIME1_OFFSET = 10;
    private static final int TIME2_OFFSET = 17;
    private static final String FILENAME_PREFIX = "CLIM_GADS_";
    private static final String FILENAME_SUFFIX = ".hdf";

    @Override
    public TemporalFile createTemporalFile(File file) {
        int month2;
        int year2;
        int month1;
        int year1;
        String filename = file.getName();
        if (filename.length() < 21) {
            return null;
        }
        if (!filename.startsWith(FILENAME_PREFIX)) {
            return null;
        }
        if (!filename.endsWith(FILENAME_SUFFIX)) {
            return null;
        }
        try {
            year1 = Integer.parseInt(filename.substring(10, 14));
            month1 = Integer.parseInt(filename.substring(14, 16));
            year2 = Integer.parseInt(filename.substring(17, 21));
            month2 = Integer.parseInt(filename.substring(21, 23));
        }
        catch (NumberFormatException e) {
            return null;
        }
        long startTime = ClimFileFactory.computeTime(year1, month1);
        long endTime = ClimFileFactory.computeTime(year2, month2 + 1) - 1L;
        return new TemporalFile(file, new Date(startTime), new Date(endTime));
    }

    private static long computeTime(int year, int month) {
        Calendar calendar = ClimFileFactory.createUTCCalendar();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        return calendar.getTimeInMillis();
    }

    private static Calendar createUTCCalendar() {
        return ProductData.UTC.createCalendar();
    }
}

