/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.aerosol;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Map;
import org.esa.s3tbx.meris.MerisBasisOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;

@OperatorMetadata(alias="Meris.AerosolMerger", internal=true)
public class AerosolMergerOp
extends MerisBasisOp {
    private static final int LARS_FLAG = 1;
    private static final int MOD08_FLAG = 2;
    private static final int DEFAULT_FLAG = 4;
    private static final float AOT_DEFAULT = 0.1f;
    private static final float ANG_DEFAULT = 1.0f;
    private Band aot470Band;
    private Band angstrBand;
    private Band flagBand;
    @SourceProduct(alias="l2")
    private Product l2Product;
    @SourceProduct(alias="mod08")
    private Product mod08Product;
    @TargetProduct
    private Product targetProduct;

    public void initialize() throws OperatorException {
        this.targetProduct = this.createCompatibleProduct(this.mod08Product, "AEROSOL", "AEROSOL");
        this.aot470Band = this.targetProduct.addBand("aot_470", 30);
        this.angstrBand = this.targetProduct.addBand("ang", 30);
        FlagCoding cloudFlagCoding = this.createFlagCoding(this.mod08Product);
        this.mod08Product.getFlagCodingGroup().add((ProductNode)cloudFlagCoding);
        this.flagBand = this.targetProduct.addBand("aerosol_flags", 20);
        this.flagBand.setDescription("Aerosol specific flags");
        this.flagBand.setSampleCoding((SampleCoding)cloudFlagCoding);
    }

    private FlagCoding createFlagCoding(Product outputProduct) {
        FlagCoding flagCoding = new FlagCoding("aerosol_flags");
        flagCoding.setDescription("Cloud Flag Coding");
        int index = 0;
        int w = outputProduct.getSceneRasterWidth();
        int h = outputProduct.getSceneRasterHeight();
        MetadataAttribute cloudAttr = new MetadataAttribute("lars", 20);
        cloudAttr.getData().setElemInt(1);
        flagCoding.addAttribute(cloudAttr);
        Mask mask = Mask.BandMathsType.create((String)cloudAttr.getName(), (String)cloudAttr.getDescription(), (int)w, (int)h, (String)(flagCoding.getName() + "." + cloudAttr.getName()), (Color)Color.BLUE, (double)0.5);
        outputProduct.getMaskGroup().add(index++, (ProductNode)mask);
        cloudAttr = new MetadataAttribute("mod08", 20);
        cloudAttr.getData().setElemInt(2);
        flagCoding.addAttribute(cloudAttr);
        mask = Mask.BandMathsType.create((String)cloudAttr.getName(), (String)cloudAttr.getDescription(), (int)w, (int)h, (String)(flagCoding.getName() + "." + cloudAttr.getName()), (Color)Color.RED, (double)0.5);
        outputProduct.getMaskGroup().add(index++, (ProductNode)mask);
        cloudAttr = new MetadataAttribute("default", 20);
        cloudAttr.getData().setElemInt(4);
        flagCoding.addAttribute(cloudAttr);
        mask = Mask.BandMathsType.create((String)cloudAttr.getName(), (String)cloudAttr.getDescription(), (int)w, (int)h, (String)(flagCoding.getName() + "." + cloudAttr.getName()), (Color)Color.GREEN, (double)0.5);
        outputProduct.getMaskGroup().add(index, (ProductNode)mask);
        return flagCoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle rectangle, ProgressMonitor pm) throws OperatorException {
        int size = rectangle.height * rectangle.width;
        pm.beginTask("Processing frame...", 1 + size);
        try {
            float[] modAot = (float[])this.getSourceTile((RasterDataNode)this.mod08Product.getBand("aot_470"), rectangle).getRawSamples().getElems();
            float[] modAng = (float[])this.getSourceTile((RasterDataNode)this.mod08Product.getBand("ang"), rectangle).getRawSamples().getElems();
            byte[] modFlag = (byte[])this.getSourceTile((RasterDataNode)this.mod08Product.getBand("aerosol_flags"), rectangle).getRawSamples().getElems();
            float[] l2Aot = (float[])this.getSourceTile((RasterDataNode)this.l2Product.getBand("aero_opt_thick_443"), rectangle).getRawSamples().getElems();
            float[] l2Ang = (float[])this.getSourceTile((RasterDataNode)this.l2Product.getBand("aero_alpha"), rectangle).getRawSamples().getElems();
            ProductData rawSampleDataAot470 = targetTiles.get(this.aot470Band).getRawSamples();
            float[] aot470 = (float[])rawSampleDataAot470.getElems();
            ProductData rawSampleDataAng = targetTiles.get(this.aot470Band).getRawSamples();
            float[] ang = (float[])rawSampleDataAng.getElems();
            ProductData rawSampleDataFlag = targetTiles.get(this.flagBand).getRawSamples();
            byte[] flag = (byte[])rawSampleDataFlag.getElems();
            for (int i = 0; i < size; ++i) {
                if (l2Aot[i] >= 0.0f && l2Ang[i] >= 0.0f) {
                    aot470[i] = l2Aot[i];
                    ang[i] = l2Ang[i];
                    flag[i] = 1;
                } else if (modFlag[i] == 0) {
                    aot470[i] = modAot[i];
                    ang[i] = modAng[i];
                    flag[i] = 2;
                } else {
                    aot470[i] = 0.1f;
                    ang[i] = 1.0f;
                    flag[i] = 4;
                }
                pm.worked(1);
            }
            targetTiles.get(this.aot470Band).setRawSamples(rawSampleDataAot470);
            targetTiles.get(this.aot470Band).setRawSamples(rawSampleDataAng);
            targetTiles.get(this.flagBand).setRawSamples(rawSampleDataFlag);
        }
        finally {
            pm.done();
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(AerosolMergerOp.class);
        }
    }
}

