/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.esa.s3tbx.meris.MerisBasisOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.common.BandMathsOp;
import org.esa.snap.core.util.ProductUtils;

@OperatorMetadata(alias="Meris.GapLessSdr", internal=true)
public class GapLessSdrOp
extends MerisBasisOp {
    private Map<Band, Band> sdrBands;
    private Map<Band, Band> toarBands;
    private Band invalidBand;
    @SourceProduct(alias="sdr")
    private Product sdrProduct;
    @SourceProduct(alias="toar")
    private Product toarProduct;
    @TargetProduct
    private Product targetProduct;

    public void initialize() throws OperatorException {
        String[] bandNames;
        this.targetProduct = this.createCompatibleProduct(this.sdrProduct, "MER_SDR", "MER_SDR");
        this.sdrBands = new HashMap<Band, Band>();
        this.toarBands = new HashMap<Band, Band>();
        for (String bandName : bandNames = this.sdrProduct.getBandNames()) {
            if (!bandName.startsWith("sdr_") || bandName.endsWith("flags")) continue;
            Band targetBand = ProductUtils.copyBand((String)bandName, (Product)this.sdrProduct, (Product)this.targetProduct, (boolean)false);
            Band sdrBand = this.sdrProduct.getBand(bandName);
            this.sdrBands.put(targetBand, sdrBand);
            String toarBandName = bandName.replaceFirst("sdr", "toar");
            Band toarBand = this.toarProduct.getBand(toarBandName);
            this.toarBands.put(targetBand, toarBand);
        }
        this.invalidBand = GapLessSdrOp.createBooleanExpressionBand("l2_flags_p1.F_INVALID", this.toarProduct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle rectangle = targetTile.getRectangle();
        pm.beginTask("Processing frame...", rectangle.height + 1);
        try {
            Tile sdrTile = this.getSourceTile((RasterDataNode)this.sdrBands.get(band), rectangle);
            Tile toarTile = this.getSourceTile((RasterDataNode)this.toarBands.get(band), rectangle);
            Tile invalid = this.getSourceTile((RasterDataNode)this.invalidBand, rectangle);
            pm.worked(1);
            for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                    float sdr = sdrTile.getSampleFloat(x, y);
                    if (invalid.getSampleBoolean(x, y) || sdr != -1.0f && sdr != 0.0f) {
                        targetTile.setSample(x, y, sdr);
                        continue;
                    }
                    targetTile.setSample(x, y, toarTile.getSampleFloat(x, y));
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    private static Band createBooleanExpressionBand(String expression, Product sourceProduct) {
        BandMathsOp.BandDescriptor bandDescriptor = new BandMathsOp.BandDescriptor();
        bandDescriptor.name = "band1";
        bandDescriptor.expression = expression;
        bandDescriptor.type = "int8";
        BandMathsOp bandMathsOp = new BandMathsOp();
        bandMathsOp.setParameterDefaultValues();
        bandMathsOp.setSourceProduct(sourceProduct);
        bandMathsOp.setTargetBandDescriptors(new BandMathsOp.BandDescriptor[]{bandDescriptor});
        return bandMathsOp.getTargetProduct().getBandAt(0);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(GapLessSdrOp.class);
        }
    }
}

