/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris;

import com.bc.ceres.core.ProgressMonitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.s3tbx.meris.MerisBasisOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;

@OperatorMetadata(alias="FillBand", internal=true)
public class FillBandOp
extends MerisBasisOp {
    private Map<Band, Float> defaultMap;
    private Configuration config = new Configuration();
    @SourceProduct(alias="input")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;

    public void initialize() throws OperatorException {
        this.targetProduct = this.createCompatibleProduct(this.sourceProduct, "fille_band", "FILL");
        this.defaultMap = new HashMap<Band, Float>(this.config.bands.size());
        for (BandDesc bandDesc : this.config.bands) {
            Band targetBand = this.targetProduct.addBand(bandDesc.name, 30);
            this.defaultMap.put(targetBand, Float.valueOf(bandDesc.defaultValue));
        }
    }

    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        ProductData rawSampleData = targetTile.getRawSamples();
        float[] outValues = (float[])rawSampleData.getElems();
        float defaultValue = this.defaultMap.get(band).floatValue();
        Arrays.fill(outValues, defaultValue);
        targetTile.setRawSamples(rawSampleData);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(FillBandOp.class);
        }
    }

    public static class BandDesc {
        String name;
        float defaultValue;
    }

    private static class Configuration {
        private List<BandDesc> bands = new ArrayList<BandDesc>();
    }
}

