/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.s3tbx.meris.MerisBasisOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.common.BandMathsOp;
import org.esa.snap.core.util.RectangleExtender;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.math.MathUtils;

@OperatorMetadata(alias="FillAerosol", internal=true)
public class FillAerosolOp
extends MerisBasisOp {
    private RectangleExtender rectCalculator;
    private Map<Band, Band> sourceBands;
    private Map<Band, Band> defaultBands;
    private Product validProduct;
    private double[][] weights;
    private Rectangle sourceProductRect;
    @SourceProduct(alias="input")
    private Product sourceProduct;
    @SourceProduct(alias="default")
    private Product defaultProduct;
    @SourceProduct(alias="mask", optional=true)
    private Product maskProduct;
    @TargetProduct
    private Product targetProduct;
    private Configuration config = new Configuration();

    public void initialize() throws OperatorException {
        this.targetProduct = this.createCompatibleProduct(this.sourceProduct, "fill_aerosol", "MER_L2");
        this.sourceBands = new HashMap<Band, Band>(this.config.bands.size());
        this.defaultBands = new HashMap<Band, Band>(this.config.bands.size());
        HashMap<String, BandMathsOp.BandDescriptor[]> parameters = new HashMap<String, BandMathsOp.BandDescriptor[]>();
        BandMathsOp.BandDescriptor[] bandDescriptors = new BandMathsOp.BandDescriptor[this.config.bands.size()];
        int i = 0;
        for (BandDesc bandDesc : this.config.bands) {
            Band srcBand = this.sourceProduct.getBand(bandDesc.inputBand);
            Band targetBand = this.targetProduct.addBand(bandDesc.name, 30);
            targetBand.setNoDataValue(-1.0);
            targetBand.setNoDataValueUsed(true);
            this.sourceBands.put(targetBand, srcBand);
            Band defaultBand = this.defaultProduct.getBand(bandDesc.defaultBand);
            this.defaultBands.put(targetBand, defaultBand);
            BandMathsOp.BandDescriptor bandDescriptor = new BandMathsOp.BandDescriptor();
            bandDescriptor.name = bandDesc.name;
            bandDescriptor.expression = bandDesc.validExp;
            bandDescriptor.type = "int8";
            bandDescriptors[i] = bandDescriptor;
            ++i;
        }
        parameters.put("targetBands", bandDescriptors);
        this.validProduct = GPF.createProduct((String)"BandMaths", parameters, (Product)this.sourceProduct);
        this.sourceProductRect = new Rectangle(this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.rectCalculator = this.config.frs ? new RectangleExtender(this.sourceProductRect, (this.config.pixelWidth + 1) * 4, (this.config.pixelWidth + 1) * 4) : new RectangleExtender(this.sourceProductRect, this.config.pixelWidth, this.config.pixelWidth);
        this.computeWeightMatrix();
    }

    private void computeWeightMatrix() {
        this.weights = new double[this.config.pixelWidth][this.config.pixelWidth];
        for (int y = 0; y < this.config.pixelWidth; ++y) {
            for (int x = 0; x < this.config.pixelWidth; ++x) {
                double w;
                this.weights[x][y] = w = Math.max(1.0 - Math.sqrt(x * x + y * y) / (double)this.config.pixelWidth, 0.0);
            }
        }
        this.weights[0][0] = 0.0;
    }

    private float computeInterpolatedValue(int x, int y, Rectangle sourceRect, float[] srcValues, boolean[] valid, float defaultValue) {
        float mean;
        double weigthSum = 0.0;
        double weigthSumTotal = 0.0;
        double tauSum = 0.0;
        int iyStart = Math.max(y - this.config.pixelWidth + 1, sourceRect.y);
        int iyEnd = Math.min(y + this.config.pixelWidth - 1, sourceRect.y + sourceRect.height);
        int ixStart = Math.max(x - this.config.pixelWidth + 1, sourceRect.x);
        int ixEnd = Math.min(x + this.config.pixelWidth - 1, sourceRect.x + sourceRect.width);
        for (int iy = iyStart; iy < iyEnd; ++iy) {
            int yDist = Math.abs(iy - y);
            int index = FillAerosolOp.convertToIndex(ixStart, iy, sourceRect);
            int ix = ixStart;
            while (ix < ixEnd) {
                int xDist = Math.abs(ix - x);
                double weight = this.weights[xDist][yDist];
                if (weight != 0.0) {
                    weigthSumTotal += weight;
                    if (valid[index]) {
                        weigthSum += weight;
                        tauSum += (double)srcValues[index] * weight;
                    }
                }
                ++ix;
                ++index;
            }
        }
        if (weigthSum > 0.0) {
            double tauTemp = tauSum / weigthSum;
            double ww = weigthSum / weigthSumTotal;
            int l3weighting = 8;
            double wwn = 1.0 - Math.pow(ww - 1.0, 8.0);
            double tau = wwn * tauTemp + (1.0 - wwn) * (double)defaultValue;
            mean = (float)tau;
        } else {
            mean = defaultValue;
        }
        return mean;
    }

    private static int convertToIndex(int x, int y, Rectangle rectangle) {
        return (y - rectangle.y) * rectangle.width + (x - rectangle.x);
    }

    private float[] getScaledArrayFromTile(Tile tile) {
        ProductData valueDataBuffer = tile.getRawSamples();
        float[] scaledValues = new float[valueDataBuffer.getNumElems()];
        RasterDataNode srcRasterDataNode = tile.getRasterDataNode();
        boolean scaled = srcRasterDataNode.isScalingApplied();
        for (int i = 0; i < scaledValues.length; ++i) {
            float value = valueDataBuffer.getElemFloatAt(i);
            if (scaled) {
                value = (float)srcRasterDataNode.scale((double)value);
            }
            scaledValues[i] = value;
        }
        return scaledValues;
    }

    private float[] getScaledArrayFromTileFRS(Tile tile) {
        ProductData valueDataBuffer = tile.getRawSamples();
        int frsWidth = tile.getRectangle().width;
        int frsHeight = tile.getRectangle().height;
        int width = MathUtils.ceilInt((double)((double)frsWidth / 4.0));
        int height = MathUtils.ceilInt((double)((double)frsHeight / 4.0));
        float[] scaledValues = new float[width * height];
        RasterDataNode srcRasterDataNode = tile.getRasterDataNode();
        boolean scaled = srcRasterDataNode.isScalingApplied();
        int scaledIndex = 0;
        for (int y = 0; y < frsHeight; y += 4) {
            int frsIndex = y * frsWidth;
            for (int x = 0; x < frsWidth; x += 4) {
                float value = valueDataBuffer.getElemFloatAt(frsIndex);
                if (scaled) {
                    value = (float)srcRasterDataNode.scale((double)value);
                }
                scaledValues[scaledIndex] = value;
                frsIndex += 4;
                ++scaledIndex;
            }
        }
        return scaledValues;
    }

    private boolean[] getArrayFromTileFRS(Tile tile) {
        ProductData dataBuffer = tile.getRawSamples();
        int frsWidth = tile.getRectangle().width;
        int frsHeight = tile.getRectangle().height;
        int width = MathUtils.ceilInt((double)((double)frsWidth / 4.0));
        int height = MathUtils.ceilInt((double)((double)frsHeight / 4.0));
        boolean[] values = new boolean[width * height];
        int scaledIndex = 0;
        for (int y = 0; y < frsHeight; y += 4) {
            int frsIndex = y * frsWidth;
            for (int x = 0; x < frsWidth; x += 4) {
                boolean value;
                values[scaledIndex] = value = dataBuffer.getElemBooleanAt(frsIndex);
                frsIndex += 4;
                ++scaledIndex;
            }
        }
        return values;
    }

    private boolean isMaskSetInRegion(int x, int y, int maxX, int maxY, Tile mask) {
        int ixEnd = Math.min(x + 4, maxX);
        int iyEnd = Math.min(y + 4, maxY);
        for (int iy = y; iy < iyEnd; ++iy) {
            for (int ix = x; ix < ixEnd; ++ix) {
                if (!mask.getSampleBoolean(ix, iy)) continue;
                return true;
            }
        }
        return false;
    }

    private void setValueInRegion(int x, int y, int maxX, int maxY, float v, SimpleTile simpleTile) {
        int ixEnd = Math.min(x + 4, maxX);
        int iyEnd = Math.min(y + 4, maxY);
        for (int iy = y; iy < iyEnd; ++iy) {
            for (int ix = x; ix < ixEnd; ++ix) {
                simpleTile.setSample(ix, iy, v);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetRect = targetTile.getRectangle();
        Rectangle sourceRect = this.rectCalculator.extend(targetRect);
        pm.beginTask("Processing frame...", sourceRect.height + 1);
        try {
            Tile maskTile = null;
            boolean useMask = false;
            if (this.maskProduct != null && StringUtils.isNotNullAndNotEmpty((String)this.config.maskBand)) {
                maskTile = this.getSourceTile((RasterDataNode)this.maskProduct.getBand(this.config.maskBand), sourceRect);
                useMask = true;
            }
            Tile defaultTile = this.getSourceTile((RasterDataNode)this.defaultBands.get(band), sourceRect);
            Tile validDataTile = this.getSourceTile((RasterDataNode)this.validProduct.getBand(band.getName()), sourceRect);
            Tile dataTile = this.getSourceTile((RasterDataNode)this.sourceBands.get(band), sourceRect);
            if (!this.config.frs) {
                float[] scaledData = this.getScaledArrayFromTile(dataTile);
                boolean[] validData = (boolean[])validDataTile.getRawSamples().getElems();
                for (int y = targetRect.y; y < targetRect.y + targetRect.height; ++y) {
                    for (int x = targetRect.x; x < targetRect.x + targetRect.width; ++x) {
                        if (!useMask || maskTile.getSampleBoolean(x, y)) {
                            if (validDataTile.getSampleBoolean(x, y)) {
                                targetTile.setSample(x, y, dataTile.getSampleFloat(x, y));
                                continue;
                            }
                            float defaultValue = defaultTile.getSampleFloat(x, y);
                            float v = this.computeInterpolatedValue(x, y, sourceRect, scaledData, validData, defaultValue);
                            targetTile.setSample(x, y, v);
                            continue;
                        }
                        targetTile.setSample(x, y, -1);
                    }
                    pm.worked(1);
                }
            } else {
                float[] scaledData = this.getScaledArrayFromTileFRS(dataTile);
                boolean[] validData = this.getArrayFromTileFRS(validDataTile);
                Rectangle sourceRectFRS = new Rectangle(MathUtils.ceilInt((double)((double)sourceRect.x / 4.0)), MathUtils.ceilInt((double)((double)sourceRect.y / 4.0)), MathUtils.ceilInt((double)((double)sourceRect.width / 4.0)), MathUtils.ceilInt((double)((double)sourceRect.height / 4.0)));
                Rectangle intermediateRectangle = new Rectangle(targetRect.x - 4, targetRect.y - 4, targetRect.width + 8, targetRect.height + 8);
                Rectangle productRect = this.sourceProductRect;
                intermediateRectangle = intermediateRectangle.intersection(productRect);
                SimpleTile intermediateRaster = new SimpleTile(intermediateRectangle);
                int maxX = intermediateRectangle.x + intermediateRectangle.width;
                int maxY = intermediateRectangle.y + intermediateRectangle.height;
                for (int y = intermediateRectangle.y; y < maxY; y += 4) {
                    for (int x = intermediateRectangle.x; x < maxX; x += 4) {
                        if (!useMask || this.isMaskSetInRegion(x, y, maxX, maxY, maskTile)) {
                            if (validDataTile.getSampleBoolean(x, y)) {
                                this.setValueInRegion(x, y, maxX, maxY, dataTile.getSampleFloat(x, y), intermediateRaster);
                                continue;
                            }
                            float defaultValue = defaultTile.getSampleFloat(x, y);
                            int x4 = (x + 1) / 4;
                            int y4 = (y + 1) / 4;
                            float v = this.computeInterpolatedValue(x4, y4, sourceRectFRS, scaledData, validData, defaultValue);
                            this.setValueInRegion(x, y, maxX, maxY, v, intermediateRaster);
                            continue;
                        }
                        this.setValueInRegion(x, y, maxX, maxY, -1.0f, intermediateRaster);
                    }
                    pm.worked(1);
                }
                int maxtX = targetRect.x + targetRect.width;
                int maxtY = targetRect.y + targetRect.height;
                for (int y = targetRect.y; y < maxtY; ++y) {
                    for (int x = targetRect.x; x < maxtX; ++x) {
                        if (intermediateRaster.getSample(x, y) == -1.0f) {
                            targetTile.setSample(x, y, -1);
                            continue;
                        }
                        float avg = 0.0f;
                        int count = 0;
                        int iyStart = Math.max(y - 1, intermediateRectangle.y);
                        int iyEnd = Math.min(y + 2, intermediateRectangle.y + intermediateRectangle.height);
                        int ixStart = Math.max(x - 1, intermediateRectangle.x);
                        int ixEnd = Math.min(x + 2, intermediateRectangle.x + intermediateRectangle.width);
                        for (int iy = iyStart; iy < iyEnd; ++iy) {
                            for (int ix = ixStart; ix < ixEnd; ++ix) {
                                float value = intermediateRaster.getSample(ix, iy);
                                if (value == -1.0f) continue;
                                avg += value;
                                ++count;
                            }
                        }
                        if (count <= 0) continue;
                        float value = avg / (float)count;
                        targetTile.setSample(x, y, value);
                    }
                }
            }
        }
        finally {
            pm.done();
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(FillAerosolOp.class);
        }
    }

    private static class SimpleTile {
        private final ProductData productData;
        private final Rectangle rectangle;

        private SimpleTile(Rectangle rectangle) {
            this.rectangle = rectangle;
            this.productData = ProductData.createInstance((int)30, (int)(rectangle.width * rectangle.height));
        }

        public float getSample(int x, int y) {
            int index = this.computeIndex(x, y);
            return this.productData.getElemFloatAt(index);
        }

        public void setSample(int x, int y, float v) {
            int index = this.computeIndex(x, y);
            this.productData.setElemFloatAt(index, v);
        }

        private int computeIndex(int x, int y) {
            return (y - this.rectangle.y) * this.rectangle.width + (x - this.rectangle.x);
        }
    }

    public static class BandDesc {
        String name;
        String inputBand;
        String validExp;
        String defaultBand;
    }

    private static class Configuration {
        private int pixelWidth;
        private boolean frs = true;
        private String maskBand;
        private List<BandDesc> bands = new ArrayList<BandDesc>();
    }
}

