/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.radiometry.equalization;

import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.StringUtils;

public enum ReprocessingVersion {
    AUTO_DETECT(-1),
    REPROCESSING_2(2),
    REPROCESSING_3(3);

    private static final String ELEM_NAME_DSD = "DSD";
    private static final String ATTRIBUTE_FILE_NAME = "FILE_NAME";
    private static final String REDUCED_RESOLUTION_PREFIX = "MER_R";
    private static final int REPRO2_RR_START_DATE = 20050607;
    private static final int REPRO2_FR_START_DATE = 20050708;
    private static final int REPRO3_RR_START_DATE = 20091008;
    private static final int REPRO3_FR_START_DATE = 20091008;
    private int version;

    private ReprocessingVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public static ReprocessingVersion autoDetect(Product product) {
        MetadataElement dsdElement = product.getMetadataRoot().getElement(ELEM_NAME_DSD);
        if (dsdElement != null) {
            MetadataElement[] dsdElements;
            for (MetadataElement element : dsdElements = dsdElement.getElements()) {
                boolean reduced;
                ReprocessingVersion version;
                String calibrationFileName;
                String datasetName = element.getAttributeString("DATASET_NAME", "").toLowerCase();
                if (!datasetName.startsWith("radiometric") || !datasetName.contains("calibration") || !StringUtils.isNotNullAndNotEmpty((String)(calibrationFileName = element.getAttributeString(ATTRIBUTE_FILE_NAME))) || AUTO_DETECT.equals((Object)(version = ReprocessingVersion.detectReprocessingVersion(calibrationFileName, reduced = product.getProductType().startsWith(REDUCED_RESOLUTION_PREFIX))))) continue;
                return version;
            }
        }
        return AUTO_DETECT;
    }

    static ReprocessingVersion detectReprocessingVersion(String calibrationFileName, boolean isReduced) {
        if (StringUtils.isNullOrEmpty((String)calibrationFileName)) {
            return AUTO_DETECT;
        }
        String parsedDate = calibrationFileName.substring(14, 22);
        int date = Integer.parseInt(parsedDate);
        if (isReduced) {
            return ReprocessingVersion.getReprocessingVersion(date, 20050607, 20091008);
        }
        return ReprocessingVersion.getReprocessingVersion(date, 20050708, 20091008);
    }

    private static ReprocessingVersion getReprocessingVersion(int date, int repro2RrStartDate, int repro3FrStartDate) {
        if (date >= repro2RrStartDate && date < repro3FrStartDate) {
            return REPROCESSING_2;
        }
        if (date >= repro3FrStartDate) {
            return REPROCESSING_3;
        }
        return AUTO_DETECT;
    }
}

