/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.radiometry.smilecorr;

import com.bc.ceres.core.ProgressMonitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.StringTokenizer;
import org.esa.snap.core.util.ResourceInstaller;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.dataio.envisat.EnvisatConstants;

public class SmileCorrectionAuxdata {
    private static final String BAND_INFO_FILENAME = "band_info.txt";
    private static final String CENTRAL_WAVELEN_FR_FILENAME = "central_wavelen_fr.txt";
    private static final String CENTRAL_WAVELEN_RR_FILENAME = "central_wavelen_rr.txt";
    private static final String SUN_SPECTRAL_FLUX_FR_FILENAME = "sun_spectral_flux_fr.txt";
    private static final String SUN_SPECTRAL_FLUX_RR_FILENAME = "sun_spectral_flux_rr.txt";
    private static final int NUM_DETECTORS_FR = 3700;
    private static final int NUM_DETECTORS_RR = 925;
    private boolean[] radCorrFlagsLand;
    private int[] lowerBandIndexesLand;
    private int[] upperBandIndexesLand;
    private boolean[] radCorrFlagsWater;
    private int[] lowerBandIndexesWater;
    private int[] upperBandIndexesWater;
    private double[] theoreticalWavelengths;
    private double[] theoreticalSunSpectralFluxes;
    private double[][] detectorWavelengths;
    private double[][] detectorSunSpectralFluxes;
    private final Path auxdataDir;

    private SmileCorrectionAuxdata(Path auxdataDir, String detectorWavelengthsFilename, String detectorSunSpectralFluxesFilename, int numRows, int numCols) throws IOException {
        this.auxdataDir = auxdataDir;
        this.loadBandInfos();
        this.loadDetectorData(detectorWavelengthsFilename, detectorSunSpectralFluxesFilename, numRows, numCols);
    }

    public static SmileCorrectionAuxdata loadAuxdata(String productType) throws IOException {
        Path auxdataDir = SmileCorrectionAuxdata.installAuxdata();
        if (productType.startsWith("MER_F")) {
            return SmileCorrectionAuxdata.loadFRAuxdata(auxdataDir);
        }
        if (productType.startsWith("MER_R")) {
            return SmileCorrectionAuxdata.loadRRAuxdata(auxdataDir);
        }
        throw new IOException(String.format("No auxillary data found for input product of type '%s'", productType));
    }

    public boolean[] getRadCorrFlagsWater() {
        return this.radCorrFlagsWater;
    }

    public int[] getLowerBandIndexesWater() {
        return this.lowerBandIndexesWater;
    }

    public int[] getUpperBandIndexesWater() {
        return this.upperBandIndexesWater;
    }

    public boolean[] getRadCorrFlagsLand() {
        return this.radCorrFlagsLand;
    }

    public int[] getLowerBandIndexesLand() {
        return this.lowerBandIndexesLand;
    }

    public int[] getUpperBandIndexesLand() {
        return this.upperBandIndexesLand;
    }

    public double[] getTheoreticalWavelengths() {
        return this.theoreticalWavelengths;
    }

    public double[] getTheoreticalSunSpectralFluxes() {
        return this.theoreticalSunSpectralFluxes;
    }

    public double[][] getDetectorWavelengths() {
        return this.detectorWavelengths;
    }

    public double[][] getDetectorSunSpectralFluxes() {
        return this.detectorSunSpectralFluxes;
    }

    public static SmileCorrectionAuxdata loadRRAuxdata(Path auxdataDir) throws IOException {
        return new SmileCorrectionAuxdata(auxdataDir, CENTRAL_WAVELEN_RR_FILENAME, SUN_SPECTRAL_FLUX_RR_FILENAME, 925, EnvisatConstants.MERIS_L1B_NUM_SPECTRAL_BANDS);
    }

    public static SmileCorrectionAuxdata loadFRAuxdata(Path auxdataDir) throws IOException {
        return new SmileCorrectionAuxdata(auxdataDir, CENTRAL_WAVELEN_FR_FILENAME, SUN_SPECTRAL_FLUX_FR_FILENAME, 3700, EnvisatConstants.MERIS_L1B_NUM_SPECTRAL_BANDS);
    }

    private void loadBandInfos() throws IOException {
        double[][] table = this.loadFlatAuxDataFile(BAND_INFO_FILENAME, 15, 8);
        int n = EnvisatConstants.MERIS_L1B_NUM_SPECTRAL_BANDS;
        this.radCorrFlagsLand = new boolean[n];
        this.lowerBandIndexesLand = new int[n];
        this.upperBandIndexesLand = new int[n];
        this.radCorrFlagsWater = new boolean[n];
        this.lowerBandIndexesWater = new int[n];
        this.upperBandIndexesWater = new int[n];
        this.theoreticalWavelengths = new double[n];
        this.theoreticalSunSpectralFluxes = new double[n];
        for (int i = 0; i < n; ++i) {
            double[] row = table[i];
            this.radCorrFlagsLand[i] = row[0] != 0.0;
            this.lowerBandIndexesLand[i] = (int)row[1] - 1;
            this.upperBandIndexesLand[i] = (int)row[2] - 1;
            this.radCorrFlagsWater[i] = row[3] != 0.0;
            this.lowerBandIndexesWater[i] = (int)row[4] - 1;
            this.upperBandIndexesWater[i] = (int)row[5] - 1;
            this.theoreticalWavelengths[i] = row[6];
            this.theoreticalSunSpectralFluxes[i] = row[7];
        }
    }

    private void loadDetectorData(String detectorWavelengthsFilename, String detectorSunSpectralFluxesFilename, int numRows, int numCols) throws IOException {
        this.detectorWavelengths = this.loadFlatAuxDataFile(detectorWavelengthsFilename, numRows, numCols);
        this.detectorSunSpectralFluxes = this.loadFlatAuxDataFile(detectorSunSpectralFluxesFilename, numRows, numCols);
    }

    private double[][] loadFlatAuxDataFile(String auxFileName, int numRows, int numCols) throws IOException {
        double[][] tableData = new double[numRows][numCols];
        IOException ioError = null;
        try (BufferedReader reader = this.openFlatAuxDataFile(auxFileName);){
            SmileCorrectionAuxdata.readFlatAuxDataFile(tableData, reader);
        }
        catch (IOException e) {
            ioError = e;
        }
        if (ioError != null) {
            throw ioError;
        }
        return tableData;
    }

    private BufferedReader openFlatAuxDataFile(String fileName) throws IOException {
        assert (fileName != null);
        assert (fileName.length() > 0);
        return Files.newBufferedReader(this.auxdataDir.resolve(fileName));
    }

    private static void readFlatAuxDataFile(double[][] xrWLs, BufferedReader reader) throws IOException {
        String line;
        int numRows = xrWLs.length;
        int numCols = xrWLs[0].length;
        int row = -1;
        while ((line = reader.readLine()) != null) {
            if (row >= 0 && row < numRows) {
                StringTokenizer st = new StringTokenizer(line, " \t", false);
                int col = -1;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (col >= 0 && col < numCols) {
                        xrWLs[row][col] = Double.parseDouble(token);
                    }
                    ++col;
                }
            }
            ++row;
        }
    }

    static Path installAuxdata() throws IOException {
        Path auxdataDirectory = SystemUtils.getAuxDataPath().resolve("meris/smile-correction");
        Path sourceDirPath = ResourceInstaller.findModuleCodeBasePath(SmileCorrectionAuxdata.class).resolve("auxdata/smile");
        ResourceInstaller resourceInstaller = new ResourceInstaller(sourceDirPath, auxdataDirectory);
        resourceInstaller.install(".*", ProgressMonitor.NULL);
        return auxdataDirectory;
    }
}

