/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.radiometry.equalization;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.snap.core.util.io.CsvReader;

class EqualizationLUT {
    private List<Map<Integer, double[]>> coefficientsMapList;

    EqualizationLUT(Reader[] bandCoefficientReaders) throws IOException {
        this.coefficientsMapList = new ArrayList<Map<Integer, double[]>>(bandCoefficientReaders.length);
        for (Reader bandCoefficientReader : bandCoefficientReaders) {
            HashMap<Integer, double[]> coefMap = new HashMap<Integer, double[]>();
            try (CsvReader csvReader = new CsvReader(bandCoefficientReader, new char[]{' '});){
                double[] coefs = csvReader.readDoubleRecord();
                while (coefs != null) {
                    coefMap.put(csvReader.getLineNumber() - 1, coefs);
                    coefs = csvReader.readDoubleRecord();
                }
            }
            this.coefficientsMapList.add(coefMap);
        }
    }

    double[] getCoefficients(int bandIndex, int detectorIndex) {
        Map<Integer, double[]> coefMap = this.coefficientsMapList.get(bandIndex);
        return coefMap.get(detectorIndex);
    }
}

