/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.radiometry.equalization;

import com.bc.ceres.core.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.esa.s3tbx.meris.radiometry.equalization.EqualizationLUT;
import org.esa.s3tbx.meris.radiometry.equalization.ReprocessingVersion;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.OperatorException;

public class EqualizationAlgorithm {
    private EqualizationLUT equalizationLUT;
    private long julianDate;

    public EqualizationAlgorithm(Product product, ReprocessingVersion version) {
        this(product.getStartTime(), EqualizationAlgorithm.createLut(EqualizationAlgorithm.getReprocessingVersion(product, version), EqualizationAlgorithm.isFullResolution(product)));
    }

    public EqualizationAlgorithm(ProductData.UTC utc, EqualizationLUT equalizationLUT) {
        Calendar calendar = utc.getAsCalendar();
        long productJulianDate = EqualizationAlgorithm.toJulianDay(calendar.get(1), calendar.get(2), calendar.get(5));
        this.julianDate = productJulianDate - EqualizationAlgorithm.toJulianDay(2002, 4, 1);
        this.equalizationLUT = equalizationLUT;
    }

    long getJulianDate() {
        return this.julianDate;
    }

    public double performEqualization(double value, int spectralIndex, int detectorIndex) {
        Assert.argument((spectralIndex >= 0 && spectralIndex <= 14 ? 1 : 0) != 0, (String)"spectralIndex < 0 && spectralIndex > 14");
        Assert.argument((detectorIndex >= 0 ? 1 : 0) != 0, (String)"detectorIndex < 0");
        double[] coefficients = this.equalizationLUT.getCoefficients(spectralIndex, detectorIndex);
        double cEq = coefficients[0] + coefficients[1] * (double)this.julianDate + coefficients[2] * (double)this.julianDate * (double)this.julianDate;
        if (cEq == 0.0) {
            return value;
        }
        return value / cEq;
    }

    private static boolean isFullResolution(Product product) {
        return product.getProductType().startsWith("MER_F");
    }

    static long toJulianDay(int year, int month, int dayOfMonth) {
        double millisPerDay = 8.64E7;
        double epochJulianDate = -2440587.5;
        GregorianCalendar utc = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        utc.clear();
        utc.set(year, month, dayOfMonth, 0, 0, 0);
        utc.set(14, 0);
        return (long)((double)utc.getTimeInMillis() / 8.64E7 - -2440587.5);
    }

    private static ReprocessingVersion getReprocessingVersion(Product product, ReprocessingVersion version) {
        if (ReprocessingVersion.AUTO_DETECT.equals((Object)version)) {
            return EqualizationAlgorithm.autoDetectReprocessingVersion(product);
        }
        return version;
    }

    private static ReprocessingVersion autoDetectReprocessingVersion(Product product) {
        ReprocessingVersion reprocessingVersion = ReprocessingVersion.autoDetect(product);
        if (ReprocessingVersion.AUTO_DETECT.equals((Object)reprocessingVersion)) {
            throw new OperatorException("Reprocessing version could not be detected.\nPlease specify reprocessing version manually.");
        }
        return reprocessingVersion;
    }

    private static EqualizationLUT createLut(ReprocessingVersion reprocessingVersion, boolean fullResolution) {
        EqualizationLUT lut;
        try {
            List<Reader> readerList = EqualizationAlgorithm.getCoefficientsReaders(reprocessingVersion, fullResolution);
            Reader[] readers = readerList.toArray(new Reader[readerList.size()]);
            lut = new EqualizationLUT(readers);
        }
        catch (IOException e) {
            throw new IllegalStateException("Not able to create LUT.", e);
        }
        return lut;
    }

    private static List<Reader> getCoefficientsReaders(ReprocessingVersion reprocessingVersion, boolean fullResolution) {
        String coefFilePattern = "Equalization_coefficient_band_%02d_reprocessing_r%d_%s.txt";
        int bandCount = 15;
        ArrayList<Reader> readerList = new ArrayList<Reader>();
        for (int i = 1; i <= 15; ++i) {
            InputStream stream = EqualizationLUT.class.getResourceAsStream(String.format("Equalization_coefficient_band_%02d_reprocessing_r%d_%s.txt", i, reprocessingVersion.getVersion(), fullResolution ? "FR" : "RR"));
            readerList.add(new InputStreamReader(stream));
        }
        return readerList;
    }
}

