/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.radiometry.smilecorr;

import org.esa.s3tbx.meris.radiometry.smilecorr.SmileCorrectionAuxdata;

public class SmileCorrectionAlgorithm {
    private final SmileCorrectionAuxdata auxdata;

    public SmileCorrectionAlgorithm(SmileCorrectionAuxdata auxdata) {
        this.auxdata = auxdata;
    }

    public double correct(int bandIndex, int detectorIndex, double[] radianceSamples, boolean isLand) {
        int[] upperIndexes;
        int[] lowerIndexes;
        boolean[] shouldCorrect;
        double originalValue = radianceSamples[bandIndex];
        if (detectorIndex < 0 || detectorIndex >= this.auxdata.getDetectorWavelengths().length) {
            return originalValue;
        }
        if (isLand) {
            shouldCorrect = this.auxdata.getRadCorrFlagsLand();
            lowerIndexes = this.auxdata.getLowerBandIndexesLand();
            upperIndexes = this.auxdata.getUpperBandIndexesLand();
        } else {
            shouldCorrect = this.auxdata.getRadCorrFlagsWater();
            lowerIndexes = this.auxdata.getLowerBandIndexesWater();
            upperIndexes = this.auxdata.getUpperBandIndexesWater();
        }
        double[] detectorE0s = this.auxdata.getDetectorSunSpectralFluxes()[detectorIndex];
        double[] detectorWLs = this.auxdata.getDetectorWavelengths()[detectorIndex];
        double[] theoretWLs = this.auxdata.getTheoreticalWavelengths();
        double[] theoretE0s = this.auxdata.getTheoreticalSunSpectralFluxes();
        double r0 = originalValue / detectorE0s[bandIndex];
        double rc = r0 * theoretE0s[bandIndex];
        if (shouldCorrect[bandIndex]) {
            int lowerIndex = lowerIndexes[bandIndex];
            int upperIndex = upperIndexes[bandIndex];
            double r1 = radianceSamples[lowerIndex] / detectorE0s[lowerIndex];
            double r2 = radianceSamples[upperIndex] / detectorE0s[upperIndex];
            double dl = (theoretWLs[bandIndex] - detectorWLs[bandIndex]) / (detectorWLs[upperIndex] - detectorWLs[lowerIndex]);
            double dr = (r2 - r1) * dl * theoretE0s[bandIndex];
            rc += dr;
        }
        return rc;
    }
}

