/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.radiometry.calibration;

import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.esa.s3tbx.meris.radiometry.calibration.Resolution;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.envisat.Field;
import org.esa.snap.dataio.envisat.MerisRacProductFile;
import org.esa.snap.dataio.envisat.ProductFile;
import org.esa.snap.dataio.envisat.Record;
import org.esa.snap.dataio.envisat.RecordReader;

public class CalibrationAlgorithm {
    private static final int B = 15;
    private final Resolution resolution;
    private final double cntJD;
    private final double[][] oldGains;
    private final double[][] newGains;

    public CalibrationAlgorithm(Resolution resolution, double cntJD, InputStream sourceRacStream, InputStream targetRacStream) throws IOException {
        this.resolution = resolution;
        this.cntJD = cntJD;
        this.oldGains = new double[15][resolution.getPixelCount()];
        this.newGains = new double[15][resolution.getPixelCount()];
        this.initGains(new MemoryCacheImageInputStream(sourceRacStream), this.oldGains);
        this.initGains(new MemoryCacheImageInputStream(targetRacStream), this.newGains);
    }

    public double calibrate(int bandIndex, int detectorIndex, double radiance) {
        return this.newGains[bandIndex][detectorIndex] / this.oldGains[bandIndex][detectorIndex] * radiance;
    }

    private void initGains(ImageInputStream inputStream, double[][] gains) throws IOException {
        double[][] betas = new double[15][this.resolution.getPixelCount()];
        double[][] gammas = new double[15][this.resolution.getPixelCount()];
        double[][] deltas = new double[15][this.resolution.getPixelCount()];
        double[] refJDs = new double[15];
        try (MerisRacProductFile productFile = null;){
            productFile = new MerisRacProductFile(inputStream);
            this.read((ProductFile)productFile, "Gain", "gain", gains);
            this.read((ProductFile)productFile, "Degradation", "beta", betas);
            this.read((ProductFile)productFile, "Degradation", "gamma", gammas);
            this.read((ProductFile)productFile, "Degradation", "delta", deltas);
            this.readJD((ProductFile)productFile, "Degradation", "dsr_time", refJDs);
        }
        for (int b = 0; b < 15; ++b) {
            this.degradeGains(gains[b], betas[b], gammas[b], deltas[b], refJDs[b]);
        }
    }

    private void degradeGains(double[] gains, double[] betas, double[] gammas, double[] deltas, double refJD) {
        for (int i = 0; i < this.resolution.getPixelCount(); ++i) {
            int n = i;
            gains[n] = gains[n] / (1.0 - betas[i] * (1.0 - gammas[i] * Math.exp(deltas[i] * (refJD - this.cntJD))));
        }
    }

    private void read(ProductFile file, String datasetName, String fieldName, double[][] fieldData) throws IOException {
        RecordReader recordReader = file.getRecordReader(datasetName + "_" + this.resolution.name());
        for (int b = 0; b < 15; ++b) {
            Record record = recordReader.readRecord(b);
            ProductData productData = record.getField(fieldName).getData();
            for (int i = 0; i < this.resolution.getPixelCount(); ++i) {
                fieldData[b][i] = productData.getElemDoubleAt(i);
            }
        }
    }

    private void readJD(ProductFile file, String datasetName, String fieldName, double[] refJDs) throws IOException {
        RecordReader recordReader = file.getRecordReader(datasetName + "_" + this.resolution.name());
        for (int b = 0; b < 15; ++b) {
            Record record = recordReader.readRecord(b);
            Field field = record.getField(fieldName);
            int days = field.getElemInt(0);
            int seconds = field.getElemInt(1);
            int microseconds = field.getElemInt(2);
            refJDs[b] = microseconds / 1000000 + seconds / 86400 + days;
        }
    }
}

