/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris;

import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.util.ProductUtils;

public abstract class MerisBasisOp
extends Operator {
    @Parameter(description="If set to 'false' only the lat and lon tie-points will be copied to the target product", defaultValue="false")
    private boolean copyAllTiePoints = false;

    public Product createCompatibleProduct(Product sourceProduct, String name, String type) {
        int sceneWidth = sourceProduct.getSceneRasterWidth();
        int sceneHeight = sourceProduct.getSceneRasterHeight();
        Product targetProduct = new Product(name, type, sceneWidth, sceneHeight);
        this.copyProductTrunk(sourceProduct, targetProduct);
        return targetProduct;
    }

    public void copyProductTrunk(Product sourceProduct, Product targetProduct) {
        this.copyTiePoints(sourceProduct, targetProduct);
        this.copyBaseGeoInfo(sourceProduct, targetProduct);
    }

    private void copyTiePoints(Product sourceProduct, Product targetProduct) {
        if (this.copyAllTiePoints) {
            ProductUtils.copyTiePointGrids((Product)sourceProduct, (Product)targetProduct);
        } else {
            for (int i = 0; i < sourceProduct.getNumTiePointGrids(); ++i) {
                TiePointGrid srcTPG = sourceProduct.getTiePointGridAt(i);
                if (!srcTPG.getName().equals("latitude") && !srcTPG.getName().equals("longitude")) continue;
                targetProduct.addTiePointGrid(srcTPG.cloneTiePointGrid());
            }
        }
    }

    private void copyBaseGeoInfo(Product sourceProduct, Product targetProduct) {
        ProductUtils.copyGeoCoding((Product)sourceProduct, (Product)targetProduct);
        targetProduct.setStartTime(sourceProduct.getStartTime());
        targetProduct.setEndTime(sourceProduct.getEndTime());
    }
}

