/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import org.esa.s3tbx.meris.MerisBasisOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.FlagCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;

@OperatorMetadata(alias="L3ToL1", internal=true)
public class L3ToL1Op
extends MerisBasisOp {
    private GeoCoding l3GeoCoding;
    private GeoCoding l1GeoCoding;
    @SourceProduct(alias="l1")
    private Product l1Product;
    @SourceProduct(alias="l3")
    private Product l3Product;
    @SourceProduct(alias="mask", optional=true)
    private Product maskProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter
    private String maskBand;

    public void initialize() throws OperatorException {
        Band[] l3Bands;
        this.l3GeoCoding = this.l3Product.getSceneGeoCoding();
        this.l1GeoCoding = this.l1Product.getSceneGeoCoding();
        this.targetProduct = this.createCompatibleProduct(this.l1Product, "l3tol1", "L3");
        for (Band sourceBand : l3Bands = this.l3Product.getBands()) {
            Band targetBand = this.targetProduct.addBand(sourceBand.getName(), sourceBand.getDataType());
            ProductUtils.copySpectralBandProperties((Band)sourceBand, (Band)targetBand);
            targetBand.setDescription(sourceBand.getDescription());
            targetBand.setUnit(sourceBand.getUnit());
            targetBand.setScalingFactor(sourceBand.getScalingFactor());
            targetBand.setScalingOffset(sourceBand.getScalingOffset());
            targetBand.setLog10Scaled(sourceBand.isLog10Scaled());
            targetBand.setNoDataValueUsed(sourceBand.isNoDataValueUsed());
            targetBand.setNoDataValue(sourceBand.getNoDataValue());
            if (sourceBand.getFlagCoding() == null) continue;
            FlagCoding srcFlagCoding = sourceBand.getFlagCoding();
            ProductUtils.copyFlagCoding((FlagCoding)srcFlagCoding, (Product)this.targetProduct);
            targetBand.setSampleCoding((SampleCoding)this.targetProduct.getFlagCodingGroup().get(srcFlagCoding.getName()));
        }
    }

    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle rectangle = targetTile.getRectangle();
        Band srcBand = this.l3Product.getBand(band.getName());
        PixelPos l1PixelPos = new PixelPos();
        PixelPos l3PixelPos = new PixelPos();
        GeoPos geoPos = new GeoPos();
        Rectangle l3Rect = this.findL3Rectangle(rectangle, srcBand);
        Tile srcTile = this.getSourceTile((RasterDataNode)srcBand, l3Rect);
        Tile maskTile = null;
        boolean useMask = false;
        if (this.maskProduct != null && StringUtils.isNotNullAndNotEmpty((String)this.maskBand)) {
            maskTile = this.getSourceTile((RasterDataNode)this.maskProduct.getBand(this.maskBand), rectangle);
            useMask = true;
        }
        Resampling resampling = Resampling.BILINEAR_INTERPOLATION;
        Resampling.Index resamplingIndex = resampling.createIndex();
        TileBasedResamplingRaster resamplingRaster = new TileBasedResamplingRaster(srcTile);
        pm.beginTask("compute", rectangle.height);
        try {
            for (int y = rectangle.y; y < rectangle.y + rectangle.height; ++y) {
                l1PixelPos.y = y;
                for (int x = rectangle.x; x < rectangle.x + rectangle.width; ++x) {
                    if (useMask && !maskTile.getSampleBoolean(x, y)) continue;
                    l1PixelPos.x = x;
                    this.l1GeoCoding.getGeoPos(l1PixelPos, geoPos);
                    this.l3GeoCoding.getPixelPos(geoPos, l3PixelPos);
                    resampling.computeIndex(l3PixelPos.x, l3PixelPos.y, this.l3Product.getSceneRasterWidth(), this.l3Product.getSceneRasterHeight(), resamplingIndex);
                    double sample = resampling.resample((Resampling.Raster)resamplingRaster, resamplingIndex);
                    targetTile.setSample(x, y, sample);
                }
                this.checkForCancellation();
                pm.worked(1);
            }
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private Rectangle findL3Rectangle(Rectangle l1Rectangle, Band srcBand) {
        PixelPos bottomLeft = new PixelPos((double)l1Rectangle.x, (double)l1Rectangle.y);
        PixelPos l3PixelPos = this.l3GeoCoding.getPixelPos(this.l1GeoCoding.getGeoPos(bottomLeft, null), null);
        Rectangle l3Rectangle = new Rectangle((int)Math.round(l3PixelPos.x), (int)Math.round(l3PixelPos.y), 1, 1);
        PixelPos bottomRight = new PixelPos((double)(l1Rectangle.x + l1Rectangle.width), (double)l1Rectangle.y);
        l3PixelPos = this.l3GeoCoding.getPixelPos(this.l1GeoCoding.getGeoPos(bottomRight, null), l3PixelPos);
        l3Rectangle.add(l3PixelPos.x, l3PixelPos.y);
        PixelPos topRight = new PixelPos((double)(l1Rectangle.x + l1Rectangle.width), (double)(l1Rectangle.y + l1Rectangle.height));
        l3PixelPos = this.l3GeoCoding.getPixelPos(this.l1GeoCoding.getGeoPos(topRight, null), l3PixelPos);
        l3Rectangle.add(l3PixelPos.x, l3PixelPos.y);
        PixelPos topLeft = new PixelPos((double)l1Rectangle.x, (double)(l1Rectangle.y + l1Rectangle.height));
        l3PixelPos = this.l3GeoCoding.getPixelPos(this.l1GeoCoding.getGeoPos(topLeft, null), l3PixelPos);
        l3Rectangle.add(l3PixelPos.x, l3PixelPos.y);
        l3Rectangle.grow(2, 2);
        Rectangle sceneRectangle = new Rectangle(srcBand.getRasterWidth(), srcBand.getRasterHeight());
        return l3Rectangle.intersection(sceneRectangle);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(L3ToL1Op.class);
        }
    }

    private static class TileBasedResamplingRaster
    implements Resampling.Raster {
        private final Tile tile;

        public TileBasedResamplingRaster(Tile tile) {
            this.tile = tile;
        }

        public final int getWidth() {
            return this.tile.getWidth();
        }

        public final int getHeight() {
            return this.tile.getHeight();
        }

        public boolean getSamples(int[] x, int[] y, double[][] samples) {
            for (int i = 0; i < y.length; ++i) {
                for (int j = 0; j < x.length; ++j) {
                    samples[i][j] = this.tile.getSampleDouble(x[j], y[i]);
                }
            }
            return true;
        }
    }
}

