/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.util.math;

import java.lang.reflect.Array;

public final class MDArray {
    private final Layout _layout;
    private final Object _javaArray;
    private static final ArrayCopy SYSTEM_FAC = new ArrayCopy(){

        @Override
        public void copyArray(Object src, int srcPos, Object dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    };
    private static final ArrayCopy FLOAT_TO_DOUBLE_FAC = new ArrayCopy(){

        @Override
        public void copyArray(Object src, int srcPos, Object dest, int destPos, int length) {
            float[] fSrc = (float[])src;
            double[] dDest = (double[])dest;
            for (int i = 0; i < length; ++i) {
                dDest[destPos + i] = fSrc[srcPos + i];
            }
        }
    };
    private static final ArrayCopy DOUBLE_TO_FLOAT_FAC = new ArrayCopy(){

        @Override
        public void copyArray(Object src, int srcPos, Object dest, int destPos, int length) {
            double[] dSrc = (double[])src;
            float[] fDest = (float[])dest;
            for (int i = 0; i < length; ++i) {
                fDest[destPos + i] = (float)dSrc[srcPos + i];
            }
        }
    };

    public MDArray(MDArray mdArray) {
        this(mdArray.getLayout(), mdArray.getJavaArray());
    }

    public MDArray(Object javaArray) {
        this(MDArray.createLayout(javaArray), javaArray);
    }

    public MDArray(Class elementType, int[] dimSizes) {
        this(new Layout(elementType, dimSizes), Array.newInstance(elementType, dimSizes));
    }

    public MDArray(Class elementType, int[] dimSizes, Object flatArray) {
        this(elementType, dimSizes);
        this.fillFromFlatArray(flatArray);
    }

    private MDArray(Layout layout, Object javaArray) {
        this._layout = layout;
        this._javaArray = javaArray;
    }

    public static Layout createLayout(Object array) {
        Class<?> at = array.getClass();
        if (!at.isArray()) {
            throw new IllegalArgumentException("'array' is not an array");
        }
        int rank = 0;
        while (at.isArray()) {
            at = at.getComponentType();
            ++rank;
        }
        Class<?> elementType = at;
        int[] dimSizes = new int[rank];
        Object a = array;
        for (int i = 0; i < rank; ++i) {
            dimSizes[i] = Array.getLength(a);
            if (dimSizes[i] == 0) {
                throw new IllegalArgumentException("array is not regular");
            }
            a = Array.get(a, 0);
        }
        return new Layout(elementType, dimSizes);
    }

    public Layout getLayout() {
        return this._layout;
    }

    public int getRank() {
        return this._layout.getRank();
    }

    public int getDimSize(int dimIndex) {
        return this._layout.getDimSize(dimIndex);
    }

    public Object getJavaArray() {
        return this._javaArray;
    }

    public static long getElementCount(int[] dimSizes) {
        long size = dimSizes[0];
        for (int i = 1; i < dimSizes.length; ++i) {
            size *= (long)dimSizes[i];
        }
        return size;
    }

    public void fillFromFlatArray(Object flatArray) {
        MDArray.copyFlatIntoDeep(flatArray, this.getJavaArray(), this.getLayout(), null);
    }

    public static void copyFlatIntoDeep(Object flatArray, Object deepArray) {
        MDArray.copyFlatIntoDeep(flatArray, deepArray, null, null);
    }

    private static void copyFlatIntoDeep(Object flatArray, Object deepArray, Layout deepArrayLayout, ArrayCopy arrayCopy) {
        if (!flatArray.getClass().isArray()) {
            throw new IllegalArgumentException("flatArray is not an array");
        }
        if (deepArrayLayout == null) {
            deepArrayLayout = MDArray.createLayout(deepArray);
        }
        if (arrayCopy == null) {
            arrayCopy = MDArray.getArrayCopy(flatArray.getClass().getComponentType(), deepArrayLayout.getElementType());
        }
        MDArray.copyFlatIntoDeepRecursive(flatArray, new int[1], deepArray, deepArrayLayout.getDimSizes(), 0, arrayCopy);
    }

    private static void copyFlatIntoDeepRecursive(Object flatArray, int[] offset, Object deepArray, int[] dimSizes, int dimIndex, ArrayCopy arrayCopy) {
        int rank = dimSizes.length;
        int size = dimSizes[dimIndex];
        if (dimIndex == rank - 1) {
            arrayCopy.copyArray(flatArray, offset[0], deepArray, 0, size);
            offset[0] = offset[0] + size;
        } else if (dimIndex < rank - 1) {
            Object[] array = (Object[])deepArray;
            for (int i = 0; i < size; ++i) {
                MDArray.copyFlatIntoDeepRecursive(flatArray, offset, array[i], dimSizes, dimIndex + 1, arrayCopy);
            }
        } else {
            throw new IllegalArgumentException("dim >= rank");
        }
    }

    private static ArrayCopy getArrayCopy(Class srcType, Class destType) {
        ArrayCopy arrayCopy = SYSTEM_FAC;
        if (srcType.equals(Float.TYPE)) {
            if (destType.equals(Double.TYPE)) {
                arrayCopy = FLOAT_TO_DOUBLE_FAC;
            }
        } else if (srcType.equals(Double.TYPE) && destType.equals(Float.TYPE)) {
            arrayCopy = DOUBLE_TO_FLOAT_FAC;
        }
        return arrayCopy;
    }

    public static interface ArrayCopy {
        public void copyArray(Object var1, int var2, Object var3, int var4, int var5);
    }

    public static class Layout {
        private final Class _elementType;
        private final int[] _dimSizes;

        public Layout(Class elementType, int[] dimSizes) {
            long elementCount = MDArray.getElementCount(dimSizes);
            if (elementCount < 0L) {
                throw new IllegalArgumentException("invalid dimSizes: elementCount < 0");
            }
            if (elementCount > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("invalid dimSizes: elementCount > 2147483647");
            }
            this._elementType = elementType;
            this._dimSizes = dimSizes;
        }

        public Class getElementType() {
            return this._elementType;
        }

        public int getRank() {
            return this._dimSizes.length;
        }

        public int[] getDimSizes() {
            return this._dimSizes;
        }

        public int getDimSize(int dimIndex) {
            return this._dimSizes[dimIndex];
        }
    }
}

