/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.util.math;

import org.esa.s3tbx.util.math.MDArray;

public class LUT {
    private final MDArray _array;
    private final double[][] _tabs;

    public LUT(Object javaArray) {
        this(new MDArray(javaArray));
    }

    public LUT(MDArray array) {
        this._array = array;
        this._tabs = new double[this._array.getRank()][];
    }

    public LUT(int[] sizes, double[] elements) {
        this(new MDArray(Double.TYPE, sizes, elements));
    }

    public LUT(int[] sizes, float[] elements) {
        this(new MDArray(Float.TYPE, sizes, elements));
    }

    public MDArray getArray() {
        return this._array;
    }

    public Object getJavaArray() {
        return this._array.getJavaArray();
    }

    public int getDimSize(int dim) {
        return this._array.getDimSize(dim);
    }

    public double[] getTab(int dim) {
        return this._tabs[dim];
    }

    public void setTab(int dim, double[] tab) {
        if (tab != null && this.getDimSize(dim) != tab.length) {
            throw new IllegalArgumentException("illegal tab.length = " + tab.length + ", expected " + this.getDimSize(dim));
        }
        this._tabs[dim] = tab;
    }
}

