/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.util.math;

import org.esa.s3tbx.util.math.FractIndex;

public class Interp {
    public static int interpCoord(double x, double[] xi, FractIndex i) {
        int n = xi.length;
        boolean ascending = xi[n - 1] >= xi[0];
        i.fraction = 0.0;
        int status = 0;
        if (ascending && x >= xi[n - 1]) {
            i.index = n - 1;
            if (x > xi[n - 1]) {
                status = 1;
            }
        } else if (ascending && x <= xi[0]) {
            i.index = 0;
            if (x < xi[0]) {
                status = 2;
            }
        } else if (!ascending && x >= xi[0]) {
            i.index = 0;
            if (x > xi[0]) {
                status = 3;
            }
        } else if (!ascending && x <= xi[n - 1]) {
            i.index = n - 1;
            if (x < xi[n - 1]) {
                status = 4;
            }
        } else {
            int il = -1;
            int iu = n;
            while (iu - il > 1) {
                int im = iu + il >> 1;
                if (x >= xi[im] == ascending) {
                    il = im;
                    continue;
                }
                iu = im;
            }
            if (il == -1) {
                i.index = 0;
                status = 5;
            } else if (il == n) {
                i.index = n - 1;
                status = 6;
            } else if (ascending && x == xi[il]) {
                i.index = il;
            } else if (!ascending && x == xi[il + 1]) {
                i.index = il + 1;
            } else {
                i.index = il;
                i.fraction = (x - xi[il]) / (xi[il + 1] - xi[il]);
            }
        }
        return status;
    }

    public static double interpolate(Object elements, FractIndex[] indexes) {
        return Interp.interpolate(elements, indexes, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double interpolate(Object elements, FractIndex[] indexes, int dim) {
        double y2;
        double y1;
        int rank = indexes.length;
        int index = indexes[dim].index;
        double fraction = indexes[dim].fraction;
        if (fraction < 0.0 || fraction >= 1.0) {
            throw new IllegalArgumentException("fraction < 0.0 || fraction >= 1.0, fraction=" + fraction);
        }
        if (dim == rank - 1) {
            if (elements instanceof float[]) {
                float[] array = (float[])elements;
                y1 = array[index];
                y2 = index < array.length - 1 ? (double)array[index + 1] : y1;
                return y1 + fraction * (y2 - y1);
            } else {
                if (!(elements instanceof double[])) throw new IllegalArgumentException("illegal array type, float[] or double[] expected");
                double[] array = (double[])elements;
                y1 = array[index];
                y2 = index < array.length - 1 ? array[index + 1] : y1;
            }
            return y1 + fraction * (y2 - y1);
        } else {
            if (dim < 0 || dim >= rank - 1) throw new IndexOutOfBoundsException("dim < 0 || dim >= rank, dim=" + index + ", rank=" + rank);
            Object[] array = (Object[])elements;
            y1 = Interp.interpolate(array[index], indexes, dim + 1);
            y2 = index < array.length - 1 ? Interp.interpolate(array[index + 1], indexes, dim + 1) : y1;
        }
        return y1 + fraction * (y2 - y1);
    }
}

