/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.l2auxdata;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.esa.s3tbx.meris.l2auxdata.L2AuxDataException;
import org.esa.snap.core.datamodel.Product;

public class Utils {
    private Utils() {
    }

    public static double computeSeasonalFactor(double daysSince2000, double sunEarthDistanceSquare) {
        double a = 1.4959787E11;
        double e = 0.017;
        double daysToPerihelionIn2000 = 3.2083333333333335;
        double daysOfYear = 365.25;
        double theta = Math.PI * 2 * ((daysSince2000 - 3.2083333333333335) / 365.25);
        double r = 1.4955463621557E11 / (1.0 + 0.017 * Math.cos(theta));
        return r * r / sunEarthDistanceSquare;
    }

    public static boolean isProductRR(Product product) {
        return product.getProductType().indexOf("_RR") > 0;
    }

    public static boolean isProductFR(Product product) {
        return product.getProductType().indexOf("_FR") > 0 || product.getProductType().indexOf("_FS") > 0;
    }

    static void downloadAndInstallAuxdata(Path targetDir, URL remoteZipFileUrl) throws L2AuxDataException {
        try {
            ZipEntry entry;
            URL fileUrl = remoteZipFileUrl;
            URLConnection urlConnection = System.getProperty("http.proxyHost") == null || System.getProperty("http.proxyPort") == null ? fileUrl.openConnection() : fileUrl.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort")))));
            InputStream inputStream = urlConnection.getInputStream();
            ZipInputStream zis = new ZipInputStream(inputStream);
            while ((entry = zis.getNextEntry()) != null) {
                Path filepath = targetDir.resolve(entry.getName());
                if (!entry.isDirectory()) {
                    Files.copy(zis, filepath, new CopyOption[0]);
                    continue;
                }
                Files.createDirectories(filepath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new L2AuxDataException("Not able to download auxiliary data from " + remoteZipFileUrl, e);
        }
    }
}

