/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.l2auxdata;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.esa.s3tbx.meris.l2auxdata.DpmConfig;
import org.esa.s3tbx.meris.l2auxdata.L2AuxData;
import org.esa.s3tbx.meris.l2auxdata.L2AuxDataException;
import org.esa.snap.core.datamodel.Product;

public class L2AuxDataProvider {
    private static L2AuxDataProvider instance;
    private DpmConfig dpmConfig;
    private final Map<Product, L2AuxData> map = new WeakHashMap<Product, L2AuxData>();

    public static synchronized L2AuxDataProvider getInstance() {
        if (instance == null) {
            instance = new L2AuxDataProvider();
        }
        return instance;
    }

    private L2AuxDataProvider() {
    }

    public synchronized L2AuxData getAuxdata(Product product) throws L2AuxDataException {
        this.getDpmConfig();
        L2AuxData auxData = this.map.get(product);
        if (auxData == null) {
            auxData = this.loadAuxdata(product);
            this.map.put(product, auxData);
        }
        return auxData;
    }

    public synchronized DpmConfig getDpmConfig() throws L2AuxDataException {
        if (this.dpmConfig == null) {
            this.loadDpmConfig();
        }
        return this.dpmConfig;
    }

    private L2AuxData loadAuxdata(Product product) throws L2AuxDataException {
        L2AuxData auxData;
        try {
            auxData = new L2AuxData(this.dpmConfig, product);
        }
        catch (IOException e) {
            throw new L2AuxDataException(e.getMessage(), e);
        }
        return auxData;
    }

    private void loadDpmConfig() throws L2AuxDataException {
        this.dpmConfig = new DpmConfig();
    }
}

