/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.l2auxdata;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import org.esa.s3tbx.meris.l2auxdata.AuxFile;
import org.esa.s3tbx.meris.l2auxdata.Constants;
import org.esa.s3tbx.meris.l2auxdata.DpmConfig;
import org.esa.s3tbx.meris.l2auxdata.L2AuxDataException;
import org.esa.s3tbx.meris.l2auxdata.Utils;
import org.esa.s3tbx.util.math.FractIndex;
import org.esa.s3tbx.util.math.Interp;
import org.esa.s3tbx.util.math.LUT;
import org.esa.s3tbx.util.math.MDArray;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.datamodel.TiePointGrid;

public final class L2AuxData
implements Constants {
    public double sun_earth_distance_square;
    public double seasonal_factor;
    public int detector_count;
    public double maxPress;
    public double press_scale_height;
    public double press_confidence;
    public boolean[] land_decision_table;
    public boolean[] water_decision_table;
    public int band_slope_n_1;
    public int band_slope_d_1;
    public int band_slope_n_2;
    public int band_slope_d_2;
    public int band_bright_n;
    public double slope_1_low_thr;
    public double slope_1_high_thr;
    public double slope_2_low_thr;
    public double slope_2_high_thr;
    public double[][] detector_solar_irradiance;
    public double[][] central_wavelength;
    public double[] theoretical_wavelength;
    public double[] Saturation_L;
    public SmileParams land_smile_params;
    public SmileParams water_smile_params;
    public double[] spectral_shift_H2Owavelength;
    public double[][] H2Ocoef;
    public double[][] H2OcoefSpecShift;
    public double[][] O2coef;
    public double[] spectral_shift_wavelength;
    public double[] tauO3_norm;
    public double TETAS_LIM;
    public LUT r7thresh;
    public LUT r13thresh;
    public double[] alpha_thresh;
    public int[] lap_b_thresh;
    public double lap_beta_l;
    public double lap_beta_w;
    public LUT rog;
    public double Pstd;
    public double[] tau_R;
    public double[] AB;
    public double[] Raytrans;
    public LUT Rhorc_442_land_LUT;
    public LUT Rhorc_442_ocean_LUT;
    public LUT Rayscatt_coeff_s;
    public LUT polcoeff;
    public LUT C;
    public LUT DPthresh_land;
    public LUT DPthresh_ocean;
    public LUT Rayalb;
    private Product sourceProduct;

    public L2AuxData(DpmConfig config, Product product) throws L2AuxDataException, IOException {
        this.sourceProduct = product;
        this.loadAuxData(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAuxData(DpmConfig config) throws L2AuxDataException, IOException {
        AuxFile auxFileO = AuxFile.open('O', config.getAuxDatabaseFile("lv2conf", null));
        AuxFile auxFileP = AuxFile.open('P', config.getAuxDatabaseFile("atmosphere", null));
        AuxFile auxFileS = AuxFile.open('S', config.getAuxDatabaseFile("landaero", null));
        AuxFile auxFileT = AuxFile.open('T', config.getAuxDatabaseFile("case1", null));
        try {
            this.loadConfigurationAuxData(auxFileO);
            this.loadAtmosphereAuxData(auxFileP);
            this.loadLandAerosolAuxData(auxFileS, auxFileT);
            this.loadRayscattCoeffAuxData(auxFileP, auxFileS);
        }
        finally {
            auxFileO.close();
            auxFileP.close();
            auxFileS.close();
            auxFileT.close();
        }
    }

    private void loadConfigurationAuxData(AuxFile auxFileO) throws IOException, L2AuxDataException {
        int i;
        String detector_solar_irradiance_key;
        String central_wavelength_key;
        this.Saturation_L = auxFileO.readDoubleArray("O202", 15);
        this.sun_earth_distance_square = auxFileO.readDouble("O300");
        this.seasonal_factor = 1.0;
        ProductData.UTC startTime = this.sourceProduct.getStartTime();
        ProductData.UTC stopTime = this.sourceProduct.getEndTime();
        if (startTime != null && stopTime != null) {
            double daysSince2000 = 0.5 * (startTime.getMJD() + stopTime.getMJD());
            this.seasonal_factor = Utils.computeSeasonalFactor(daysSince2000, this.sun_earth_distance_square);
        }
        byte[] sw_land_smile = auxFileO.readRecord("O301", 41).getElemString().getBytes();
        byte[] sw_water_smile = auxFileO.readRecord("O302", 41).getElemString().getBytes();
        byte[] derivative_land_smile = auxFileO.readRecord("O303", 41).getElemString().getBytes();
        byte[] derivative_water_smile = auxFileO.readRecord("O304", 41).getElemString().getBytes();
        this.theoretical_wavelength = auxFileO.readDoubleArray("O305", 15);
        this.land_smile_params = new SmileParams();
        this.water_smile_params = new SmileParams();
        for (int i2 = 0; i2 < 15; ++i2) {
            this.land_smile_params.enabled[i2] = sw_land_smile[i2] != 0;
            this.land_smile_params.derivative_band_id[i2][0] = derivative_land_smile[2 * i2 + 0] - 1;
            this.land_smile_params.derivative_band_id[i2][1] = derivative_land_smile[2 * i2 + 1] - 1;
            this.water_smile_params.enabled[i2] = sw_water_smile[i2] != 0;
            this.water_smile_params.derivative_band_id[i2][0] = derivative_water_smile[2 * i2 + 0] - 1;
            this.water_smile_params.derivative_band_id[i2][1] = derivative_water_smile[2 * i2 + 1] - 1;
        }
        if (Utils.isProductRR(this.sourceProduct)) {
            this.detector_count = 925;
            central_wavelength_key = "O307";
            detector_solar_irradiance_key = "O308";
        } else if (Utils.isProductFR(this.sourceProduct)) {
            this.detector_count = 3700;
            central_wavelength_key = "O309";
            detector_solar_irradiance_key = "O30A";
        } else {
            throw new L2AuxDataException("Input product is neither MERIS RR nor FR");
        }
        int num_elems = 15 * this.detector_count;
        float[] central_wavelength_data = auxFileO.readFloatArray(central_wavelength_key, num_elems);
        this.central_wavelength = new double[15][this.detector_count];
        MDArray.copyFlatIntoDeep(central_wavelength_data, this.central_wavelength);
        float[] detector_solar_irradiance_data = auxFileO.readFloatArray(detector_solar_irradiance_key, num_elems);
        this.detector_solar_irradiance = new double[15][this.detector_count];
        MDArray.copyFlatIntoDeep(detector_solar_irradiance_data, this.detector_solar_irradiance);
        this.TETAS_LIM = auxFileO.readFloat("O40G");
        this.press_confidence = auxFileO.readFloat("O500");
        this.band_slope_n_1 = auxFileO.readInt("O501");
        this.band_slope_d_1 = auxFileO.readInt("O502");
        this.slope_1_low_thr = auxFileO.readFloat("O503");
        this.slope_1_high_thr = auxFileO.readFloat("O504");
        this.band_slope_n_2 = auxFileO.readInt("O505");
        this.band_slope_d_2 = auxFileO.readInt("O506");
        this.slope_2_low_thr = auxFileO.readFloat("O507");
        this.slope_2_high_thr = auxFileO.readFloat("O508");
        int[] ibuf = auxFileO.readUIntArray("O509", 256);
        this.water_decision_table = new boolean[256];
        for (i = 0; i < ibuf.length; ++i) {
            this.water_decision_table[i] = ibuf[i] != 0;
        }
        ibuf = auxFileO.readUIntArray("O50A", 256);
        this.land_decision_table = new boolean[256];
        for (i = 0; i < ibuf.length; ++i) {
            this.land_decision_table[i] = ibuf[i] != 0;
        }
        this.band_bright_n = auxFileO.readInt("O50B");
        --this.band_slope_n_1;
        --this.band_slope_d_1;
        --this.band_slope_n_2;
        --this.band_slope_d_2;
        --this.band_bright_n;
        double[] q_tabulated_values = auxFileO.readDoubleArray("O50C", 12);
        double[] Df_tabulated_values = auxFileO.readDoubleArray("O50E", 19);
        ProductData pdata = null;
        int elementCount = 1482;
        pdata = auxFileO.readRecord("O600", 0, 1482, 30, null);
        float[] fBuf = (float[])pdata.getElems();
        int z = 0;
        float[][][] Rhorc_442_land_LUT_data = new float[12][12][19];
        for (int its = 0; its < 12; ++its) {
            for (int itv = its; itv < 12; ++itv) {
                for (int idf = 0; idf < 19; ++idf) {
                    Rhorc_442_land_LUT_data[its][itv][idf] = fBuf[z];
                    if (its != itv) {
                        Rhorc_442_land_LUT_data[itv][its][idf] = fBuf[z];
                    }
                    ++z;
                }
            }
        }
        assert (z == 1482);
        this.Rhorc_442_land_LUT = new LUT(Rhorc_442_land_LUT_data);
        this.Rhorc_442_land_LUT.setTab(0, q_tabulated_values);
        this.Rhorc_442_land_LUT.setTab(1, q_tabulated_values);
        this.Rhorc_442_land_LUT.setTab(2, Df_tabulated_values);
        pdata = auxFileO.readRecord("O600", 1, 1482, 30, pdata);
        fBuf = (float[])pdata.getElems();
        z = 0;
        float[][][] Rhorc_442_ocean_LUT_data = new float[12][12][19];
        for (int its = 0; its < 12; ++its) {
            for (int itv = its; itv < 12; ++itv) {
                for (int idf = 0; idf < 19; ++idf) {
                    Rhorc_442_ocean_LUT_data[its][itv][idf] = fBuf[z];
                    if (its != itv) {
                        Rhorc_442_ocean_LUT_data[itv][its][idf] = fBuf[z];
                    }
                    ++z;
                }
            }
        }
        assert (z == 1482);
        this.Rhorc_442_ocean_LUT = new LUT(Rhorc_442_ocean_LUT_data);
        this.Rhorc_442_ocean_LUT.setTab(0, q_tabulated_values);
        this.Rhorc_442_ocean_LUT.setTab(1, q_tabulated_values);
        this.Rhorc_442_ocean_LUT.setTab(2, Df_tabulated_values);
    }

    private void loadAtmosphereAuxData(AuxFile auxFileP) throws IOException {
        this.Raytrans = auxFileP.readDoubleArray("P200", 3);
        double[] rayalbTab = auxFileP.readDoubleArray("P201", 17);
        double[] theta_scale = auxFileP.readDoubleArray("P206", 12);
        this.AB = auxFileP.readDoubleArray("P208", 2);
        double[] air_mass_tab = auxFileP.readDoubleArray("P209", 6);
        double[] rho_TOA_tab = auxFileP.readDoubleArray("P20B", 6);
        this.Pstd = auxFileP.readFloat("P20I");
        this.maxPress = auxFileP.readFloat("P20K");
        this.spectral_shift_wavelength = auxFileP.readDoubleArray("P20P", 21);
        this.spectral_shift_H2Owavelength = auxFileP.readDoubleArray("P20Q", 21);
        this.press_scale_height = auxFileP.readFloat("P20R");
        this.tauO3_norm = auxFileP.readDoubleArray("P304", 15);
        this.tau_R = auxFileP.readDoubleArray("P303", 15);
        double[] O2coef_buf = auxFileP.readDoubleArray("P400", 84);
        this.O2coef = new double[21][4];
        MDArray.copyFlatIntoDeep(O2coef_buf, this.O2coef);
        double[] H2OcoefSpecShift_buf = auxFileP.readDoubleArray("P401", 84);
        this.H2OcoefSpecShift = new double[21][4];
        MDArray.copyFlatIntoDeep(H2OcoefSpecShift_buf, this.H2OcoefSpecShift);
        double[] H2Ocoef_buf = auxFileP.readDoubleArray("P402", 60);
        this.H2Ocoef = new double[15][4];
        MDArray.copyFlatIntoDeep(H2Ocoef_buf, this.H2Ocoef);
        double[] rayalbLUT = auxFileP.readDoubleArray("P600", 17);
        this.Rayalb = new LUT(rayalbLUT);
        this.Rayalb.setTab(0, rayalbTab);
        float[] DPthresh_land_array = auxFileP.readFloatArray("P700", -1);
        int DPthresh_land_array_index = 0;
        float[][] DPthresh_land_data = new float[12][12];
        for (int its = 0; its < 12; ++its) {
            for (int itv = its; itv < 12; ++itv) {
                DPthresh_land_data[its][itv] = DPthresh_land_array[DPthresh_land_array_index];
                if (itv != its) {
                    DPthresh_land_data[itv][its] = DPthresh_land_array[DPthresh_land_array_index];
                }
                ++DPthresh_land_array_index;
            }
        }
        this.DPthresh_land = new LUT(DPthresh_land_data);
        this.DPthresh_land.setTab(0, theta_scale);
        this.DPthresh_land.setTab(1, theta_scale);
        float[] DPthresh_ocean_array = auxFileP.readFloatArray("P701", -1);
        int DPthresh_ocean_array_index = 0;
        float[][] DPthresh_ocean_data = new float[12][12];
        for (int its = 0; its < 12; ++its) {
            for (int itv = its; itv < 12; ++itv) {
                DPthresh_ocean_data[its][itv] = DPthresh_ocean_array[DPthresh_ocean_array_index];
                if (itv != its) {
                    DPthresh_ocean_data[itv][its] = DPthresh_ocean_array[DPthresh_ocean_array_index];
                }
                ++DPthresh_ocean_array_index;
            }
        }
        this.DPthresh_ocean = new LUT(DPthresh_ocean_data);
        this.DPthresh_ocean.setTab(0, theta_scale);
        this.DPthresh_ocean.setTab(1, theta_scale);
        int[] polcoeff_sizes = new int[]{21, 12};
        float[] polcoeff_array = auxFileP.readFloatArray("P800", 252);
        double[] polcoeff_shift_tab = new double[21];
        for (int i = 0; i < polcoeff_shift_tab.length; ++i) {
            polcoeff_shift_tab[i] = i;
        }
        this.polcoeff = new LUT(polcoeff_sizes, polcoeff_array);
        this.polcoeff.setTab(0, polcoeff_shift_tab);
        this.polcoeff.setTab(1, null);
        int[] C_sizes = new int[]{19, 6, 6};
        float[] C_array = auxFileP.readFloatArray("P802", 684);
        this.C = new LUT(C_sizes, C_array);
        this.C.setTab(0, null);
        this.C.setTab(1, air_mass_tab);
        this.C.setTab(2, rho_TOA_tab);
    }

    private void loadRayscattCoeffAuxData(AuxFile auxFileP, AuxFile auxFileS) throws IOException {
        int k;
        int itv;
        int its;
        float[][][][] Rayscatt_coeff_s_data = new float[4][3][12][12];
        float[] Rayscatt_coeff_s_array = auxFileP.readFloatArray("P500", -1);
        int Rayscatt_coeff_s_array_index = 0;
        for (its = 0; its < 12; ++its) {
            for (itv = its; itv < 12; ++itv) {
                for (k = 0; k < 4; ++k) {
                    Rayscatt_coeff_s_data[k][0][its][itv] = Rayscatt_coeff_s_array[Rayscatt_coeff_s_array_index];
                    if (its != itv) {
                        Rayscatt_coeff_s_data[k][0][itv][its] = Rayscatt_coeff_s_array[Rayscatt_coeff_s_array_index];
                    }
                    ++Rayscatt_coeff_s_array_index;
                }
            }
        }
        Rayscatt_coeff_s_array = auxFileP.readFloatArray("P501", -1);
        Rayscatt_coeff_s_array_index = 0;
        for (its = 0; its < 12; ++its) {
            for (itv = its; itv < 12; ++itv) {
                for (k = 0; k < 4; ++k) {
                    Rayscatt_coeff_s_data[k][1][its][itv] = Rayscatt_coeff_s_array[Rayscatt_coeff_s_array_index];
                    if (its != itv) {
                        Rayscatt_coeff_s_data[k][1][itv][its] = Rayscatt_coeff_s_array[Rayscatt_coeff_s_array_index];
                    }
                    ++Rayscatt_coeff_s_array_index;
                }
            }
        }
        Rayscatt_coeff_s_array = auxFileP.readFloatArray("P502", -1);
        Rayscatt_coeff_s_array_index = 0;
        for (its = 0; its < 12; ++its) {
            for (itv = its; itv < 12; ++itv) {
                for (k = 0; k < 4; ++k) {
                    Rayscatt_coeff_s_data[k][2][its][itv] = Rayscatt_coeff_s_array[Rayscatt_coeff_s_array_index];
                    if (its != itv) {
                        Rayscatt_coeff_s_data[k][2][itv][its] = Rayscatt_coeff_s_array[Rayscatt_coeff_s_array_index];
                    }
                    ++Rayscatt_coeff_s_array_index;
                }
            }
        }
        double[] Rayscatt_coeff_s_ord_tab = new double[4];
        for (int k2 = 0; k2 < 4; ++k2) {
            Rayscatt_coeff_s_ord_tab[k2] = k2;
        }
        double[] Rayscatt_coeff_s_ser_tab = new double[3];
        for (int s = 0; s < 3; ++s) {
            Rayscatt_coeff_s_ser_tab[s] = s;
        }
        this.Rayscatt_coeff_s = new LUT(Rayscatt_coeff_s_data);
        this.Rayscatt_coeff_s.setTab(0, Rayscatt_coeff_s_ord_tab);
        this.Rayscatt_coeff_s.setTab(1, Rayscatt_coeff_s_ser_tab);
        double[] ang_scale = auxFileS.readDoubleArray("S200", 12);
        this.Rayscatt_coeff_s.setTab(2, ang_scale);
        this.Rayscatt_coeff_s.setTab(3, ang_scale);
    }

    private void loadLandAerosolAuxData(AuxFile auxFileS, AuxFile auxFileT) throws IOException, L2AuxDataException {
        double[] r7thresh_tab1;
        double[] r7thresh_tab2 = r7thresh_tab1 = auxFileS.readDoubleArray("S200", 12);
        double[] r7thresh_tab3 = auxFileS.readDoubleArray("S202", 19);
        this.alpha_thresh = new double[2];
        this.alpha_thresh[0] = auxFileS.readDouble("S300");
        this.alpha_thresh[1] = auxFileS.readDouble("S302");
        float[] fbuf = auxFileS.readFloatArray("S301", -1);
        float[][][] r7thresh_LUT = new float[12][12][19];
        int z = 0;
        for (int its = 0; its < 12; ++its) {
            for (int itv = its; itv < 12; ++itv) {
                for (int idf = 0; idf < 19; ++idf) {
                    r7thresh_LUT[its][itv][idf] = fbuf[z];
                    if (itv != its) {
                        r7thresh_LUT[itv][its][idf] = fbuf[z];
                    }
                    ++z;
                }
            }
        }
        this.r7thresh = new LUT(r7thresh_LUT);
        this.r7thresh.setTab(0, r7thresh_tab1);
        this.r7thresh.setTab(1, r7thresh_tab2);
        this.r7thresh.setTab(2, r7thresh_tab3);
        fbuf = auxFileS.readFloatArray("S303", -1);
        float[][][] r13thresh_LUT = new float[12][12][19];
        z = 0;
        for (int its = 0; its < 12; ++its) {
            for (int itv = its; itv < 12; ++itv) {
                for (int idf = 0; idf < 19; ++idf) {
                    r13thresh_LUT[its][itv][idf] = fbuf[z];
                    if (itv != its) {
                        r13thresh_LUT[itv][its][idf] = fbuf[z];
                    }
                    ++z;
                }
            }
        }
        this.r13thresh = new LUT(r13thresh_LUT);
        this.r13thresh.setTab(0, r7thresh_tab1);
        this.r13thresh.setTab(1, r7thresh_tab2);
        this.r13thresh.setTab(2, r7thresh_tab3);
        this.lap_b_thresh = auxFileS.readIntArray("S204", 2);
        this.lap_b_thresh[0] = this.lap_b_thresh[0] - 1;
        this.lap_b_thresh[1] = this.lap_b_thresh[1] - 1;
        this.lap_beta_l = auxFileS.readDouble("S205");
        this.lap_beta_w = auxFileS.readDouble("S206");
        TiePointGrid szaGrid = this.sourceProduct.getTiePointGrid("sun_zenith");
        if (szaGrid == null) {
            String msg = String.format("Source product does not contain tie-point grid '%s'", "sun_zenith");
            throw new L2AuxDataException(msg);
        }
        Stx stx = szaGrid.getStx(true, ProgressMonitor.NULL);
        fbuf = auxFileT.readFloatArray("T203", -1);
        double[] fbufCopy = new double[27];
        for (int i = 0; i < fbuf.length; ++i) {
            fbufCopy[i] = fbuf[i];
        }
        FractIndex fract = new FractIndex();
        Interp.interpCoord(stx.getMinimum(), fbufCopy, fract);
        int min = fract.index;
        Interp.interpCoord(stx.getMaximum(), fbufCopy, fract);
        int max = fract.index;
        if (fract.fraction > 0.0) {
            ++max;
        }
        if (max >= min + 27) {
            throw new L2AuxDataException("Wrong thetas(ROG) range: " + min + " to " + max);
        }
        min = Math.min(min, 0);
        float[] rog_tab5 = new float[27];
        System.arraycopy(fbuf, min, rog_tab5, 0, 27);
        float[] rog_tab2 = auxFileT.readFloatArray("T206", 19);
        float[] rog_tab3 = auxFileT.readFloatArray("T208", 25);
        float[] rog_tab4 = auxFileT.readFloatArray("T20G", 5);
        float[] rog_tab1 = auxFileT.readFloatArray("T20H", 7);
        float[][][][][] rog_LUT = new float[7][19][25][5][27];
        for (int its = 0; its < 27; ++its) {
            int idf;
            int itv;
            int wa;
            int ws = 0;
            fbuf = (float[])auxFileT.readRecord("T700", min + its, -1, 30, null).getElems();
            z = 0;
            for (wa = 0; wa < 7; ++wa) {
                for (itv = 0; itv < 19; ++itv) {
                    for (idf = 0; idf < 25; ++idf) {
                        rog_LUT[wa][itv][idf][ws][its] = fbuf[z];
                        ++z;
                    }
                }
            }
            for (ws = 1; ws < 5; ++ws) {
                fbuf = (float[])auxFileT.readRecord("T70" + ws, min + its, -1, 30, null).getElems();
                z = 0;
                for (wa = 0; wa < 7; ++wa) {
                    for (itv = 0; itv < 19; ++itv) {
                        for (idf = 0; idf < 25; ++idf) {
                            rog_LUT[wa][itv][idf][ws][its] = fbuf[z];
                            ++z;
                        }
                    }
                }
            }
        }
        this.rog = new LUT(rog_LUT);
        this.rog.setTab(0, L2AuxData.makeDoubleArrayCopy(rog_tab1));
        this.rog.setTab(1, L2AuxData.makeDoubleArrayCopy(rog_tab2));
        this.rog.setTab(2, L2AuxData.makeDoubleArrayCopy(rog_tab3));
        this.rog.setTab(3, L2AuxData.makeDoubleArrayCopy(rog_tab4));
        this.rog.setTab(4, L2AuxData.makeDoubleArrayCopy(rog_tab5));
    }

    private static double[] makeDoubleArrayCopy(float[] floatArray) {
        double[] doubleArray = new double[floatArray.length];
        for (int i = 0; i < floatArray.length; ++i) {
            doubleArray[i] = floatArray[i];
        }
        return doubleArray;
    }

    public static class SmileParams {
        public final boolean[] enabled = new boolean[15];
        public final int[][] derivative_band_id = new int[15][2];
    }
}

