/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.l2auxdata;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Iterator;
import org.esa.s3tbx.meris.l2auxdata.L2AuxDataException;
import org.esa.s3tbx.meris.l2auxdata.Utils;
import org.esa.snap.core.util.SystemUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class DpmConfig {
    public static final String REMOTE_AUXDATA_PATH = "http://step.esa.int/auxdata/meris-l2auxdata/meris_l2.zip";
    private static final String AUXDATA_DIRNAME = "meris_l2";
    private static final String MERIS_L2_CONF = "meris_l2_config.xml";
    private Element rootElement;
    private File auxdataTargetDir;

    public DpmConfig() throws L2AuxDataException {
        Path auxdataDirPath = SystemUtils.getAuxDataPath().resolve(AUXDATA_DIRNAME).toAbsolutePath();
        if (!Files.isRegularFile(auxdataDirPath.resolve(MERIS_L2_CONF), new LinkOption[0])) {
            try {
                Utils.downloadAndInstallAuxdata(auxdataDirPath, new URL(REMOTE_AUXDATA_PATH));
            }
            catch (MalformedURLException e) {
                throw new L2AuxDataException("Not able to download auxiliary data.", e);
            }
        }
        this.auxdataTargetDir = auxdataDirPath.toFile();
        File configFile = new File(this.auxdataTargetDir, MERIS_L2_CONF);
        FileReader reader = null;
        try {
            reader = new FileReader(configFile);
            this.init(reader);
        }
        catch (FileNotFoundException e) {
            throw new L2AuxDataException("Configuration file not found: " + configFile.getPath());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public File getAuxDataDir() throws L2AuxDataException {
        Element auxDataConfigElement = this.getMandatoryChild(this.rootElement, "aux_data_config");
        String auxDataDirPath = this.getOptionalAttribute(auxDataConfigElement, "dir");
        File auxDataDir = auxDataDirPath != null ? new File(auxDataDirPath) : this.auxdataTargetDir;
        return auxDataDir;
    }

    public File getAuxDatabaseFile(String name, Date acquisitionDate) throws L2AuxDataException {
        String auxDatabaseFilename = null;
        Element auxDataConfigElement = this.getMandatoryChild(this.rootElement, "aux_data_config");
        Element auxDataDefaultsElement = this.getMandatoryChild(auxDataConfigElement, "aux_data_defaults");
        Iterator auxDatabaseElementIt = this.getMandatoryChildren(auxDataDefaultsElement, "aux_database");
        while (auxDatabaseElementIt.hasNext()) {
            Element auxDatabaseElement = (Element)auxDatabaseElementIt.next();
            String auxDatabaseName = this.getMandatoryAttribute(auxDatabaseElement, "name");
            if (!name.equalsIgnoreCase(auxDatabaseName)) continue;
            auxDatabaseFilename = this.getMandatoryAttribute(auxDatabaseElement, "file");
            break;
        }
        if (acquisitionDate != null) {
            // empty if block
        }
        if (auxDatabaseFilename == null) {
            throw new L2AuxDataException("Auxiliary database name not specified in configuration: " + name);
        }
        File auxDataDir = this.getAuxDataDir();
        return new File(new File(auxDataDir, name), auxDatabaseFilename);
    }

    private Element getMandatoryChild(Element parent, String name) throws L2AuxDataException {
        Element child = parent.getChild(name);
        if (child == null) {
            throw new L2AuxDataException("Missing element '" + name + "' in element '" + parent.getName() + "'");
        }
        return child;
    }

    private Iterator getMandatoryChildren(Element parent, String name) throws L2AuxDataException {
        Iterator iterator = parent.getChildren(name).iterator();
        if (!iterator.hasNext()) {
            throw new L2AuxDataException("Missing element(s) '" + name + "' in element '" + parent.getName() + "'");
        }
        return iterator;
    }

    private String getOptionalAttribute(Element element, String name) {
        return element.getAttributeValue(name);
    }

    private String getMandatoryAttribute(Element element, String name) throws L2AuxDataException {
        String value = element.getAttributeValue(name);
        if (value == null) {
            throw new L2AuxDataException("Missing attribute '" + name + "' in element '" + element.getName() + "'");
        }
        return value;
    }

    private void init(Reader reader) throws L2AuxDataException {
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setValidation(false);
        try {
            Document document = saxBuilder.build(reader);
            this.rootElement = document.getRootElement();
        }
        catch (IOException | JDOMException e) {
            throw new L2AuxDataException("Failed to load configuration", e);
        }
    }
}

