/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.l2auxdata;

import org.esa.s3tbx.meris.l2auxdata.AuxDatasetInfo;
import org.esa.s3tbx.meris.l2auxdata.AuxVariableInfo;

public class AuxFileInfo {
    private char _typeId;
    private String _dirName;
    private int _datasetCount;
    private AuxDatasetInfo[] _datasetInfos;
    private AuxVariableInfo[] _variableInfos;
    private boolean _editable;
    private boolean _import;
    private String _description;

    public char getTypeId() {
        return this._typeId;
    }

    void setTypeId(char typeId) {
        this._typeId = typeId;
    }

    public String getDirName() {
        return this._dirName;
    }

    void setDirName(String dirName) {
        this._dirName = dirName;
    }

    public String getDescription() {
        return this._description;
    }

    void setDescription(String description) {
        this._description = description;
    }

    public boolean isImport() {
        return this._import;
    }

    void setImport(boolean anImport) {
        this._import = anImport;
    }

    public boolean isEditable() {
        return this._editable;
    }

    void setEditable(boolean editable) {
        this._editable = editable;
    }

    public int getDatasetCount() {
        return this._datasetCount;
    }

    public AuxDatasetInfo getDatasetInfo(int index) {
        return this._datasetInfos[index];
    }

    public AuxDatasetInfo getDatasetInfo(char id) {
        int index = this.getDatasetIndex(id);
        if (index == -1) {
            throw new IllegalArgumentException("database " + this.getDirName() + ": invalid dataset index: '" + id + "'");
        }
        return this.getDatasetInfo(index);
    }

    public int getDatasetIndex(char id) {
        for (int i = 0; i < this._datasetInfos.length; ++i) {
            AuxDatasetInfo datasetInfo = this._datasetInfos[i];
            if (datasetInfo.getId() != id) continue;
            return i;
        }
        return -1;
    }

    public int getVariableCount() {
        return this._variableInfos.length;
    }

    public AuxVariableInfo getVariableInfo(int index) {
        return this._variableInfos[index];
    }

    public int getVariableIndex(String id) {
        for (int i = 0; i < this.getVariableCount(); ++i) {
            AuxVariableInfo variableInfo = this._variableInfos[i];
            if (!variableInfo.getId().equals(id)) continue;
            return i;
        }
        return -1;
    }

    public AuxVariableInfo getVariableInfo(String id) {
        int index = this.getVariableIndex(id);
        if (index == -1) {
            throw new IllegalArgumentException("database " + this.getDirName() + ": invalid id: " + id);
        }
        return this.getVariableInfo(index);
    }

    void setVariableInfos(AuxVariableInfo[] variableInfos) {
        this._variableInfos = variableInfos;
    }

    void setDatasetCount(int datasetCount) {
        this._datasetCount = datasetCount;
        this._datasetInfos = new AuxDatasetInfo[this._datasetCount];
        for (int i = 0; i < this._datasetInfos.length; ++i) {
            this._datasetInfos[i] = new AuxDatasetInfo(this, i);
        }
    }
}

