/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.l2auxdata;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.s3tbx.meris.l2auxdata.AuxDatabase;
import org.esa.s3tbx.meris.l2auxdata.AuxDatasetInfo;
import org.esa.s3tbx.meris.l2auxdata.AuxFileInfo;
import org.esa.s3tbx.meris.l2auxdata.AuxVariableInfo;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.Guardian;

public class AuxFile {
    private final AuxFileInfo _fileInfo;
    private final File _file;
    private ImageInputStream _inputStream;
    private int[] _recordCounts;
    private long[] _datasetOffsets;
    private long _computedFileSize;

    public static AuxFile open(char typeId, File file) throws IOException {
        AuxFileInfo fileInfo = AuxDatabase.getInstance().getFileInfo(typeId);
        AuxFile auxFile = new AuxFile(fileInfo, file);
        auxFile.open();
        return auxFile;
    }

    public AuxFile(AuxFileInfo fileInfo, File file) {
        this._fileInfo = fileInfo;
        this._file = file;
    }

    public AuxFileInfo getFileInfo() {
        return this._fileInfo;
    }

    public File getFile() {
        return this._file;
    }

    public ImageInputStream getInputStream() {
        return this._inputStream;
    }

    public long getComputedFileSize() {
        return this._computedFileSize;
    }

    public boolean isOpen() {
        return this._inputStream != null;
    }

    public void open() throws IOException {
        if (this._inputStream != null) {
            throw new IllegalStateException("already open");
        }
        AuxDatabase.getLogger().info("opening auxiliary database file '" + this._file.getPath() + "'");
        if (this._inputStream == null) {
            this._inputStream = new FileImageInputStream(this._file);
        }
        int datasetCount = this._fileInfo.getDatasetCount();
        this._recordCounts = new int[datasetCount];
        this._datasetOffsets = new long[datasetCount];
        long datasetOffset = 0L;
        for (int i = 0; i < datasetCount; ++i) {
            AuxDatasetInfo datasetInfo = this._fileInfo.getDatasetInfo(i);
            String varIdForNumRecords = datasetInfo.getVarIdForNumRecords();
            this._recordCounts[i] = varIdForNumRecords != null ? (int)this.readUInt(varIdForNumRecords) : 1;
            this._datasetOffsets[i] = datasetOffset;
            datasetOffset += (long)(this._recordCounts[i] * datasetInfo.getRecordSize());
        }
        this._computedFileSize = datasetOffset;
        AuxDatabase.getLogger().fine("computed file size is " + this._computedFileSize + " bytes");
    }

    public void close() {
        if (this._inputStream == null) {
            return;
        }
        try {
            this._inputStream.close();
        }
        catch (IOException e) {
            AuxDatabase.getLogger().warning("failed to close auxiliary database file '" + this._file.getPath() + "'");
        }
        this._inputStream = null;
        this._recordCounts = null;
        this._datasetOffsets = null;
        this._computedFileSize = 0L;
        AuxDatabase.getLogger().info("closed auxiliary database file '" + this._file.getPath() + "'");
    }

    public int readInt(String varId) throws IOException {
        ProductData data = this.readRecord(varId, 0, 1, 12, null);
        return data.getElemInt();
    }

    public long readUInt(String varId) throws IOException {
        ProductData data = this.readRecord(varId, 0, 1, 22, null);
        return data.getElemUInt();
    }

    public float readFloat(String varId) throws IOException {
        ProductData data = this.readRecord(varId, 0, 1, 30, null);
        return data.getElemFloat();
    }

    public double readDouble(String varId) throws IOException {
        ProductData data = this.readRecord(varId, 0, 1, 31, null);
        return data.getElemDouble();
    }

    public int[] readIntArray(String varId, int elementCount) throws IOException {
        ProductData data = this.readRecord(varId, 0, elementCount, 12, null);
        return (int[])data.getElems();
    }

    public int[] readUIntArray(String varId, int elementCount) throws IOException {
        ProductData data = this.readRecord(varId, 0, elementCount, 22, null);
        return (int[])data.getElems();
    }

    public float[] readFloatArray(String varId, int elementCount) throws IOException {
        ProductData data = this.readRecord(varId, 0, elementCount, 30, null);
        return (float[])data.getElems();
    }

    public double[] readDoubleArray(String varId, int elementCount) throws IOException {
        ProductData data = this.readRecord(varId, 0, elementCount, 31, null);
        return (double[])data.getElems();
    }

    public ProductData readRecord(String varId, int varType) throws IOException {
        return this.readRecord(varId, 0, -1, varType, null);
    }

    public ProductData readRecord(String varId, int recordIndex, int elementCount, int memoryDataType, ProductData memoryData) throws IOException {
        ProductData storageData;
        Guardian.assertNotNullOrEmpty((String)"varId", (String)varId);
        if (this._inputStream == null) {
            throw new IllegalStateException("no input stream");
        }
        AuxVariableInfo variableInfo = AuxDatabase.getInstance().getVariableInfo(varId);
        AuxDatasetInfo datasetInfo = variableInfo.getDatasetInfo();
        if (this.getFileInfo() != datasetInfo.getFileInfo()) {
            throw new IllegalArgumentException("illegal varId: " + varId);
        }
        int storageDataType = variableInfo.getDataType();
        int storageElemsCount = variableInfo.getNumElements();
        int memoryElemsCount = storageDataType == 41 && memoryDataType != 41 ? 1 : storageElemsCount;
        if (elementCount > 0 && elementCount != memoryElemsCount) {
            throw new IOException("Auxiliary variable '" + variableInfo.getId() + "': Element count mismatch, expected " + elementCount + ", but was " + memoryElemsCount);
        }
        if (memoryData != null) {
            this.checkMemoryData(memoryData, memoryDataType, memoryElemsCount);
        } else {
            memoryData = this.allocate(variableInfo, memoryDataType, memoryElemsCount);
        }
        if (memoryDataType == storageDataType) {
            storageData = memoryData;
        } else {
            AuxDatabase.getLogger().warning(this.createDataConversionMessage(variableInfo, storageDataType, memoryDataType));
            storageData = this.allocate(variableInfo, storageDataType, storageElemsCount);
        }
        this.checkRecordSize(variableInfo, storageData);
        long offset = this.getOffset(datasetInfo, variableInfo, recordIndex);
        this._inputStream.seek(offset);
        storageData.readFrom(this._inputStream);
        this.convertData(variableInfo, storageData, memoryData);
        return memoryData;
    }

    private void checkMemoryData(ProductData memoryData, int memoryDataType, int memoryElemsCount) {
        if (memoryDataType == 41 && !(memoryData instanceof ProductData.ASCII) || memoryDataType == 51 && !(memoryData instanceof ProductData.UTC) || memoryDataType != 41 && memoryDataType != 51 && memoryDataType != memoryData.getType()) {
            throw new IllegalArgumentException("illegal memoryData: memoryDataType mismatch");
        }
        if (memoryData.getNumElems() != memoryElemsCount) {
            throw new IllegalArgumentException("illegal memoryData: memoryElemsCount mismatch");
        }
    }

    private void checkRecordSize(AuxVariableInfo variableInfo, ProductData storageData) {
        int storageRecSize;
        int variableRecSize = variableInfo.getNumBytes();
        if (variableRecSize != (storageRecSize = storageData.getElemSize() * storageData.getNumElems())) {
            AuxDatabase.getLogger().warning(this.createRecordSizeMismatchMessage(variableInfo, variableRecSize, storageRecSize));
        }
    }

    private long getOffset(AuxDatasetInfo datasetInfo, AuxVariableInfo variableInfo, int recordIndex) {
        long datasetOffset = this._datasetOffsets[datasetInfo.getIndex()];
        int variableOffset = variableInfo.getOffset();
        return datasetOffset + (long)variableOffset + (long)(recordIndex * datasetInfo.getRecordSize());
    }

    private int convertData(AuxVariableInfo variableInfo, ProductData storageData, ProductData memoryData) throws IOException {
        int elementCount = storageData.getNumElems();
        if (storageData instanceof ProductData.ASCII) {
            int memoryDataType = memoryData.getType();
            if (!(memoryData instanceof ProductData.ASCII)) {
                if (ProductData.isUIntType((int)memoryDataType)) {
                    elementCount = this.convertAsciiToUnsignedInteger(storageData, memoryData);
                } else if (ProductData.isIntType((int)memoryDataType)) {
                    elementCount = this.convertAsciiToSignedInteger(storageData, memoryData);
                } else if (ProductData.isFloatingPointType((int)memoryDataType)) {
                    elementCount = this.convertAsciiToFloatingPoint(storageData, memoryData);
                } else {
                    throw new IOException("illegal data conversion, aux-variable " + variableInfo.getId());
                }
            }
        }
        double scale = variableInfo.getScale();
        if (storageData == memoryData && scale != 1.0 || storageData != memoryData && storageData.getNumElems() == memoryData.getNumElems()) {
            for (int i = 0; i < storageData.getNumElems(); ++i) {
                memoryData.setElemDoubleAt(i, scale * storageData.getElemDoubleAt(i));
            }
        }
        return elementCount;
    }

    private int convertAsciiToUnsignedInteger(ProductData storageData, ProductData memoryData) throws IOException {
        String ascii = storageData.getElemString().trim();
        int sign = this.getSignum(ascii);
        if (sign == -1) {
            throw new IOException("cannot convert ASCII '" + ascii + "' to unsigned integer number");
        }
        String asciiNumber = this.getAsciiNumber(ascii);
        try {
            memoryData.setElemUInt((long)sign * Long.parseLong(asciiNumber));
            return 1;
        }
        catch (NumberFormatException e) {
            throw new IOException("cannot convert ASCII '" + ascii + "' to unsigned integer number");
        }
    }

    private int convertAsciiToSignedInteger(ProductData storageData, ProductData memoryData) throws IOException {
        String ascii = storageData.getElemString().trim();
        int sign = this.getSignum(ascii);
        String asciiNumber = this.getAsciiNumber(ascii);
        try {
            memoryData.setElemInt(sign * Integer.parseInt(asciiNumber));
            return 1;
        }
        catch (NumberFormatException e) {
            throw new IOException("failed to convert ASCII '" + ascii + "' to signed integer number");
        }
    }

    private int convertAsciiToFloatingPoint(ProductData storageData, ProductData memoryData) throws IOException {
        String ascii = storageData.getElemString().trim();
        int sign = this.getSignum(ascii);
        String asciiNumber = this.getAsciiNumber(ascii);
        try {
            memoryData.setElemDouble((double)sign * Double.parseDouble(asciiNumber));
            return 1;
        }
        catch (NumberFormatException e) {
            throw new IOException("failed to convert ASCII '" + ascii + "' to floating point number");
        }
    }

    private int getSignum(String ascii) {
        return ascii.startsWith("-") ? -1 : 1;
    }

    private String getAsciiNumber(String ascii) {
        String asciiNumber;
        if (ascii.startsWith("-") || ascii.startsWith("+") || ascii.startsWith("0")) {
            int pos;
            for (pos = 1; ascii.charAt(pos) == '0' && pos < ascii.length() - 1; ++pos) {
            }
            asciiNumber = ascii.substring(pos);
        } else {
            asciiNumber = ascii;
        }
        return asciiNumber;
    }

    private ProductData allocate(AuxVariableInfo variableInfo, int dataType, int numElems) throws IOException {
        int byteCount = ProductData.getElemSize((int)dataType) * numElems;
        int mbyteCount = byteCount / 0x100000;
        if (mbyteCount > 10) {
            AuxDatabase.getLogger().info(this.createHugeBufferMessage(variableInfo, mbyteCount));
        }
        try {
            return ProductData.createInstance((int)dataType, (int)numElems);
        }
        catch (OutOfMemoryError e) {
            AuxDatabase.getLogger().log(Level.SEVERE, this.createOutOfMemoryMessage(variableInfo, mbyteCount), e);
            throw new IOException("Out of memory, failed allocate data buffer.");
        }
    }

    private String createOutOfMemoryMessage(AuxVariableInfo variableInfo, int mbyteCount) {
        return this.createMessagePrefix(variableInfo) + "out of memory, failed to allocate data buffer (" + mbyteCount + " M)";
    }

    private String createHugeBufferMessage(AuxVariableInfo variableInfo, int mbyteCount) {
        return this.createMessagePrefix(variableInfo) + "about to allocate \"huge\" data buffer (" + mbyteCount + " M)";
    }

    private String createDataConversionMessage(AuxVariableInfo variableInfo, int storageDataType, int memoryDataType) {
        return this.createMessagePrefix(variableInfo) + "data conversion required from storage data type (" + ProductData.getTypeString((int)storageDataType) + ") to memory data type (" + ProductData.getTypeString((int)memoryDataType) + ")";
    }

    private String createRecordSizeMismatchMessage(AuxVariableInfo variableInfo, int variableRecSize, int storageRecSize) {
        return this.createMessagePrefix(variableInfo) + "variable record size (" + variableRecSize + ") does not match storage record size (" + storageRecSize + ")";
    }

    private String createMessagePrefix(AuxVariableInfo variableInfo) {
        return "file '" + this._file.getName() + "': variable '" + variableInfo.getId() + "': ";
    }
}

