/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.l2auxdata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.esa.s3tbx.meris.l2auxdata.AuxDatasetInfo;
import org.esa.s3tbx.meris.l2auxdata.AuxFileInfo;
import org.esa.s3tbx.meris.l2auxdata.AuxVariableInfo;

public class AuxDatabase {
    private static AuxDatabase _instance = new AuxDatabase();
    private AuxFileInfo[] _fileInfos;
    private HashMap<String, AuxVariableInfo> _varIdToVarInfoMap;

    public int getFileInfoCount() {
        return this._fileInfos.length;
    }

    public static AuxDatabase getInstance() {
        return _instance;
    }

    public AuxFileInfo getFileInfo(int index) {
        return this._fileInfos[index];
    }

    public AuxFileInfo getFileInfo(char type) {
        for (AuxFileInfo fileInfo : this._fileInfos) {
            if (fileInfo.getTypeId() != type) continue;
            return fileInfo;
        }
        throw new IllegalArgumentException("illegal type: '" + type + "'");
    }

    public AuxVariableInfo getVariableInfo(String varId) {
        return this._varIdToVarInfoMap.get(varId);
    }

    public static Logger getLogger() {
        return Logger.getLogger(AuxDatabase.class.getName());
    }

    private AuxDatabase() {
        AuxDatabase.getLogger().info("loading auxiliary resources...");
        try {
            this.initFileInfos();
            this.initVariableInfos();
        }
        catch (IOException e) {
            throw new IllegalStateException("auxiliary resource I/O error: " + e.getMessage());
        }
        AuxDatabase.getLogger().info("auxiliary resources loaded");
    }

    private void initFileInfos() throws IOException {
        String resourceName = "database.db";
        InputStream istream = AuxDatabase.getResourceAsStream("database.db");
        if (istream == null) {
            throw new IllegalArgumentException("resource I/O error: resource not found: database.db");
        }
        try (BufferedReader r = new BufferedReader(new InputStreamReader(istream));){
            this._fileInfos = AuxDatabase.loadFileInfos(r);
        }
    }

    private void initVariableInfos() throws IOException {
        this._varIdToVarInfoMap = new HashMap();
        for (AuxFileInfo fileInfo : this._fileInfos) {
            String resourceName = "index_" + (fileInfo.getTypeId() + ".txa").toLowerCase();
            InputStream istream = AuxDatabase.getResourceAsStream(resourceName);
            if (istream != null) {
                try (BufferedReader r = new BufferedReader(new InputStreamReader(istream));){
                    AuxVariableInfo[] variableInfos = AuxDatabase.loadVariableInfos(fileInfo, r);
                    fileInfo.setVariableInfos(variableInfos);
                    for (int j = 0; j < variableInfos.length; ++j) {
                        AuxVariableInfo variableInfo = fileInfo.getVariableInfo(j);
                        this._varIdToVarInfoMap.put(variableInfo.getId(), variableInfo);
                    }
                    continue;
                }
            }
            AuxDatabase.getLogger().warning("missing resource (might be OK): " + resourceName);
        }
    }

    private static AuxFileInfo[] loadFileInfos(BufferedReader r) throws IOException {
        String line;
        ArrayList<AuxFileInfo> fileInfoList = new ArrayList<AuxFileInfo>();
        AuxFileInfo fileInfo = null;
        int dataIndex = 0;
        while ((line = r.readLine()) != null) {
            int i;
            StringTokenizer st;
            if ((line = line.trim()).startsWith("#")) continue;
            if (dataIndex == 0) {
                fileInfo = new AuxFileInfo();
                fileInfoList.add(fileInfo);
                fileInfo.setTypeId(line.charAt(0));
            } else if (dataIndex == 1) {
                st = new StringTokenizer(line);
                fileInfo.setEditable(Integer.parseInt(st.nextToken()) != 0);
                fileInfo.setImport(Integer.parseInt(st.nextToken()) != 0);
                fileInfo.setDirName(st.nextToken());
            } else if (dataIndex == 2) {
                fileInfo.setDescription(line);
            } else if (dataIndex == 3) {
                fileInfo.setDatasetCount(Integer.parseInt(line));
            } else if (dataIndex == 4) {
                st = new StringTokenizer(line);
                for (i = 0; i < fileInfo.getDatasetCount(); ++i) {
                    int index = Integer.parseInt(st.nextToken());
                    char id = (char)(index < 10 ? 48 + index : 65 + index - 10);
                    fileInfo.getDatasetInfo(i).setId(id);
                }
            } else if (dataIndex == 5) {
                st = new StringTokenizer(line);
                for (i = 0; i < fileInfo.getDatasetCount(); ++i) {
                    fileInfo.getDatasetInfo(i).setType(Integer.parseInt(st.nextToken()));
                }
            } else if (dataIndex == 6) {
                st = new StringTokenizer(line);
                for (i = 0; i < fileInfo.getDatasetCount(); ++i) {
                    fileInfo.getDatasetInfo(i).setRecordSize(Integer.parseInt(st.nextToken()));
                }
            } else if (dataIndex == 7) {
                st = new StringTokenizer(line);
                for (i = 0; i < fileInfo.getDatasetCount(); ++i) {
                    String varIdForNumRecs = st.nextToken();
                    if (varIdForNumRecs.length() <= 1) continue;
                    fileInfo.getDatasetInfo(i).setVarIdForNumRecords(varIdForNumRecs);
                }
            } else if (dataIndex >= 8 && dataIndex < 8 + fileInfo.getDatasetCount()) {
                i = dataIndex - 8;
                fileInfo.getDatasetInfo(i).setName(line);
            } else {
                dataIndex = -1;
            }
            ++dataIndex;
        }
        AuxFileInfo[] databaseInfos = new AuxFileInfo[fileInfoList.size()];
        fileInfoList.toArray(databaseInfos);
        return databaseInfos;
    }

    private static AuxVariableInfo[] loadVariableInfos(AuxFileInfo fileInfo, BufferedReader r) throws IOException {
        String line;
        ArrayList<AuxVariableInfo> variableInfoList = new ArrayList<AuxVariableInfo>();
        AuxVariableInfo variableInfo = null;
        int dataIndex = 0;
        while ((line = r.readLine()) != null) {
            if ((line = line.trim()).startsWith("#")) continue;
            if (dataIndex == 0) {
                StringTokenizer st = new StringTokenizer(line);
                String varId = st.nextToken();
                char datasetId = varId.charAt(1);
                AuxDatasetInfo datasetInfo = fileInfo.getDatasetInfo(datasetId);
                variableInfo = new AuxVariableInfo(datasetInfo);
                variableInfo.setId(varId);
                variableInfo.setOffset(Integer.parseInt(st.nextToken()));
                variableInfo.setScale(Double.parseDouble(st.nextToken()));
                variableInfo.setDataType(AuxDatabase.getProductDataType(Integer.parseInt(st.nextToken())));
                variableInfo.setDim1(Integer.parseInt(st.nextToken()));
                variableInfo.setDim2(Integer.parseInt(st.nextToken()));
                variableInfo.setDim3(Integer.parseInt(st.nextToken()));
                variableInfo.setElementSize(Integer.parseInt(st.nextToken()));
                variableInfo.setEditFlag(Integer.parseInt(st.nextToken()));
                variableInfo.setEditType(Integer.parseInt(st.nextToken()));
                variableInfo.setDisplayType(Integer.parseInt(st.nextToken()));
                if (st.hasMoreTokens()) {
                    String range = st.nextToken();
                    variableInfo.setRange(range.equals("-") ? null : range);
                }
                variableInfoList.add(variableInfo);
            } else if (dataIndex == 1) {
                variableInfo.setComment(line.equals("-") ? null : line);
            } else if (dataIndex == 2) {
                variableInfo.setUnit(line.equals("-") ? null : line);
            } else {
                dataIndex = -1;
            }
            ++dataIndex;
        }
        AuxVariableInfo[] variableDescriptors = new AuxVariableInfo[variableInfoList.size()];
        variableInfoList.toArray(variableDescriptors);
        return variableDescriptors;
    }

    private static InputStream getResourceAsStream(String resourceName) {
        return AuxDatabase.class.getResourceAsStream(resourceName);
    }

    private static int getProductDataType(int varDataType) {
        boolean STRING = false;
        boolean SI_CHAR = true;
        int SI_SHORT = 2;
        int SI_LONG = 3;
        int F_FLOAT = 4;
        int F_DOUBLE = 5;
        int UN_CHAR = 10;
        int UN_SHORT = 20;
        int UN_LONG = 30;
        int MJD = 90;
        if (varDataType == 10) {
            return 20;
        }
        if (varDataType == 1) {
            return 10;
        }
        if (varDataType == 20) {
            return 21;
        }
        if (varDataType == 2) {
            return 11;
        }
        if (varDataType == 30) {
            return 22;
        }
        if (varDataType == 3) {
            return 12;
        }
        if (varDataType == 4) {
            return 30;
        }
        if (varDataType == 5) {
            return 31;
        }
        if (varDataType == 90) {
            return 51;
        }
        if (varDataType == 0) {
            return 41;
        }
        throw new IllegalArgumentException("illegal varDataType: " + varDataType);
    }
}

