/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.meris.dpm;

import org.esa.s3tbx.meris.l2auxdata.L2AuxData;
import org.esa.s3tbx.util.math.FractIndex;
import org.esa.s3tbx.util.math.Interp;

public class PixelId {
    private final L2AuxData auxData;

    public PixelId(L2AuxData auxData) {
        this.auxData = auxData;
    }

    public Pressure computePressure(double rhoToa753, double rhoToa760, double airMass, int detectorIndex) {
        double eta;
        Pressure press = new Pressure();
        FractIndex spectralShiftIndex = new FractIndex();
        FractIndex[] cIndex = FractIndex.createArray(2);
        Interp.interpCoord(this.auxData.central_wavelength[10][detectorIndex], this.auxData.spectral_shift_wavelength, spectralShiftIndex);
        if (rhoToa753 > 0.0) {
            eta = rhoToa760 / rhoToa753;
        } else {
            eta = 0.0;
            press.error = true;
        }
        Interp.interpCoord(airMass, this.auxData.C.getTab(1), cIndex[0]);
        Interp.interpCoord(rhoToa753, this.auxData.C.getTab(2), cIndex[1]);
        float[][][] c_lut = (float[][][])this.auxData.C.getJavaArray();
        double C_res = Interp.interpolate(c_lut[0], cIndex);
        double ethaC = eta * C_res;
        Pressure press_1 = this.computeSurfacePressure(ethaC, airMass, spectralShiftIndex.index);
        Pressure press_2 = this.computeSurfacePressure(ethaC, airMass, spectralShiftIndex.index + 1);
        press.value = press_1.error ? press_2.value : (press_2.error ? press_1.value : (1.0 - spectralShiftIndex.fraction) * press_1.value + spectralShiftIndex.fraction * press_2.value);
        press.error = press.error || press_1.error || press_2.error;
        return press;
    }

    public Pressure computeSurfacePressure(double eta_C, double airMass, int spectralShift) {
        Pressure press = new Pressure();
        press.error = false;
        FractIndex polcoeffShiftIndex = new FractIndex();
        Interp.interpCoord(spectralShift, this.auxData.polcoeff.getTab(0), polcoeffShiftIndex);
        if (polcoeffShiftIndex.fraction > 0.5) {
            ++polcoeffShiftIndex.index;
        }
        float[][] polcoeff = (float[][])this.auxData.polcoeff.getArray().getJavaArray();
        double P = polcoeff[polcoeffShiftIndex.index][0];
        double koeff = 1.0;
        for (int i = 1; i < 12; ++i) {
            P += (double)polcoeff[polcoeffShiftIndex.index][i] * (koeff *= eta_C);
        }
        if (P <= 308.0 && P >= -308.0) {
            double MP2 = Math.pow(10.0, P);
            press.value = Math.sqrt(MP2 / airMass);
            if (press.value > this.auxData.maxPress) {
                press.value = this.auxData.maxPress;
                press.error = true;
            }
        } else {
            press.value = 0.0;
            press.error = true;
        }
        return press;
    }

    public double getPressureThreshold(double sza, double vza, boolean isLand) {
        double delta_press_thresh;
        FractIndex[] DP_Index = FractIndex.createArray(2);
        if (isLand) {
            Interp.interpCoord(sza, this.auxData.DPthresh_land.getTab(0), DP_Index[0]);
            Interp.interpCoord(vza, this.auxData.DPthresh_land.getTab(1), DP_Index[1]);
            delta_press_thresh = Interp.interpolate(this.auxData.DPthresh_land.getJavaArray(), DP_Index);
        } else {
            Interp.interpCoord(sza, this.auxData.DPthresh_ocean.getTab(0), DP_Index[0]);
            Interp.interpCoord(vza, this.auxData.DPthresh_ocean.getTab(1), DP_Index[1]);
            delta_press_thresh = Interp.interpolate(this.auxData.DPthresh_ocean.getJavaArray(), DP_Index);
        }
        return delta_press_thresh;
    }

    public boolean[] getPressureThreshFlags(double ecmwfPressure, double pressure, double inputPressure, double delta_press_thresh) {
        boolean[] result_flags = new boolean[]{inputPressure != -1.0 ? inputPressure < ecmwfPressure - delta_press_thresh : ecmwfPressure < ecmwfPressure - delta_press_thresh, pressure < ecmwfPressure - delta_press_thresh, Math.abs(ecmwfPressure - pressure) > this.auxData.press_confidence};
        return result_flags;
    }

    public double getRhoRC442thr(double sza, double vza, double delta_azimuth, boolean isLand) {
        double rhorc_442_thr;
        FractIndex[] rhoRC442index = FractIndex.createArray(3);
        if (isLand) {
            Interp.interpCoord(sza, this.auxData.Rhorc_442_land_LUT.getTab(0), rhoRC442index[0]);
            Interp.interpCoord(vza, this.auxData.Rhorc_442_land_LUT.getTab(1), rhoRC442index[1]);
            Interp.interpCoord(delta_azimuth, this.auxData.Rhorc_442_land_LUT.getTab(2), rhoRC442index[2]);
            rhorc_442_thr = Interp.interpolate(this.auxData.Rhorc_442_land_LUT.getJavaArray(), rhoRC442index);
        } else {
            Interp.interpCoord(sza, this.auxData.Rhorc_442_ocean_LUT.getTab(0), rhoRC442index[0]);
            Interp.interpCoord(vza, this.auxData.Rhorc_442_ocean_LUT.getTab(1), rhoRC442index[1]);
            Interp.interpCoord(delta_azimuth, this.auxData.Rhorc_442_ocean_LUT.getTab(2), rhoRC442index[2]);
            rhorc_442_thr = Interp.interpolate(this.auxData.Rhorc_442_ocean_LUT.getJavaArray(), rhoRC442index);
        }
        return rhorc_442_thr;
    }

    public boolean isBrightFlag(double[] rhoAg, double rhorc_442_thr, double radianceBrightN) {
        boolean bright_f = rhoAg[this.auxData.band_bright_n] >= rhorc_442_thr || this.isSaturated(radianceBrightN, this.auxData.band_bright_n);
        return bright_f;
    }

    public boolean isSpectraSlope1Flag(double[] rhoAg, double radianceSlopeN1) {
        double slope1;
        boolean slope1_f = rhoAg[this.auxData.band_slope_d_1] <= 0.0 ? false : (slope1 = rhoAg[this.auxData.band_slope_n_1] / rhoAg[this.auxData.band_slope_d_1]) >= this.auxData.slope_1_low_thr && slope1 <= this.auxData.slope_1_high_thr || this.isSaturated(radianceSlopeN1, this.auxData.band_slope_n_1);
        return slope1_f;
    }

    public boolean isSpectraSlope2Flag(double[] rhoAg, double radianceSlopeN2) {
        double slope2;
        boolean slope2_f = rhoAg[this.auxData.band_slope_d_2] <= 0.0 ? false : (slope2 = rhoAg[this.auxData.band_slope_n_2] / rhoAg[this.auxData.band_slope_d_2]) >= this.auxData.slope_2_low_thr && slope2 <= this.auxData.slope_2_high_thr || this.isSaturated(radianceSlopeN2, this.auxData.band_slope_n_2);
        return slope2_f;
    }

    public boolean isSaturated(double radiance, int bandId) {
        return radiance > this.auxData.Saturation_L[bandId];
    }

    public static class Pressure {
        public double value;
        public boolean error;
    }
}

