/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.operator.cloud;

import java.io.IOException;
import java.util.HashMap;
import org.esa.s3tbx.operator.cloud.CloudOperator;
import org.esa.s3tbx.operator.cloud.CloudPN;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CloudPNTest {
    private CloudPN cloudPn;

    @Before
    public void setUp() throws IOException {
        CloudOperator operator = new CloudOperator();
        operator.installAuxdata();
        HashMap<String, String> cloudConfig = new HashMap<String, String>();
        cloudConfig.put("config_file_name", "cloud_config.txt");
        this.cloudPn = new CloudPN(operator.getAuxdataInstallationPath().toString());
        this.cloudPn.setUp(cloudConfig);
    }

    @Test
    public void testAltitudeCorrectedPressure() {
        double pressure = 1000.0;
        double altitude = 100.0;
        double correctedPressure = this.cloudPn.altitudeCorrectedPressure(pressure, altitude, true);
        Assert.assertEquals((String)"corrected pressure", (double)988.08, (double)correctedPressure, (double)0.01);
        correctedPressure = this.cloudPn.altitudeCorrectedPressure(pressure, altitude, false);
        Assert.assertEquals((String)"corrected pressure", (double)1000.0, (double)correctedPressure, (double)1.0E-4);
    }

    @Test
    public void testCalculateI() {
        double radiance = 50.0;
        float sunSpectralFlux = 10.0f;
        double sunZenith = 45.0;
        double i = this.cloudPn.calculateI(radiance, sunSpectralFlux, sunZenith);
        Assert.assertEquals((String)"calculated i", (double)(radiance / ((double)sunSpectralFlux * Math.cos(sunZenith * (Math.PI / 180)))), (double)i, (double)1.0E-5);
    }
}

