/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.operator.cloud.internal;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import org.esa.s3tbx.operator.cloud.internal.ProcessingNode;
import org.esa.snap.core.dataio.IllegalFileFormatException;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessingNodeTest {
    private SourceProductReader sourceProductReader;
    private TargetProcessingNode targetProcessingNode;
    private Product sourceProduct;
    private Product targetProduct;

    @Before
    public void setUp() throws Exception {
        this.sourceProductReader = new SourceProductReader();
        this.sourceProduct = this.sourceProductReader.readProductNodes(null, null);
        this.targetProcessingNode = new TargetProcessingNode();
        this.targetProduct = this.targetProcessingNode.readProductNodes(this.sourceProduct, null);
    }

    @Test
    public void testSetUp() throws IOException {
        Assert.assertNotNull((Object)this.sourceProduct.getBand("A"));
        Assert.assertNotNull((Object)this.sourceProduct.getBand("B"));
        Assert.assertNotNull((Object)this.targetProduct.getBand("U"));
        Assert.assertNotNull((Object)this.targetProduct.getBand("V"));
        Assert.assertNotNull((Object)this.targetProduct.getBand("W"));
        Assert.assertSame((Object)this.sourceProductReader, (Object)this.sourceProduct.getProductReader());
        Assert.assertSame((Object)((Object)this.targetProcessingNode), (Object)this.targetProduct.getProductReader());
        Assert.assertNull((Object)this.targetProcessingNode.getFrameData("U"));
        Assert.assertNull((Object)this.targetProcessingNode.getFrameData("V"));
        Assert.assertNull((Object)this.targetProcessingNode.getFrameData("W"));
    }

    @Test
    public void testThatDataIsProcessedCorrectly() throws IOException {
        int[] pixelData = new int[4];
        this.targetProduct.getBand("U").readPixels(0, 0, 4, 1, pixelData, ProgressMonitor.NULL);
        Assert.assertEquals((long)0L, (long)pixelData[0]);
        Assert.assertEquals((long)1L, (long)pixelData[1]);
        Assert.assertEquals((long)2L, (long)pixelData[2]);
        Assert.assertEquals((long)3L, (long)pixelData[3]);
        this.targetProduct.getBand("V").readPixels(0, 0, 4, 1, pixelData, ProgressMonitor.NULL);
        Assert.assertEquals((long)0L, (long)pixelData[0]);
        Assert.assertEquals((long)0L, (long)pixelData[1]);
        Assert.assertEquals((long)0L, (long)pixelData[2]);
        Assert.assertEquals((long)0L, (long)pixelData[3]);
        this.targetProduct.getBand("W").readPixels(0, 0, 4, 1, pixelData, ProgressMonitor.NULL);
        Assert.assertEquals((long)0L, (long)pixelData[0]);
        Assert.assertEquals((long)1L, (long)pixelData[1]);
        Assert.assertEquals((long)2L, (long)pixelData[2]);
        Assert.assertEquals((long)3L, (long)pixelData[3]);
        this.targetProduct.getBand("U").readPixels(0, 2, 4, 1, pixelData, ProgressMonitor.NULL);
        Assert.assertEquals((long)0L, (long)pixelData[0]);
        Assert.assertEquals((long)1L, (long)pixelData[1]);
        Assert.assertEquals((long)2L, (long)pixelData[2]);
        Assert.assertEquals((long)3L, (long)pixelData[3]);
        this.targetProduct.getBand("V").readPixels(0, 2, 4, 1, pixelData, ProgressMonitor.NULL);
        Assert.assertEquals((long)2L, (long)pixelData[0]);
        Assert.assertEquals((long)2L, (long)pixelData[1]);
        Assert.assertEquals((long)2L, (long)pixelData[2]);
        Assert.assertEquals((long)2L, (long)pixelData[3]);
        this.targetProduct.getBand("W").readPixels(0, 2, 4, 1, pixelData, ProgressMonitor.NULL);
        Assert.assertEquals((long)2L, (long)pixelData[0]);
        Assert.assertEquals((long)3L, (long)pixelData[1]);
        Assert.assertEquals((long)4L, (long)pixelData[2]);
        Assert.assertEquals((long)5L, (long)pixelData[3]);
        this.targetProduct.getBand("U").readPixels(3, 0, 1, 4, pixelData, ProgressMonitor.NULL);
        Assert.assertEquals((long)3L, (long)pixelData[0]);
        Assert.assertEquals((long)3L, (long)pixelData[1]);
        Assert.assertEquals((long)3L, (long)pixelData[2]);
        Assert.assertEquals((long)3L, (long)pixelData[3]);
        this.targetProduct.getBand("V").readPixels(3, 0, 1, 4, pixelData, ProgressMonitor.NULL);
        Assert.assertEquals((long)0L, (long)pixelData[0]);
        Assert.assertEquals((long)1L, (long)pixelData[1]);
        Assert.assertEquals((long)2L, (long)pixelData[2]);
        Assert.assertEquals((long)3L, (long)pixelData[3]);
        this.targetProduct.getBand("W").readPixels(3, 0, 1, 4, pixelData, ProgressMonitor.NULL);
        Assert.assertEquals((long)3L, (long)pixelData[0]);
        Assert.assertEquals((long)4L, (long)pixelData[1]);
        Assert.assertEquals((long)5L, (long)pixelData[2]);
        Assert.assertEquals((long)6L, (long)pixelData[3]);
    }

    private static class SourceProductReader
    implements ProductReader {
        private SourceProductReader() {
        }

        public ProductReaderPlugIn getReaderPlugIn() {
            return null;
        }

        public Object getInput() {
            return null;
        }

        public ProductSubsetDef getSubsetDef() {
            return null;
        }

        public Product readProductNodes(Object input, ProductSubsetDef subsetDef) throws IOException, IllegalFileFormatException {
            Product product = new Product("S", "S", 4, 4, (ProductReader)this);
            product.addBand("A", 30);
            product.addBand("B", 30);
            return product;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readBandRasterData(Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
            pm.beginTask("Reading raster data", destHeight);
            try {
                for (int y = 0; y < destHeight; ++y) {
                    for (int x = 0; x < destWidth; ++x) {
                        int sourceX = destOffsetX + x;
                        int sourceY = destOffsetY + y;
                        int index = y * destWidth + x;
                        if (destBand.getName().equals("A")) {
                            destBuffer.setElemDoubleAt(index, (double)sourceX);
                            continue;
                        }
                        if (!destBand.getName().equals("B")) continue;
                        destBuffer.setElemDoubleAt(index, (double)sourceY);
                    }
                    pm.worked(1);
                }
            }
            finally {
                pm.done();
            }
        }

        public void close() throws IOException {
        }
    }

    private static class TargetProcessingNode
    extends ProcessingNode {
        protected Product createTargetProductImpl() {
            Product product = new Product("T", "T", this.getSourceProduct().getSceneRasterWidth(), this.getSourceProduct().getSceneRasterHeight(), (ProductReader)this);
            product.addBand("U", 30);
            product.getBand("U").setDescription("U=A");
            product.addBand("V", 30);
            product.getBand("V").setDescription("V=B");
            product.addBand("W", 30);
            product.getBand("W").setDescription("W=A+B");
            return product;
        }

        protected void processFrame(int frameX, int frameY, int frameW, int frameH, ProgressMonitor pm) throws IOException {
            ProductData uData = this.getFrameData("U");
            ProductData vData = this.getFrameData("V");
            ProductData wData = this.getFrameData("W");
            Band aBand = this.getSourceProduct().getBand("A");
            Band bBand = this.getSourceProduct().getBand("B");
            ProductData aData = aBand.createCompatibleProductData(frameW * frameH);
            ProductData bData = bBand.createCompatibleProductData(frameW * frameH);
            aBand.readRasterData(frameX, frameY, frameW, frameH, aData, pm);
            bBand.readRasterData(frameX, frameY, frameW, frameH, bData, pm);
            for (int y = 0; y < frameH; ++y) {
                for (int x = 0; x < frameW; ++x) {
                    int index = y * frameW + x;
                    uData.setElemDoubleAt(index, aData.getElemDoubleAt(index));
                    vData.setElemDoubleAt(index, bData.getElemDoubleAt(index));
                    wData.setElemDoubleAt(index, aData.getElemDoubleAt(index) + bData.getElemDoubleAt(index));
                }
            }
        }
    }
}

