/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.operator.cloud;

import java.io.File;
import java.net.URL;
import org.esa.s3tbx.operator.cloud.CloudAlgorithm;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CloudAlgorithmTest {
    private CloudAlgorithm testAlgorithm;

    @Before
    public void setUp() throws Exception {
        URL auxdataDirUrl = this.getClass().getResource("/auxdata/nn_config_test.txt");
        File auxdataDir = new File(auxdataDirUrl.toURI()).getParentFile();
        this.testAlgorithm = new CloudAlgorithm(auxdataDir, "nn_config_test.txt");
    }

    @Test
    public void testComputeCloud() {
        double[] in = new double[]{0.0778002, 0.069565, 0.0591455, 0.0545394, 0.0460968, 0.0415193, 0.0420742, 0.0421471, 0.0421236, 0.293535, 1012.98, 762.19, 0.622985, 0.996135, -0.0447822};
        double out = this.testAlgorithm.computeCloud(in);
        Assert.assertEquals((String)"cloud NN result", (double)0.004993, (double)out, (double)1.0E-5);
    }

    @Test
    public void testNn2Probability() {
        double probability = this.testAlgorithm.nn2Probability(0.004993);
        Assert.assertEquals((String)"probability", (double)0.01313, (double)probability, (double)1.0E-5);
    }
}

