/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.operator.cloud;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.jexp.ParseException;
import com.bc.jexp.Term;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.esa.beam.dataio.envisat.EnvisatConstants;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.SampleCoding;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.operator.cloud.CentralWavelengthProvider;
import org.esa.beam.operator.cloud.CloudAlgorithm;
import org.esa.beam.operator.cloud.internal.ProcessingNode;
import org.esa.beam.util.logging.BeamLogManager;

class CloudPN
extends ProcessingNode {
    public static final String CLOUD_AUXDATA_DIR_PROPERTY = "cloud.auxdata.dir";
    public static final String CONFIG_FILE_NAME = "config_file_name";
    public static final String INVALID_EXPRESSION = "invalid_expression";
    public static final String CLOUD_PROP_BAND = "cloud_prob";
    public static final String CLOUD_FLAG_BAND = "cloud_flag";
    private static final String DEFAULT_OUTPUT_PRODUCT_NAME = "MER_CLOUD";
    private static final String PRODUCT_TYPE = "MER_L2_CLOUD";
    private static final String DEFAULT_VALID_LAND_EXP = "not l1_flags.INVALID and dem_alt > -50";
    private static final String DEFAULT_VALID_OCEAN_EXP = "not l1_flags.INVALID and dem_alt <= -50";
    private static final float SCALING_FACTOR = 1.0E-4f;
    private static final String PRESS_SCALE_HEIGHT_KEY = "press_scale_height";
    private static final int FLAG_CLOUDY = 1;
    private static final int FLAG_CLOUDFREE = 2;
    private static final int FLAG_UNCERTAIN = 4;
    private final String auxdataDir;
    private TiePointGrid szaGrid;
    private TiePointGrid saaGrid;
    private TiePointGrid vzaGrid;
    private TiePointGrid vaaGrid;
    private TiePointGrid pressGrid;
    private RasterDataNode altitude;
    private float[] centralWavelength;
    private CentralWavelengthProvider centralWavelengthProvider;
    private Term validLandTerm;
    private Term validOceanTerm;
    private String validLandExpression;
    private String validOceanExpression;
    private Term landTerm;
    private Logger logger;
    private Band cloudBand;
    private Band cloudFlagBand;
    private Band detectorBand;
    private Band[] radianceBands;
    private CloudAlgorithm landAlgo;
    private CloudAlgorithm oceanAlgo;
    private int pressScaleHeight;

    public CloudPN(String auxdataDir) {
        this.auxdataDir = auxdataDir;
        this.logger = BeamLogManager.getSystemLogger();
    }

    @Override
    public void setUp(Map config) throws IOException {
        File propertiesFile = new File(this.auxdataDir, (String)config.get(CONFIG_FILE_NAME));
        FileInputStream propertiesStream = new FileInputStream(propertiesFile);
        Properties properties = new Properties();
        properties.load(propertiesStream);
        this.landAlgo = new CloudAlgorithm(new File(this.auxdataDir), properties.getProperty("land"));
        this.oceanAlgo = new CloudAlgorithm(new File(this.auxdataDir), properties.getProperty("ocean"));
        this.pressScaleHeight = Integer.parseInt(properties.getProperty(PRESS_SCALE_HEIGHT_KEY));
        this.centralWavelengthProvider = new CentralWavelengthProvider();
        this.centralWavelengthProvider.readAuxData(new File(this.auxdataDir));
        this.validLandExpression = this.landAlgo.getValidExpression();
        if (this.validLandExpression.isEmpty()) {
            this.validLandExpression = DEFAULT_VALID_LAND_EXP;
        }
        this.validOceanExpression = this.oceanAlgo.getValidExpression();
        if (this.validOceanExpression.isEmpty()) {
            this.validOceanExpression = DEFAULT_VALID_OCEAN_EXP;
        }
    }

    @Override
    protected Product createTargetProductImpl() {
        Product l1Product = this.getSourceProduct();
        String[] radianceBandNames = EnvisatConstants.MERIS_L1B_SPECTRAL_BAND_NAMES;
        this.radianceBands = new Band[radianceBandNames.length];
        for (int bandIndex = 0; bandIndex < radianceBandNames.length; ++bandIndex) {
            String radianceBandName = radianceBandNames[bandIndex];
            this.radianceBands[bandIndex] = l1Product.getBand(radianceBandName);
            if (this.radianceBands[bandIndex] != null) continue;
            throw new IllegalArgumentException("Source product does not contain band " + radianceBandName);
        }
        this.detectorBand = l1Product.getBand("detector_index");
        if (this.detectorBand == null) {
            throw new IllegalArgumentException("Source product does not contain detector band.");
        }
        int sceneWidth = l1Product.getSceneRasterWidth();
        int sceneHeight = l1Product.getSceneRasterHeight();
        this.centralWavelength = this.centralWavelengthProvider.getCentralWavelength(l1Product.getProductType());
        Product outputProduct = new Product(DEFAULT_OUTPUT_PRODUCT_NAME, PRODUCT_TYPE, sceneWidth, sceneHeight);
        this.cloudBand = new Band(CLOUD_PROP_BAND, 11, sceneWidth, sceneHeight);
        this.cloudBand.setDescription("Probability of clouds");
        this.cloudBand.setScalingFactor((double)1.0E-4f);
        this.cloudBand.setNoDataValueUsed(true);
        this.cloudBand.setNoDataValue(-1.0);
        outputProduct.addBand(this.cloudBand);
        FlagCoding cloudFlagCoding = CloudPN.createCloudFlagCoding(outputProduct);
        outputProduct.getFlagCodingGroup().add((ProductNode)cloudFlagCoding);
        this.cloudFlagBand = new Band(CLOUD_FLAG_BAND, 20, sceneWidth, sceneHeight);
        this.cloudFlagBand.setDescription("Cloud specific flags");
        this.cloudFlagBand.setSampleCoding((SampleCoding)cloudFlagCoding);
        outputProduct.addBand(this.cloudFlagBand);
        this.logger.info("Output product successfully created");
        return outputProduct;
    }

    private static FlagCoding createCloudFlagCoding(Product outputProduct) {
        FlagCoding flagCoding = new FlagCoding(CLOUD_FLAG_BAND);
        flagCoding.setDescription("Cloud Flag Coding");
        MetadataAttribute cloudAttr = new MetadataAttribute("cloudy", 20);
        cloudAttr.getData().setElemInt(1);
        cloudAttr.setDescription("is with more than 80% cloudy");
        flagCoding.addAttribute(cloudAttr);
        outputProduct.addMask(cloudAttr.getName(), flagCoding.getName() + "." + cloudAttr.getName(), cloudAttr.getDescription(), CloudPN.createBitmaskColor(1, 3), 0.5);
        cloudAttr = new MetadataAttribute("cloudfree", 20);
        cloudAttr.getData().setElemInt(2);
        cloudAttr.setDescription("is with less than 20% cloudy");
        flagCoding.addAttribute(cloudAttr);
        outputProduct.addMask(cloudAttr.getName(), flagCoding.getName() + "." + cloudAttr.getName(), cloudAttr.getDescription(), CloudPN.createBitmaskColor(2, 3), 0.5);
        cloudAttr = new MetadataAttribute("cloud_uncertain", 20);
        cloudAttr.getData().setElemInt(4);
        cloudAttr.setDescription("is with between 20% and 80% cloudy");
        flagCoding.addAttribute(cloudAttr);
        outputProduct.addMask(cloudAttr.getName(), flagCoding.getName() + "." + cloudAttr.getName(), cloudAttr.getDescription(), CloudPN.createBitmaskColor(3, 3), 0.5);
        return flagCoding;
    }

    private static Color createBitmaskColor(int index, int maxIndex) {
        double rf1 = 0.0;
        double gf1 = 0.5;
        double bf1 = 1.0;
        double a = Math.PI * 2 * (double)index / (double)maxIndex;
        return new Color((float)(0.5 + 0.5 * Math.sin(a + 0.0)), (float)(0.5 + 0.5 * Math.sin(a + 1.5707963267948966)), (float)(0.5 + 0.5 * Math.sin(a + Math.PI)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFrame(int frameX, int frameY, int frameW, int frameH, ProgressMonitor pm) throws IOException {
        int frameSize = frameW * frameH;
        int numBands = this.radianceBands.length;
        double[] cloudIn = new double[15];
        float[] szaScanLine = new float[frameSize];
        float[] saaScanLine = new float[frameSize];
        float[] vzaScanLine = new float[frameSize];
        float[] vaaScanLine = new float[frameSize];
        float[] pressScanLine = new float[frameSize];
        float[] altitudeScanLine = new float[frameSize];
        int[] detectorScanLine = new int[frameSize];
        float[][] radianceScanLine = new float[numBands][frameSize];
        boolean[] validLandScanLine = new boolean[frameSize];
        boolean[] validOceanScanLine = new boolean[frameSize];
        boolean[] landScanLine = new boolean[frameSize];
        pm.beginTask("Processing frame...", 10 + frameSize);
        try {
            this.szaGrid.readPixels(frameX, frameY, frameW, frameH, szaScanLine, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            this.saaGrid.readPixels(frameX, frameY, frameW, frameH, saaScanLine, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            this.vzaGrid.readPixels(frameX, frameY, frameW, frameH, vzaScanLine, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            this.vaaGrid.readPixels(frameX, frameY, frameW, frameH, vaaScanLine, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            this.pressGrid.readPixels(frameX, frameY, frameW, frameH, pressScanLine, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            this.altitude.readPixels(frameX, frameY, frameW, frameH, altitudeScanLine, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            ProgressMonitor subPM = SubProgressMonitor.create((ProgressMonitor)pm, (int)1);
            try {
                subPM.beginTask("Reading radiance bands...", this.radianceBands.length);
                for (int i = 0; i < this.radianceBands.length; ++i) {
                    Band radianceBand = this.radianceBands[i];
                    radianceBand.readPixels(frameX, frameY, frameW, frameH, radianceScanLine[i], SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                }
            }
            finally {
                subPM.done();
            }
            this.detectorBand.readPixels(frameX, frameY, frameW, frameH, detectorScanLine, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            this.getSourceProduct().readBitmask(frameX, frameY, frameW, frameH, this.validLandTerm, validLandScanLine, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            this.getSourceProduct().readBitmask(frameX, frameY, frameW, frameH, this.validOceanTerm, validOceanScanLine, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            this.getSourceProduct().readBitmask(frameX, frameY, frameW, frameH, this.landTerm, landScanLine, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            ProductData data = this.getFrameData(this.cloudBand);
            short[] cloudScanLine = (short[])data.getElems();
            ProductData flagData = this.getFrameData(this.cloudFlagBand);
            byte[] flagScanLine = (byte[])flagData.getElems();
            for (int i = 0; i < frameSize; ++i) {
                if (pm.isCanceled()) {
                    break;
                }
                flagScanLine[i] = 0;
                if (!validLandScanLine[i] && !validOceanScanLine[i]) {
                    cloudScanLine[i] = -1;
                } else {
                    double aziDiff = CloudPN.computeAda(vaaScanLine[i], saaScanLine[i]) * (Math.PI / 180);
                    cloudIn[0] = this.calculateI(radianceScanLine[0][i], this.radianceBands[0].getSolarFlux(), szaScanLine[i]);
                    cloudIn[1] = this.calculateI(radianceScanLine[1][i], this.radianceBands[1].getSolarFlux(), szaScanLine[i]);
                    cloudIn[2] = this.calculateI(radianceScanLine[2][i], this.radianceBands[2].getSolarFlux(), szaScanLine[i]);
                    cloudIn[3] = this.calculateI(radianceScanLine[3][i], this.radianceBands[3].getSolarFlux(), szaScanLine[i]);
                    cloudIn[4] = this.calculateI(radianceScanLine[4][i], this.radianceBands[4].getSolarFlux(), szaScanLine[i]);
                    cloudIn[5] = this.calculateI(radianceScanLine[5][i], this.radianceBands[5].getSolarFlux(), szaScanLine[i]);
                    cloudIn[6] = this.calculateI(radianceScanLine[8][i], this.radianceBands[8].getSolarFlux(), szaScanLine[i]);
                    cloudIn[7] = this.calculateI(radianceScanLine[9][i], this.radianceBands[9].getSolarFlux(), szaScanLine[i]);
                    cloudIn[8] = this.calculateI(radianceScanLine[12][i], this.radianceBands[12].getSolarFlux(), szaScanLine[i]);
                    cloudIn[9] = radianceScanLine[10][i] * this.radianceBands[9].getSolarFlux() / (radianceScanLine[9][i] * this.radianceBands[10].getSolarFlux());
                    cloudIn[10] = this.altitudeCorrectedPressure(pressScanLine[i], altitudeScanLine[i], landScanLine[i]);
                    cloudIn[11] = this.centralWavelength[detectorScanLine[i]];
                    cloudIn[12] = Math.cos((double)szaScanLine[i] * (Math.PI / 180));
                    cloudIn[13] = Math.cos((double)vzaScanLine[i] * (Math.PI / 180));
                    cloudIn[14] = Math.cos(aziDiff) * Math.sin((double)vzaScanLine[i] * (Math.PI / 180));
                    double cloudProbability = 0.0;
                    if (validLandScanLine[i]) {
                        cloudProbability = this.landAlgo.computeCloudProbability(cloudIn);
                    } else if (validOceanScanLine[i]) {
                        cloudProbability = this.oceanAlgo.computeCloudProbability(cloudIn);
                    }
                    short cloudProbabilityScaled = (short)(cloudProbability / (double)1.0E-4f);
                    if (cloudProbabilityScaled > 8000) {
                        flagScanLine[i] = 1;
                    } else if (cloudProbabilityScaled < 2000) {
                        flagScanLine[i] = 2;
                    } else if (cloudProbabilityScaled >= 2000 && cloudProbabilityScaled <= 8000) {
                        flagScanLine[i] = 4;
                    }
                    cloudScanLine[i] = cloudProbabilityScaled;
                }
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    protected double calculateI(double radiance, float sunSpectralFlux, double sunZenith) {
        return radiance / ((double)sunSpectralFlux * Math.cos(sunZenith * (Math.PI / 180)));
    }

    protected double altitudeCorrectedPressure(double pressure, double altitude, boolean isLand) {
        double correctedPressure;
        if (isLand) {
            double f = Math.exp(-Math.max(0.0, altitude) / (double)this.pressScaleHeight);
            correctedPressure = pressure * f;
        } else {
            correctedPressure = pressure;
        }
        return correctedPressure;
    }

    private static double computeAda(double vaa, double saa) {
        double ada = vaa - saa;
        if (ada <= -180.0) {
            ada = 360.0 + ada;
        } else if (ada > 180.0) {
            ada = -360.0 + ada;
        }
        ada = ada >= 0.0 ? 180.0 - ada : -180.0 - ada;
        return ada;
    }

    @Override
    public void startProcessing() throws ParseException {
        Product l1bProduct = this.getSourceProduct();
        this.szaGrid = l1bProduct.getTiePointGrid("sun_zenith");
        this.saaGrid = l1bProduct.getTiePointGrid("sun_azimuth");
        this.vzaGrid = l1bProduct.getTiePointGrid("view_zenith");
        this.vaaGrid = l1bProduct.getTiePointGrid("view_azimuth");
        this.pressGrid = l1bProduct.getTiePointGrid("atm_press");
        this.altitude = l1bProduct.getBand("altitude");
        if (this.altitude == null) {
            this.altitude = l1bProduct.getTiePointGrid("dem_alt");
        }
        this.validLandTerm = l1bProduct.parseExpression(this.validLandExpression);
        this.validOceanTerm = l1bProduct.parseExpression(this.validOceanExpression);
        this.landTerm = l1bProduct.parseExpression("l1_flags.LAND_OCEAN");
    }
}

