/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff.level2;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.esa.s3tbx.dataio.landsat.geotiff.level2.LandsatLevel2Metadata;
import org.esa.s3tbx.dataio.landsat.metadata.XmlMetadataParser;
import org.esa.s3tbx.dataio.landsat.metadata.XmlMetadataParserFactory;
import org.esa.snap.core.datamodel.FlagCoding;
import org.geotools.graph.util.geom.Coordinate2D;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LandsatLevel2MetadataTest {
    private LandsatLevel2Metadata metadata;

    @Before
    public void setUp() throws Exception {
        String pathString = this.getClass().getResource("LC08_L1TP_024036_20181011_20181011_01_RT.xml").getFile();
        XmlMetadataParserFactory.registerParser(LandsatLevel2Metadata.class, (XmlMetadataParser)new XmlMetadataParser(LandsatLevel2Metadata.class));
        FileInputStream metadataInputStream = new FileInputStream(pathString);
        if (metadataInputStream == null) {
            throw new IOException(String.format("Unable to read metadata file from product", new Object[0]));
        }
        try {
            this.metadata = (LandsatLevel2Metadata)XmlMetadataParserFactory.getParser(LandsatLevel2Metadata.class).parse((InputStream)metadataInputStream);
        }
        catch (Exception e) {
            throw new IOException(String.format("Unable to parse metadata file", new Object[0]));
        }
    }

    @Test
    public void testProductName() throws Exception {
        String name = this.metadata.getProductName();
        Assert.assertEquals((Object)name, (Object)"LC08_L1TP_024036_20181011_20181011_01_RT - Level 2");
    }

    @Test
    public void testRasterFileNames() throws Exception {
        String[] name = this.metadata.getRasterFileNames();
        Assert.assertEquals((long)name.length, (long)10L);
    }

    @Test
    public void testHeightAndWidth() throws Exception {
        int width = this.metadata.getRasterWidth();
        int height = this.metadata.getRasterHeight();
        Assert.assertEquals((long)height, (long)7781L);
        Assert.assertEquals((long)width, (long)7641L);
    }

    @Test
    public void testUpperLeft() throws Exception {
        Coordinate2D upperLeft = this.metadata.getUpperLeft();
        Assert.assertNotNull((Object)upperLeft);
        Assert.assertEquals((double)upperLeft.x, (double)473400.0, (double)0.1);
        Assert.assertEquals((double)upperLeft.y, (double)3946500.0, (double)0.1);
    }

    @Test
    public void testSaturationFlags() throws Exception {
        FlagCoding flagCoding = this.metadata.createSaturationFlagCoding("LC08_L1TP_024036_20181011_20181011_01_RT_radsat_qa.tif");
        Assert.assertNotNull((Object)flagCoding);
    }

    @Test
    public void testWavelength() throws Exception {
        Float wavelength = Float.valueOf(this.metadata.getWavelength("LC08_L1TP_024036_20181011_20181011_01_RT_sr_band3.tif"));
        Assert.assertEquals((double)560.0, (double)wavelength.floatValue(), (double)1.0E-6);
    }
}

