/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff;

import org.esa.s3tbx.dataio.landsat.geotiff.LandsatTypeInfo;
import org.junit.Assert;
import org.junit.Test;

public class LandsatTypeInfoTest {
    @Test
    public void testIsLandsat() throws Exception {
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat((String)"LE07_L1TP_016039_20040918_20160211_01_T1_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat((String)"LM11870291976166ESA00_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat((String)"LT40140341983030XXX13_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat((String)"LT41730601990155XXX01.tar.bz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat((String)"LT51231232013068GSI01_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat((String)"LT51940252011320KIS00.tar.gz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat((String)"LE71890342011277ASN00_MTL.TXT"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat((String)"LE71890342011277ASN00.tar.gz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat((String)"LO82160332013191LGN00.tar.gz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat((String)"LT82270322013068LGN01_MTL.TXT"));
    }

    @Test
    public void testIsLandsatCollectionFilename() throws Exception {
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsatCollection((String)"LE07_L1TP_016039_20040918_20160211_01_T1_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsatCollection((String)"LT04_L1GS_017036_19821115_20160315_01_T2_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsatCollection((String)"LE07_L1GT_037035_20160314_20160314_01_RT_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsatCollection((String)"LT05_L1TP_202026_20031017_20161203_01_T1_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsatCollection((String)"LC08_L1TP_194028_20160622_20170323_01_T1_MTL.txt"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsatCollection((String)"LT82270322013068LGN01_MTL.txt"));
    }

    @Test
    public void testIsESALandsatCollection() throws Exception {
        Assert.assertTrue((boolean)LandsatTypeInfo.isESALandsatCollection((String)"LC08_L1TP_201040_20181019_20181019_01_RT_MTI_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isESALandsatCollection((String)"LC08_L1GT_209019_20180504_20180504_01_RT_KIS_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isESALandsatCollection((String)"LC08_L1TP_204030_20180226_20180226_01_RT_MTI_MTL.txt"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isESALandsatCollection((String)"LC08_L1TP_194028_20160622_20170323_01_T1_MTL.txt"));
    }

    @Test
    public void testIsLandsatMSSFilename() throws Exception {
        Assert.assertTrue((boolean)LandsatTypeInfo.isMss((String)"LM11870291976166ESA00_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isMss((String)"LM32170241982254XXX01_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isMss((String)"LM42310081982267ESA00_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isMss((String)"LM52010241984295AAA03_MTL.txt"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isMss((String)"LT40140341983030XXX13_MTL.txt"));
    }

    @Test
    public void testIsLandsat4Filename() throws Exception {
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat4((String)"LT40140341983030XXX13_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat4((String)"LT40140341982315PAC00_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat4((String)"LT41160361989137XXX02_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat4((String)"LT41730601990155XXX01.tar.bz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat4((String)"LT41930241992221XXX02.tar.gz"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat4((String)"LT40140341982315PAC00_B1.TIF"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat4((String)"LT51920342011274MPS00.tgz"));
    }

    @Test
    public void testIsLandsat5Filename() throws Exception {
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat5((String)"LT51231232013068GSI01_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat5((String)"LT51231232013068GSI01_MTL.TXT"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat5((String)"LT51920342011274MPS00.tar.gz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat5((String)"LT51920342011274MPS00.tgz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat5((String)"LT51700572011312MLK00.tar.bz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat5((String)"LT51940252011320KIS00.tar.gz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat5((String)"LT51970241984299FUI00.ZIP"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat5((String)"LT51231232013068GSI01_B3.txt"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat5((String)"L5196030_03020031023_MTL.txt"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat5((String)"LT71920342011274MPS00.tar.gz"));
    }

    @Test
    public void testIsLandsat7Filename() throws Exception {
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat7((String)"LE71890342011277ASN00_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat7((String)"LE71890342011277ASN00_MTL.TXT"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat7((String)"LE71890342011277ASN00.tar.gz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat7((String)"LE71890342011277ASN00.tgz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat7((String)"LE71710602000329EDC00.tar.bz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat7((String)"LE71920252000332NSG00.ZIP"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat7((String)"LE71940272000330EDC00.tar.gz"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat7((String)"LE71890342011277ASN00_B3.txt"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat7((String)"L71890342011277ASN00.txt"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat7((String)"LE81890342011277ASN00_MTL.txt"));
    }

    @Test
    public void testIsLandsat8Filename() throws Exception {
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat8((String)"LT82270322013068LGN01_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat8((String)"LT82270322013068LGN01_MTL.TXT"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat8((String)"LC82160332013191LGN00.tar.gz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat8((String)"LO82160332013191LGN00.tar.gz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat8((String)"LT82160332013191LGN00.tar.gz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat8((String)"LT82160332013191LGN00.tgz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat8((String)"LC81970232013266LGN00.tar.bz"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat8((String)"L8196030_03020031023_MTL.txt"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat8((String)"LT52160332013191LGN00.tar.gz"));
    }

    @Test
    public void testIsLandsat5LegacyFilename() throws Exception {
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat5Legacy((String)"LT51960300302003GSI01_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat5Legacy((String)"LT51960300302003GSI01_MTL.TXT"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat5Legacy((String)"L5196030_03020031023_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat5Legacy((String)"L5196030_03020031023_MTL.TXT"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat5Legacy((String)"LT51960302003296MTI01.tar.gz"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat5Legacy((String)"L51950302003257MTI01.tar.gz"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat5Legacy((String)"LT72160332013191LGN00.tar.gz"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat5Legacy((String)"LT82160332013191LGN00.tgz"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat5Legacy((String)"LT82160332013191LGN00.dat"));
    }

    @Test
    public void testIsLandsat7LegacyFilename() throws Exception {
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat7Legacy((String)"LE71960300302003GSI01_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat7Legacy((String)"LE71960300302003GSI01_MTL.TXT"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat7Legacy((String)"L71196030_03020031023_MTL.txt"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat7Legacy((String)"L71196030_03020031023_MTL.TXT"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat7Legacy((String)"LE71960302003296ASN01.tar.gz"));
        Assert.assertTrue((boolean)LandsatTypeInfo.isLandsat7Legacy((String)"LE72160332013191LGN00.tgz"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat7Legacy((String)"L71950302003257MTI01.tar.gz"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat7Legacy((String)"LE52160332013191LGN00.tar.gz"));
        Assert.assertFalse((boolean)LandsatTypeInfo.isLandsat7Legacy((String)"LE72160332013191LGN00.dat"));
    }
}

