/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.geotiff;

import java.io.File;
import java.io.InputStream;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatGeotiffReader;
import org.esa.s3tbx.dataio.landsat.geotiff.LandsatGeotiffReaderPlugin;
import org.esa.snap.core.dataio.ProductReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LandsatGeotiffReaderPluginTest {
    private LandsatGeotiffReaderPlugin plugin;

    @Before
    public void setUp() throws Exception {
        this.plugin = new LandsatGeotiffReaderPlugin();
    }

    @Test
    public void testGetInputTypes() throws Exception {
        Assert.assertArrayEquals((Object[])new Class[]{String.class, File.class}, (Object[])this.plugin.getInputTypes());
    }

    @Test
    public void testCreateReaderInstance() throws Exception {
        ProductReader productReader = this.plugin.createReaderInstance();
        Assert.assertNotNull((Object)productReader);
        Assert.assertTrue((boolean)(productReader instanceof LandsatGeotiffReader));
    }

    @Test
    public void testGetFormatNames() throws Exception {
        Assert.assertArrayEquals((Object[])new String[]{"LandsatGeoTIFF"}, (Object[])this.plugin.getFormatNames());
    }

    @Test
    public void testGetDefaultFileExtensions() throws Exception {
        Assert.assertArrayEquals((Object[])new String[]{".txt", ".TXT", ".gz", ".tgz"}, (Object[])this.plugin.getDefaultFileExtensions());
    }

    @Test
    public void testGetDescription() throws Exception {
        Assert.assertEquals((Object)"Landsat Data Products (GeoTIFF)", (Object)this.plugin.getDescription(null));
    }

    @Test
    public void testGetProductFileFilter() throws Exception {
        Assert.assertNotNull((Object)this.plugin.getProductFileFilter());
    }

    @Test
    public void testIsMetadataFilename() throws Exception {
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isMetadataFilename((String)"test_L8_MTL.txt"));
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isMetadataFilename((String)"test_legacy_L5_WithTrailingWhiteSpace_MTL.txt"));
        Assert.assertFalse((boolean)LandsatGeotiffReaderPlugin.isMetadataFilename((String)"test_MTL_L7.txt"));
    }

    @Test
    public void testIsMetadataFile() throws Exception {
        InputStream positiveFile1 = this.getClass().getResourceAsStream("test_L8_MTL.txt");
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isMetadataFile((InputStream)positiveFile1));
        InputStream positiveFile2 = this.getClass().getResourceAsStream("test_legacy_L5_WithTrailingWhiteSpace_MTL.txt");
        Assert.assertTrue((boolean)LandsatGeotiffReaderPlugin.isMetadataFile((InputStream)positiveFile2));
    }
}

