/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.landsat.tgz;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.esa.s3tbx.dataio.landsat.TestUtil;
import org.esa.s3tbx.dataio.landsat.tgz.VirtualDirTgz;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class VirtualDirTgzTest {
    private VirtualDirTgz virtualDir;

    @Test
    public void testOpenTgz() throws IOException {
        File testTgz = TestUtil.getTestFile("tgz/test-archive.tgz");
        this.virtualDir = new VirtualDirTgz(testTgz);
        Assert.assertEquals((Object)testTgz.getPath(), (Object)this.virtualDir.getBasePath());
        Assert.assertTrue((boolean)this.virtualDir.isCompressed());
        Assert.assertTrue((boolean)this.virtualDir.isArchive());
    }

    @Test
    public void testOpenTar() throws IOException {
        File testTar = TestUtil.getTestFile("tgz/test-archive.tar");
        this.virtualDir = new VirtualDirTgz(testTar);
        Assert.assertEquals((Object)testTar.getPath(), (Object)this.virtualDir.getBasePath());
        Assert.assertFalse((boolean)this.virtualDir.isCompressed());
        Assert.assertTrue((boolean)this.virtualDir.isArchive());
    }

    @Test
    public void testOpenNull() throws IOException {
        try {
            VirtualDirTgz vdTgz = new VirtualDirTgz(null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTar_getInputStream() throws IOException {
        File testTgz = TestUtil.getTestFile("tgz/test-archive.tar");
        this.virtualDir = new VirtualDirTgz(testTgz);
        this.assertExpectedInputStream();
    }

    @Test
    public void testTgz_getInputStream() throws IOException {
        File testTgz = TestUtil.getTestFile("tgz/test-archive.tgz");
        this.virtualDir = new VirtualDirTgz(testTgz);
        this.assertExpectedInputStream();
    }

    @Test
    public void testTar_getInputStream_invalidPath() throws IOException {
        File testTgz = TestUtil.getTestFile("tgz/test-archive.tar");
        this.virtualDir = new VirtualDirTgz(testTgz);
        this.assertInputStreamInvalidPath();
    }

    @Test
    public void testTgz_getInputStream_invalidPath() throws IOException {
        File testTgz = TestUtil.getTestFile("tgz/test-archive.tgz");
        this.virtualDir = new VirtualDirTgz(testTgz);
        this.assertInputStreamInvalidPath();
    }

    @Test
    public void testTar_getFile() throws IOException {
        File testTgz = TestUtil.getTestFile("tgz/test-archive.tar");
        this.virtualDir = new VirtualDirTgz(testTgz);
        this.assertExpectedFile();
    }

    @Test
    public void testTgz_getFile() throws IOException {
        File testTgz = TestUtil.getTestFile("tgz/test-archive.tgz");
        this.virtualDir = new VirtualDirTgz(testTgz);
        this.assertExpectedFile();
    }

    @Test
    public void testTar_noDirInTar_getFile() throws IOException {
        File testTgz = TestUtil.getTestFile("tgz/test-archive_wo_dir.tar");
        this.virtualDir = new VirtualDirTgz(testTgz);
        File file_1 = this.virtualDir.getFile("file1.txt");
        Assert.assertNotNull((Object)file_1);
    }

    @Test
    public void testTar_getFile_invalidPath() throws IOException {
        File testTgz = TestUtil.getTestFile("tgz/test-archive.tar");
        this.virtualDir = new VirtualDirTgz(testTgz);
        this.assertGetFileInvalidPath();
    }

    @Test
    public void testTgz_getFile_invalidPath() throws IOException {
        File testTgz = TestUtil.getTestFile("tgz/test-archive.tgz");
        this.virtualDir = new VirtualDirTgz(testTgz);
        this.assertGetFileInvalidPath();
    }

    @Test
    public void testTar_list() throws IOException {
        File testTgz = TestUtil.getTestFile("tgz/test-archive.tar");
        this.virtualDir = new VirtualDirTgz(testTgz);
        this.assertCorrectList();
    }

    @Test
    public void testTgz_list() throws IOException {
        File testTgz = TestUtil.getTestFile("tgz/test-archive.tgz");
        this.virtualDir = new VirtualDirTgz(testTgz);
        this.assertCorrectList();
    }

    @Test
    public void testTar_list_invalidPath() throws IOException {
        File testTgz = TestUtil.getTestFile("tgz/test-archive.tar");
        this.virtualDir = new VirtualDirTgz(testTgz);
        this.assertListInvalidPath();
    }

    @Test
    public void testTgz_list_invalidPath() throws IOException {
        File testTgz = TestUtil.getTestFile("tgz/test-archive.tgz");
        this.virtualDir = new VirtualDirTgz(testTgz);
        this.assertListInvalidPath();
    }

    @Test
    public void testFinalize() throws Throwable {
        File testTgz = TestUtil.getTestFile("tgz/test-archive.tgz");
        this.virtualDir = new VirtualDirTgz(testTgz);
        this.assertExpectedFile();
        File tempDir = this.virtualDir.getTempDir();
        Assert.assertNotNull((Object)tempDir);
        Assert.assertTrue((boolean)tempDir.isDirectory());
        this.virtualDir.finalize();
        Assert.assertFalse((boolean)tempDir.isDirectory());
    }

    @Test
    public void testGetFilenameFromPath_Windows() {
        String fullPath = "C:\\bla\\blubber\\theFile.txt";
        Assert.assertEquals((Object)"theFile.txt", (Object)VirtualDirTgz.getFilenameFromPath((String)"C:\\bla\\blubber\\theFile.txt"));
        String relativePath = "bla\\schnuffi\\schnatter.txt";
        Assert.assertEquals((Object)"schnatter.txt", (Object)VirtualDirTgz.getFilenameFromPath((String)"bla\\schnuffi\\schnatter.txt"));
    }

    @Test
    public void testGetFilenameFromPath_Linux() {
        String fullPath = "/bla/blubber/theFile.txt";
        Assert.assertEquals((Object)"theFile.txt", (Object)VirtualDirTgz.getFilenameFromPath((String)"/bla/blubber/theFile.txt"));
        String relativePath = "bla/schnuffi/schnatter.txt";
        Assert.assertEquals((Object)"schnatter.txt", (Object)VirtualDirTgz.getFilenameFromPath((String)"bla/schnuffi/schnatter.txt"));
    }

    @Test
    public void testGetFilenameFromPath_notAPath() {
        String file = "theFile.txt";
        Assert.assertEquals((Object)"theFile.txt", (Object)VirtualDirTgz.getFilenameFromPath((String)"theFile.txt"));
    }

    @Test
    public void testIsTgz() {
        Assert.assertTrue((boolean)VirtualDirTgz.isTgz((String)"test_archive.tar.gz"));
        Assert.assertTrue((boolean)VirtualDirTgz.isTgz((String)"test_archive.tgz"));
        Assert.assertFalse((boolean)VirtualDirTgz.isTgz((String)"test_archive.tar"));
        Assert.assertFalse((boolean)VirtualDirTgz.isTgz((String)"test_archive.exe"));
        Assert.assertFalse((boolean)VirtualDirTgz.isTgz((String)"test_archive"));
    }

    @After
    public void tearDown() {
        if (this.virtualDir != null) {
            this.virtualDir.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertExpectedInputStream() throws IOException {
        try (InputStream inputStream = this.virtualDir.getInputStream("test-archive/file2.txt");){
            Assert.assertNotNull((Object)inputStream);
            byte[] buffer = new byte[512];
            int bytesRead = inputStream.read(buffer);
            Assert.assertEquals((long)9L, (long)bytesRead);
            Assert.assertEquals((Object)"content2", (Object)new String(buffer).trim());
        }
    }

    private void assertInputStreamInvalidPath() {
        try {
            this.virtualDir.getInputStream("test-archive/invalid_dir/no.file");
            Assert.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertExpectedFile() throws IOException {
        File file = this.virtualDir.getFile("test-archive/dir1/file3.txt");
        Assert.assertNotNull((Object)file);
        Assert.assertTrue((boolean)file.isFile());
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] buffer = new byte[512];
            int bytesRead = inputStream.read(buffer);
            Assert.assertEquals((long)9L, (long)bytesRead);
            Assert.assertEquals((Object)"content3", (Object)new String(buffer).trim());
        }
    }

    private void assertGetFileInvalidPath() {
        try {
            this.virtualDir.getFile("test-archive/invalid_dir/missing.file");
            Assert.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void assertCorrectList() throws IOException {
        String[] list = this.virtualDir.list("");
        List<String> dirList = Arrays.asList(list);
        Assert.assertEquals((long)1L, (long)dirList.size());
        Assert.assertTrue((boolean)dirList.contains("test-archive"));
        list = this.virtualDir.list("test-archive");
        dirList = Arrays.asList(list);
        Assert.assertEquals((long)3L, (long)dirList.size());
        Assert.assertTrue((boolean)dirList.contains("dir1"));
        Assert.assertTrue((boolean)dirList.contains("file1.txt"));
        Assert.assertTrue((boolean)dirList.contains("file2.txt"));
        list = this.virtualDir.list("test-archive/dir1");
        dirList = Arrays.asList(list);
        Assert.assertEquals((long)1L, (long)dirList.size());
        Assert.assertTrue((boolean)dirList.contains("file3.txt"));
    }

    private void assertListInvalidPath() {
        try {
            this.virtualDir.list("in/valid/path");
            Assert.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

