/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat.geotiff;

import com.bc.ceres.core.VirtualDir;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import org.esa.beam.dataio.landsat.geotiff.LandsatGeotiffReader;
import org.esa.beam.dataio.landsat.tgz.VirtualDirTgz;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.io.BeamFileFilter;
import org.esa.beam.util.io.FileUtils;

public class LandsatGeotiffReaderPlugin
implements ProductReaderPlugIn {
    private static final Class[] READER_INPUT_TYPES = new Class[]{String.class, File.class};
    private static final String[] FORMAT_NAMES = new String[]{"LandsatGeoTIFF"};
    private static final String[] DEFAULT_FILE_EXTENSIONS = new String[]{".txt", ".TXT", ".gz"};
    private static final String READER_DESCRIPTION = "Landsat Data Products (GeoTIFF)";

    public DecodeQualification getDecodeQualification(Object input) {
        String[] list;
        VirtualDir virtualDir;
        String filename = new File(input.toString()).getName();
        if (!(LandsatGeotiffReaderPlugin.isLandsatMSSFilename(filename) || LandsatGeotiffReaderPlugin.isLandsat4Filename(filename) || LandsatGeotiffReaderPlugin.isLandsat5Filename(filename) || LandsatGeotiffReaderPlugin.isLandsat7Filename(filename) || LandsatGeotiffReaderPlugin.isLandsat8Filename(filename) || LandsatGeotiffReaderPlugin.isLandsat5LegacyFilename(filename) || LandsatGeotiffReaderPlugin.isLandsat7LegacyFilename(filename))) {
            return DecodeQualification.UNABLE;
        }
        try {
            virtualDir = LandsatGeotiffReaderPlugin.getInput(input);
        }
        catch (IOException e) {
            return DecodeQualification.UNABLE;
        }
        if (virtualDir == null) {
            return DecodeQualification.UNABLE;
        }
        try {
            list = virtualDir.list("");
            if (list == null || list.length == 0) {
                return DecodeQualification.UNABLE;
            }
        }
        catch (IOException e) {
            return DecodeQualification.UNABLE;
        }
        for (String fileName : list) {
            try {
                File file = virtualDir.getFile(fileName);
                if (!LandsatGeotiffReaderPlugin.isMetadataFile(file)) continue;
                return DecodeQualification.INTENDED;
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        return DecodeQualification.UNABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isMetadataFile(File file) {
        String line;
        if (!file.getName().toLowerCase().endsWith("_mtl.txt")) {
            return false;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            line = reader.readLine();
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {}
            }
        }
        return line != null && line.trim().matches("GROUP = L1_METADATA_FILE");
    }

    public Class[] getInputTypes() {
        return READER_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new LandsatGeotiffReader(this);
    }

    public String[] getFormatNames() {
        return FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        return DEFAULT_FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return READER_DESCRIPTION;
    }

    public BeamFileFilter getProductFileFilter() {
        return new BeamFileFilter(FORMAT_NAMES[0], DEFAULT_FILE_EXTENSIONS, READER_DESCRIPTION);
    }

    static VirtualDir getInput(Object input) throws IOException {
        File absoluteFile;
        File inputFile = LandsatGeotiffReaderPlugin.getFileInput(input);
        if (inputFile.isFile() && !LandsatGeotiffReaderPlugin.isCompressedFile(inputFile) && (inputFile = (absoluteFile = inputFile.getAbsoluteFile()).getParentFile()) == null) {
            throw new IOException("Unable to retrieve parent to file: " + absoluteFile.getAbsolutePath());
        }
        VirtualDir virtualDir = VirtualDir.create((File)inputFile);
        if (virtualDir == null) {
            virtualDir = new VirtualDirTgz(inputFile);
        }
        return virtualDir;
    }

    static File getFileInput(Object input) {
        if (input instanceof String) {
            return new File((String)input);
        }
        if (input instanceof File) {
            return (File)input;
        }
        return null;
    }

    static boolean isLandsatMSSFilename(String filename) {
        return filename.matches("LM[1-5]\\d{13}\\w{3}\\d{2}_MTL.(txt|TXT)");
    }

    static boolean isLandsat4Filename(String filename) {
        if (filename.matches("LT4\\d{13}\\w{3}\\d{2}_MTL.(txt|TXT)")) {
            return true;
        }
        return filename.matches("LT4\\d{13}\\w{3}\\d{2}\\.tar\\.gz");
    }

    static boolean isLandsat5Filename(String filename) {
        if (filename.matches("LT5\\d{13}.{3}\\d{2}_MTL.(txt|TXT)")) {
            return true;
        }
        return filename.matches("LT5\\d{13}.{3}\\d{2}\\.tar\\.gz");
    }

    static boolean isLandsat7Filename(String filename) {
        if (filename.matches("LE7\\d{13}.{3}\\d{2}_MTL.(txt|TXT)")) {
            return true;
        }
        return filename.matches("LE7\\d{13}.{3}\\d{2}\\.tar\\.gz");
    }

    static boolean isLandsat8Filename(String filename) {
        if (filename.matches("L[O,T,C]8\\d{13}.{3}\\d{2}_MTL.(txt|TXT)")) {
            return true;
        }
        return filename.matches("L[O,T,C]8\\d{13}.{3}\\d{2}\\.tar\\.gz");
    }

    static boolean isLandsat5LegacyFilename(String filename) {
        if (filename.matches("LT5\\d{13}.{3}\\d{2}_MTL.(txt|TXT)")) {
            return true;
        }
        if (filename.matches("L5\\d{6}_\\d{11}_MTL.(txt|TXT)")) {
            return true;
        }
        return filename.matches("LT5\\d{13}.{3}\\d{2}\\.tar\\.gz");
    }

    static boolean isLandsat7LegacyFilename(String filename) {
        if (filename.matches("LE7\\d{13}.{3}\\d{2}_MTL.(txt|TXT)")) {
            return true;
        }
        if (filename.matches("L7\\d{7}_\\d{11}_MTL.(txt|TXT)")) {
            return true;
        }
        return filename.matches("LE7\\d{13}.{3}\\d{2}\\.tar\\.gz");
    }

    static boolean isCompressedFile(File file) {
        String extension = FileUtils.getExtension((File)file);
        if (StringUtils.isNullOrEmpty((String)extension)) {
            return false;
        }
        return (extension = extension.toLowerCase()).contains("zip") || extension.contains("tar") || extension.contains("tgz") || extension.contains("gz");
    }
}

