/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat.geotiff;

import java.awt.Dimension;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import org.esa.beam.dataio.landsat.geotiff.AbstractLandsatMetadata;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.ProductData;

class Landsat8Metadata
extends AbstractLandsatMetadata {
    private static final String[] BAND_DESCRIPTIONS = new String[]{"Coastal Aerosol (Operational Land Imager (OLI))", "Blue (OLI)", "Green (OLI)", "Red (OLI)", "Near-Infrared (NIR) (OLI)", "Short Wavelength Infrared (SWIR) 1 (OLI)", "SWIR 2 (OLI)", "Panchromatic (OLI)", "Cirrus (OLI)", "Thermal Infrared Sensor (TIRS) 1", "TIRS 2"};
    private static final float[] WAVELENGTHS = new float[]{440.0f, 480.0f, 560.0f, 655.0f, 865.0f, 1610.0f, 2200.0f, 590.0f, 1370.0f, 10895.0f, 12005.0f};
    private static final String[] BAND_NAMES = new String[]{"coastal_aerosol", "blue", "green", "red", "near_infrared", "swir_1", "swir_2", "panchromatic", "cirrus", "thermal_infrared_(tirs)_1", "thermal_infrared_(tirs)_2"};
    private static final float[] BANDWIDTHS = new float[]{20.0f, 60.0f, 60.0f, 30.0f, 30.0f, 80.0f, 180.0f, 180.0f, 20.0f, 590.0f, 1010.0f};

    public Landsat8Metadata(Reader fileReader) throws IOException {
        super(fileReader);
    }

    public Landsat8Metadata(MetadataElement root) throws IOException {
        super(root);
    }

    @Override
    public MetadataElement getProductMetadata() {
        return this.getMetaDataElementRoot().getElement("PRODUCT_METADATA");
    }

    @Override
    public Dimension getReflectanceDim() {
        return this.getDimension("REFLECTIVE_SAMPLES", "REFLECTIVE_LINES");
    }

    @Override
    public Dimension getThermalDim() {
        return this.getDimension("THERMAL_SAMPLES", "THERMAL_LINES");
    }

    @Override
    public Dimension getPanchromaticDim() {
        return this.getDimension("PANCHROMATIC_SAMPLES", "PANCHROMATIC_LINES");
    }

    @Override
    public String getProductType() {
        return this.getProductType("DATA_TYPE");
    }

    @Override
    public double getScalingFactor(String bandId) {
        return this.getScalingFactor(bandId, "MIN_MAX_RADIANCE", "RADIANCE_MINIMUM_BAND_", "RADIANCE_MAXIMUM_BAND_", "MIN_MAX_PIXEL_VALUE", "QUANTIZE_CAL_MIN_BAND_", "QUANTIZE_CAL_MAX_BAND_");
    }

    @Override
    public double getScalingOffset(String bandId) {
        return this.getScalingOffset(bandId, "MIN_MAX_RADIANCE", "RADIANCE_MINIMUM_BAND_", "RADIANCE_MAXIMUM_BAND_", "MIN_MAX_PIXEL_VALUE", "QUANTIZE_CAL_MIN_BAND_", "QUANTIZE_CAL_MAX_BAND_");
    }

    @Override
    public ProductData.UTC getCenterTime() {
        return this.getCenterTime("DATE_ACQUIRED", "SCENE_CENTER_TIME");
    }

    @Override
    public Pattern getOpticalBandFileNamePattern() {
        return Pattern.compile("FILE_NAME_BAND_(\\d{1,2})");
    }

    @Override
    public String getQualityBandNameKey() {
        return "FILE_NAME_BAND_QUALITY";
    }

    @Override
    public float getWavelength(String bandIndexNumber) {
        int index = Landsat8Metadata.getIndex(bandIndexNumber);
        return WAVELENGTHS[index];
    }

    @Override
    public float getBandwidth(String bandIndexNumber) {
        int index = Landsat8Metadata.getIndex(bandIndexNumber);
        return BANDWIDTHS[index];
    }

    @Override
    public String getBandDescription(String bandNumber) {
        int index = Landsat8Metadata.getIndex(bandNumber);
        return BAND_DESCRIPTIONS[index];
    }

    @Override
    public String getBandNamePrefix(String bandNumber) {
        int index = Landsat8Metadata.getIndex(bandNumber);
        return BAND_NAMES[index];
    }

    private static int getIndex(String bandIndexNumber) {
        return Integer.parseInt(bandIndexNumber) - 1;
    }
}

