/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat.geotiff;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.esa.beam.dataio.landsat.geotiff.LandsatMetadata;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.ProductData;

abstract class AbstractLandsatMetadata
implements LandsatMetadata {
    private final MetadataElement root;

    public AbstractLandsatMetadata(Reader fileReader) throws IOException {
        this.root = this.parseMTL(fileReader);
    }

    public AbstractLandsatMetadata(MetadataElement root) throws IOException {
        this.root = root;
    }

    @Override
    public MetadataElement getMetaDataElementRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MetadataElement parseMTL(Reader mtlReader) throws IOException {
        MetadataElement base = null;
        MetadataElement currentElement = null;
        try (BufferedReader reader = new BufferedReader(mtlReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("GROUP")) {
                    int i = line.indexOf(61);
                    String groupName = line.substring(i + 1).trim();
                    MetadataElement element = new MetadataElement(groupName);
                    if (base == null) {
                        base = element;
                        currentElement = element;
                        continue;
                    }
                    currentElement.addElement(element);
                    currentElement = element;
                    continue;
                }
                if (line.startsWith("END_GROUP") && currentElement != null) {
                    currentElement = currentElement.getParentElement();
                    continue;
                }
                if (line.equals("END")) {
                    MetadataElement i = base;
                    return i;
                }
                if (currentElement == null) continue;
                MetadataAttribute attribute = AbstractLandsatMetadata.createAttribute(line);
                currentElement.addAttribute(attribute);
            }
        }
        return base;
    }

    private static MetadataAttribute createAttribute(String line) {
        ProductData pData;
        int i = line.indexOf(61);
        String name = line.substring(0, i).trim();
        String value = line.substring(i + 1).trim();
        if (value.startsWith("\"")) {
            value = value.substring(1, value.length() - 1);
            pData = ProductData.createInstance((String)value);
        } else if (value.contains(".")) {
            try {
                double d = Double.parseDouble(value);
                pData = ProductData.createInstance((double[])new double[]{d});
            }
            catch (NumberFormatException e) {
                pData = ProductData.createInstance((String)value);
            }
        } else {
            try {
                int integer = Integer.parseInt(value);
                pData = ProductData.createInstance((int[])new int[]{integer});
            }
            catch (NumberFormatException e) {
                pData = ProductData.createInstance((String)value);
            }
        }
        return new MetadataAttribute(name, pData, true);
    }

    protected Dimension getDimension(String widthAttributeName, String heightAttributeName) {
        MetadataElement metadata = this.getProductMetadata();
        MetadataAttribute widthAttribute = metadata.getAttribute(widthAttributeName);
        MetadataAttribute heightAttribute = metadata.getAttribute(heightAttributeName);
        if (widthAttribute != null && heightAttribute != null) {
            int width = widthAttribute.getData().getElemInt();
            int height = heightAttribute.getData().getElemInt();
            return new Dimension(width, height);
        }
        return null;
    }

    protected ProductData.UTC getCenterTime(String acquisitionDateKey, String sceneCenterScanTimeKey) {
        MetadataElement metadata = this.getProductMetadata();
        String dateString = metadata.getAttributeString(acquisitionDateKey);
        String timeString = metadata.getAttributeString(sceneCenterScanTimeKey);
        try {
            if (dateString != null && timeString != null) {
                timeString = timeString.substring(0, 12);
                DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd HH:mm:ss.SSS");
                Date date = dateFormat.parse(dateString + " " + timeString);
                String milliSeconds = timeString.substring(timeString.length() - 3);
                return ProductData.UTC.create((Date)date, (long)(Long.parseLong(milliSeconds) * 1000L));
            }
        }
        catch (ParseException ignored) {
            // empty catch block
        }
        return null;
    }

    protected String getProductType(String productTypeKey) {
        MetadataAttribute product_type = this.getProductMetadata().getAttribute(productTypeKey);
        MetadataAttribute spacecraft_id = this.getProductMetadata().getAttribute("SPACECRAFT_ID");
        MetadataAttribute sensor_id = this.getProductMetadata().getAttribute("SENSOR_ID");
        StringBuilder result = new StringBuilder();
        result.append(spacecraft_id.getData().getElemString());
        result.append("_");
        result.append(sensor_id.getData().getElemString());
        result.append("_");
        result.append(product_type.getData().getElemString());
        return result.toString();
    }

    protected double getScalingFactor(String bandId, String minMaxRadianceKey, String minRadianceBandPrefix, String maxRadianceBandPrefix, String minMaxPixelValueKey, String minPixelValuePrefix, String maxPixelValuePrefix) {
        try {
            MetadataElement minMaxRadiance = this.getMetaDataElementRoot().getElement(minMaxRadianceKey);
            double lMax = minMaxRadiance.getAttributeDouble(maxRadianceBandPrefix + bandId);
            double lMin = minMaxRadiance.getAttributeDouble(minRadianceBandPrefix + bandId);
            MetadataElement minMaxPixels = this.getMetaDataElementRoot().getElement(minMaxPixelValueKey);
            double qMin = minMaxPixels.getAttributeDouble(minPixelValuePrefix + bandId);
            double qMax = minMaxPixels.getAttributeDouble(maxPixelValuePrefix + bandId);
            return (lMax - lMin) / (qMax - qMin);
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    protected double getScalingOffset(String bandId, String minMaxRadianceKey, String minRadianceBandPrefix, String maxRadianceBandPrefix, String minMaxPixelValueKey, String minPixelValuePrefix, String maxPixelValuePrefix) {
        try {
            MetadataElement minMaxRadiance = this.getMetaDataElementRoot().getElement(minMaxRadianceKey);
            double lMax = minMaxRadiance.getAttributeDouble(maxRadianceBandPrefix + bandId);
            double lMin = minMaxRadiance.getAttributeDouble(minRadianceBandPrefix + bandId);
            MetadataElement minMaxPixels = this.getMetaDataElementRoot().getElement(minMaxPixelValueKey);
            double qMax = minMaxPixels.getAttributeDouble(maxPixelValuePrefix + bandId);
            double qMin = minMaxPixels.getAttributeDouble(minPixelValuePrefix + bandId);
            return lMin - (lMax - lMin) / (qMax - qMin) * qMin;
        }
        catch (Exception e) {
            return 0.0;
        }
    }
}

