/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.landsat;

import java.io.File;
import java.util.Locale;
import org.esa.beam.dataio.landsat.LandsatConstants;
import org.esa.beam.dataio.landsat.LandsatTMFile;
import org.esa.beam.dataio.landsat.LandsatTMReader;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.util.io.BeamFileFilter;

public final class LandsatTMReaderPlugIn
implements ProductReaderPlugIn {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DecodeQualification getDecodeQualification(Object input) {
        try (LandsatTMFile file = null;){
            if (input instanceof String) {
                file = new LandsatTMFile((String)input);
            } else if (input instanceof File) {
                file = new LandsatTMFile((File)input);
            } else {
                DecodeQualification decodeQualification = DecodeQualification.UNABLE;
                return decodeQualification;
            }
            if (file.canDecodeInput()) {
                DecodeQualification decodeQualification = DecodeQualification.INTENDED;
                return decodeQualification;
            }
        }
        return DecodeQualification.UNABLE;
    }

    public static File getInputFile(Object input) {
        File file = null;
        if (input instanceof String) {
            file = new File((String)input);
        } else if (input instanceof File) {
            file = (File)input;
        }
        return file;
    }

    public final Class[] getInputTypes() {
        return LandsatConstants.INPUT_TYPES;
    }

    public final ProductReader createReaderInstance() {
        return new LandsatTMReader(this);
    }

    public BeamFileFilter getProductFileFilter() {
        return new BeamFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(Locale.getDefault()));
    }

    public final String[] getFormatNames() {
        return LandsatConstants.FILE_NAMES;
    }

    public final String[] getDefaultFileExtensions() {
        return LandsatConstants.LANDSAT_EXTENSIONS;
    }

    public final String getDescription(Locale locale) {
        return "Landsat 5 TM Product Reader";
    }
}

